
#include <stdio.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/select.h>
#include <fcntl.h>

#include <string.h>

#include <errno.h>

//#define BUF_LEN (512)
#define BUF_LEN (0x3cf + 1)

static void dumpmsg(char *msg, int length) {

  char str[BUF_LEN*4];
  int i = 0;
  int j = 0;

  memset(str, 0x00, BUF_LEN*4);
  
  for ( i = 0; i < length; i++) {
    if ((i % 16) == 0 && i != 0) {
      sprintf(&str[j], "%s", "\n");
      j++;
    }
    sprintf(&str[j], "%02x ", msg[i]);
    j += 3;
  }

  //FORCE_DPRINTK("msg: %s\n", str);
  printf("%s\n", str);
  
}


void main(int argc, char **argv) {

	int fd;
	int n;
	fd_set readfds;
	char readbuf[BUF_LEN];
	int readed;

	fd = open("/dev/nfc", O_RDWR);
	if (fd < 0) {
	  fprintf(stderr, "cannot open /dev/nfc \n");
	  return;
	}
	printf("open /dev/nfc: %d\n", fd);

	FD_ZERO(&readfds);
	FD_SET(fd, &readfds);

	memset(readbuf, 0x00, BUF_LEN);
	errno = 0;
	readed = read(fd, readbuf, BUF_LEN);
	
	if (readed > 0) {
	  /* use readbuf data*/
	  printf("readed data: %d\n", readed);
	  dumpmsg(readbuf, BUF_LEN);
	}
	else {
	  //printf("read return without data");
	  printf("read return %d : %s\n", errno, strerror(errno));
	}
}
