#include <stdio.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/select.h>
#include <fcntl.h>

#include <string.h>


static void dumpmsg(char *msg, int length) {

  char str[1024];
  int i = 0;
  int j = 0;

  memset(str, 0x00, 1024);
  
  for ( i = 0; i < length; i++) {
    sprintf(&str[j], "%02x ", msg[i]);
    j += 3;
  }

  //FORCE_DPRINTK("msg: %s\n", str);
  printf("%s\n", str);
  
}


void main(int argc, char **argv) {

  int fd;
  int n;
  fd_set readfds;
  char readbuf[128];
  int readed;

  fd = open("/dev/nfc", O_RDWR);
  if (fd < 0) {
    fprintf(stderr, "cannot open /dev/nfc \n");
    return;
  }
  printf("open /dev/nfc: %d\n", fd);

  FD_ZERO(&readfds);
  FD_SET(fd, &readfds);
  
  n = select(fd+1, &readfds, NULL, NULL, NULL);
  printf("select return! n: %d\n", n);
  if (n > 0) {
    memset(readbuf, 0x00, 128);
    readed = read(fd, readbuf, 128);
    
    if (readed > 0) {
      /* use readbuf data*/
      printf("readed data: %d\n", readed);
      dumpmsg(readbuf, readed);
    }
    else {
      printf("read return without data");
    }
  }
  else {
    printf("poll return without readable device\n");
  }
}
