/***** -*- mode: C; encodeing: utf-8 -*- **************************************
 * $Id$
 *
 * Copyright (C) 2016 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : 
 *	 PROGRAM NAME	 : 
 *	 FILE NAME		 : nfc.h
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : WAKABAYASHI, Ayumu
 *	 AUTHOR 		 : $Author$
 ******************************************************/
#ifndef _NFC_H_
#define _NFC_H_

#include <stddef.h>
#include <linux/ctype.h>
#include <linux/kernel.h>

/*----------------------------------------
 * Debug Macros
 *----------------------------------------*/
#define FORCE_DPRINTK(fmt, ...) { printk( fmt,  ##__VA_ARGS__ ); }

//#define NFC_DEBUG
#ifdef NFC_DEBUG
#define DPRINTK(fmt, args...) FORCE_DPRINTK("%s: " fmt, __FUNCTION__ , ## args)
#define FUNC_START	  FORCE_DPRINTK("%s start\n",__FUNCTION__)
#define FUNC_END	  FORCE_DPRINTK("%s end\n",__FUNCTION__)
#define FUNC_ERR	  FORCE_DPRINTK(KERN_ERR"%s :: %d :: %s  err= %d \n", __FILE__, __LINE__, __FUNCTION__, err)
#else				/* NFC_DEBUG */
#define DPRINTK(fmt, args...)	do {} while(0)
#define FUNC_START				do {} while(0)
#define FUNC_END				do {} while(0)
#define FUNC_ERR				do {} while(0)
#endif				/* NFC_DEBUG */

#define VT100_PRE		"\033[38;5;"
#define VT100_ULPRE		"\033[4;38;5;"
#define VT100_POST		"m"
#define VT100_COLOR(num)	VT100_PRE #num VT100_POST
#define VT100_COLOR_UL(num)	VT100_ULPRE #num VT100_POST
#define VT100_NORM		"\033[m"	/* normal */
#define VT100_BOLD		"\033[1m"	/* bold */
#define VT100_RED		"\033[1;31m"	/* Red */
#define VT100_GREEN		"\033[1;32m"	/* Green */
#define VT100_YELLOW	"\033[1;33m"	/* Yellow */
#define VT100_BLUE		"\033[1;34m"	/* Blue */
#define VT100_PURPLE	"\033[1;35m"	/* Purple */
#define VT100_RICHBLUE		VT100_COLOR(33)
#define VT100_ULRICHBLUE	VT100_COLOR_UL(33)
#define VT100_CRIMSON		VT100_COLOR(161)
#define VT100_CHOCOLATE		VT100_COLOR(166)
#define VT100_GOLD			VT100_COLOR(178)
#define VT100_ULGOLD		VT100_COLOR_UL(178)
#define VT100_GRAY			VT100_COLOR(247)
#define VT100_ULGRAY		VT100_COLOR_UL(247)
#define VT100_ULGREEN		VT100_COLOR_UL(2)

#define NFC_NAME "ricoh_nfc"
#define NFC_DEVICE_NAME "nfc"

#define NFC_I2C_CHANNEL (1)
#define NFC_I2C_WR_ADDR (0x54)

#define I2C_SEND_BUF_SIZE (16)
#define I2C_RECV_BUF_SIZE (32)
#define I2C_ACK_BUF_SIZE (3)

// GPIOE[11] a.k.a 32*4+11
#define NFC_IRQ_GPIO_NO (139)

#define NFC_DATA_ADDR   (0x0000)
#define NFC_SYSTEM_ADDR (0x01d0)
#define NFC_READ_CMD    (0x08)
#define NFC_WRITE_CMD   (0x18)
#define NFC_RREG_CMD    (0x68)
#define NFC_WREG_CMD    (0x78)
#define NFC_STATUS_CMD    (0xff)

#define NFC_SYSTEM_AREA_ADDR (0x3d0)
#define NFC_SYSTEM_AREA_LEN (0x30)

#define NFC_WQUEUE_NAME "NFC_WQUEUE"
#define NFC_INTERRUPT_DEVICE_NAME "nfc_interrupt"

#define NFC_WAKEUP_TIME_MSEC (3)

//250msec
#define RF_WRITE_DATA_TIMEOUT (HZ/4)
//3sec
#define IRQ_WAIT_TIMEOUT (HZ*3)
//#define IRQ_WAIT_TIMEOUT (HZ*10000)

// check NIRQ when int handler called. -1 is inf
#define CHECK_NIRQ_MAX_COUNT (-1)
// check NIRQ count per 10ms when int handler called
#define CHECK_NIRQ_MAX_COUNT_PER_INT_HANDLER (12)

/* Input device driver private data */
typedef struct nfc_priv {
	struct i2c_client *nfc_client;
	int nfc_irq;
	int nfc_major;
	int nfc_minor;
	struct class *nfc_class;
	struct cdev c_dev;
} nfc_priv_t;

/* Workqueue for nfc bottom half task */
typedef struct workqueue_struct workqueue_struct_t;
typedef struct work_struct work_struct_t;
typedef struct nfc_work {
	work_struct_t nfc_work;
	nfc_priv_t *priv;
} nfc_work_t;

typedef enum {
	NFC_FALSE = 0,
	NFC_TRUE = 1,
} NFC_BOOLEAN;

typedef enum {
	IDLE = 0,
	RF_WRITING_DATA,
	DATA_AVAILABLE,
	HOST_WRITING_DATA,
	HOST_READING_DATA,
} NFC_STATUS;

#endif				/* _NFC_H_ */
