/***** -*- mode: C; encodeing: utf-8 -*- **************************************
 * $Id$
 *
 * Copyright (C) 2016 Ricoh Company, Ltd.  All Rights Reserved.
 *	 ORDER			 : 
 *	 PROGRAM NAME	 : 
 *	 FILE NAME		 : am.c
 *	 VERSION		 : $Revision$
 *	 DESIGNER		 : WAKABAYASHI, Ayumu
 *	 AUTHOR 		 : $Author$
 ******************************************************/

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/input.h>
#include <linux/i2c.h>
#include <linux/gpio.h>
#include <linux/errno.h>
#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/module.h>
#include <linux/device.h>
#include <linux/cdev.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/timer.h>
#include <linux/platform_device.h>
#include <linux/syscalls.h>
#include <linux/clk.h>
#include <linux/slab.h>
#include <linux/workqueue.h>
#include <linux/kthread.h>
#include <linux/semaphore.h>
#include <asm/gpio.h>
#include <asm/io.h>

#include "am.h"
#include "nfc.h"
static NFC_STATUS drv_status;
DEFINE_MUTEX(transfer_mutex);
char *NFC_STATUS_NAMES[] =
    { "IDLE", "RF_WRITING_DATA", "DATA_AVAILABLE", "HOST_WRITING_DATA",
	"HOST_READING_DATA"
};

char *get_nfc_status_name(int id)
{
	return NFC_STATUS_NAMES[id];
}

void dump_from_to_status(int from, int to)
{
#ifdef NFC_DEBUG
	char *from_name = get_nfc_status_name(from);
	char *to_name = get_nfc_status_name(to);
	DPRINTK("%s ==> %s \n", from_name, to_name);
#endif
}

void dump_illegal_state(const char *func, int state)
{
	char *state_name = get_nfc_status_name(state);
#ifdef NFC_DEBUG
	FORCE_DPRINTK(KERN_EMERG VT100_RED
		      "**** illegal state transfer: %s %s \n" VT100_NORM, func,
		      state_name);
#else
	FORCE_DPRINTK("**** illegal state transfer: %s %s \n",
		      func, state_name);
#endif

}

int am_receive_data_from_rf_start()
{
	int rc = -1;
	int prev;
	prev = drv_status;
	mutex_lock(&transfer_mutex);
	switch (drv_status) {
	case IDLE:
		drv_status = RF_WRITING_DATA;
		dump_from_to_status(prev, drv_status);
		rc = 0;
		break;
	case RF_WRITING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case DATA_AVAILABLE:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case HOST_WRITING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case HOST_READING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	default:
		FORCE_DPRINTK("***** unknown drv_status for transfer *****\n");
		break;
	}
	mutex_unlock(&transfer_mutex);
	return rc;
}

int am_receive_data_from_rf_complete()
{
	int rc = -1;
	int prev;
	prev = drv_status;
	mutex_lock(&transfer_mutex);
	switch (drv_status) {
	case IDLE:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case RF_WRITING_DATA:
		drv_status = DATA_AVAILABLE;
		dump_from_to_status(prev, drv_status);
		rc = 0;
		break;
	case DATA_AVAILABLE:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case HOST_WRITING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case HOST_READING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	default:
		FORCE_DPRINTK("***** unknown drv_status for transfer *****\n");
		break;
	}
	mutex_unlock(&transfer_mutex);
	return rc;
}

int am_read_data_start()
{
	int rc = -1;
	int prev;
	prev = drv_status;
	mutex_lock(&transfer_mutex);
	switch (drv_status) {
	case IDLE:
		drv_status = HOST_READING_DATA;
		dump_from_to_status(prev, drv_status);
		rc = 0;
		break;
	case RF_WRITING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case DATA_AVAILABLE:
		rc = 0;
		dump_from_to_status(prev, drv_status);
		break;
	case HOST_WRITING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case HOST_READING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	default:
		FORCE_DPRINTK("***** unknown drv_status for transfer *****\n");
		break;
	}
	mutex_unlock(&transfer_mutex);
	return rc;
}

int am_read_data_complete()
{
	int rc = -1;
	int prev;
	prev = drv_status;
	mutex_lock(&transfer_mutex);
	switch (drv_status) {
	case IDLE:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case RF_WRITING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case DATA_AVAILABLE:
		drv_status = IDLE;
		dump_from_to_status(prev, drv_status);
		rc = 0;
		break;
	case HOST_WRITING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case HOST_READING_DATA:
		drv_status = IDLE;
		dump_from_to_status(prev, drv_status);
		rc = 0;
		break;
	default:
		FORCE_DPRINTK("***** unknown drv_status for transfer *****\n");
		break;
	}
	mutex_unlock(&transfer_mutex);
	return rc;
}

int am_write_data_start()
{
	int rc = -1;
	int prev;
	prev = drv_status;
	mutex_lock(&transfer_mutex);
	switch (drv_status) {
	case IDLE:
		drv_status = HOST_WRITING_DATA;
		dump_from_to_status(prev, drv_status);

		//FORCE_DPRINTK("***** transfer %d %d *****\n", prev, drv_status);
		rc = 0;
		break;
	case RF_WRITING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case DATA_AVAILABLE:
		drv_status = HOST_WRITING_DATA;
		dump_from_to_status(prev, drv_status);
		rc = 0;
		break;
	case HOST_WRITING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case HOST_READING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	default:
		FORCE_DPRINTK("***** unknown drv_status for transfer *****\n");
		break;
	}
	mutex_unlock(&transfer_mutex);
	return rc;
}

int am_write_data_complete()
{
	int rc = -1;
	int prev;
	prev = drv_status;
	mutex_lock(&transfer_mutex);
	switch (drv_status) {
	case IDLE:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case RF_WRITING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case DATA_AVAILABLE:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	case HOST_WRITING_DATA:
		drv_status = IDLE;
		dump_from_to_status(prev, drv_status);
		rc = 0;
		break;
	case HOST_READING_DATA:
		dump_illegal_state(__func__, drv_status);
		rc = -1;
		break;
	default:
		FORCE_DPRINTK("***** unknown drv_status for transfer *****\n");
		break;
	}
	mutex_unlock(&transfer_mutex);
	return rc;
}

NFC_BOOLEAN am_is_data_available()
{
	int rc = NFC_FALSE;
	if (DATA_AVAILABLE == drv_status) {
		rc = NFC_TRUE;
	}
	return rc;
}

NFC_BOOLEAN am_is_idle()
{
	int rc = NFC_FALSE;
	if (IDLE == drv_status) {
		rc = NFC_TRUE;
	}
	return rc;
}

NFC_BOOLEAN am_is_rf_writing_data()
{
	int rc = NFC_FALSE;
	if (RF_WRITING_DATA == drv_status) {
		rc = NFC_TRUE;
	}
	return rc;
}
