/*
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
*/
/**
 * \file low_power_idle_defaults.h
 *
 * \brief The defaults values for various power controls.
 *
 **/

#ifndef INC_LPI_DEFAULTS_H
#define INC_LPI_DEFAULTS_H

// HSR (MC pad PD), bypass DDR PLL
#define LP_LPP_FLAGS_SLEEP_HSR_D        (LP_FLAGS_DDR_SR | LP_FLAGS_DDR_PLL_BP | LP_FLAGS_DDR_HALT_MC | LP_FLAGS_DDR_MC_PAD )
// HSR (MC pad PD), bypass DDR PLL + GATE SYC CLK
#define LP_LPP_FLAGS_SLEEP_HSR_DS       (LP_LPP_FLAGS_SLEEP_HSR_D | LP_FLAGS_LPP_CLK_DIV_SET(2) | LP_FLAGS_SYS_CLK_GATE)
#define LP_LPP_FLAGS_SLEEP_HSR_DSC      (LP_LPP_FLAGS_SLEEP_HSR_D | LP_FLAGS_LPP_CLK_DIV_SET(2) | LP_FLAGS_SYS_CLK_GATE | LP_FLAGS_CORE_PLL_BP)
// HSR (MC pad PD), bypass DDR PLL + GATE SYC CLK + bypass CORE PLL and change AVS
#define LP_LPP_FLAGS_SLEEP_HSR_DSCA     (LP_LPP_FLAGS_SLEEP_HSR_D | LP_FLAGS_LPP_CLK_DIV_SET(2) | LP_FLAGS_SYS_CLK_GATE | LP_FLAGS_CORE_PLL_BP | LP_FLAGS_AVS_CONTROL )
// HSR (MC pad PD), bypass/PD DDR PLL + GATE SYC CLK BY/PD + bypass/PD CORE PLL and change AVS
#define LP_LPP_FLAGS_SLEEP_HSR_DDSDCD   (LP_LPP_FLAGS_SLEEP_HSR_D | LP_FLAGS_LPP_CLK_DIV_SET(2) | LP_FLAGS_SYS_PLL_PD   | LP_FLAGS_CORE_PLL_PD | LP_FLAGS_DDR_PLL_PD)
#define LP_LPP_FLAGS_SLEEP_HSR_DDSDCDA  (LP_LPP_FLAGS_SLEEP_HSR_DDSDCD | LP_FLAGS_AVS_CONTROL)
// SR  (MC pad PD), BP+PD DDR PLL
#define LP_LPP_FLAGS_SLEEP_SR_D         (LP_FLAGS_DDR_SR | LP_FLAGS_DDR_PLL_PD | LP_FLAGS_DDR_MC_PAD )
// SR  (MC pad PD), BP+PD DDR PLL + GATE SYC CLK + bypass CORE PLL and change AVS
#define LP_LPP_FLAGS_SLEEP_SR_DSC       (LP_LPP_FLAGS_SLEEP_SR_D | LP_FLAGS_LPP_CLK_DIV_SET(2) | LP_FLAGS_SYS_CLK_GATE | LP_FLAGS_CORE_PLL_PD )
#define LP_LPP_FLAGS_SLEEP_SR_DSCA      (LP_LPP_FLAGS_SLEEP_SR_DSC | LP_FLAGS_AVS_CONTROL )
#define LP_LPP_FLAGS_SLEEP_SR_DDSDCDA   (LP_LPP_FLAGS_SLEEP_SR_DSC | LP_FLAGS_AVS_CONTROL | LP_FLAGS_SYS_PLL_PD)

#define LP_LPP_FLAGS_DEBUG_FULL         (0x00004f3f)    // This is TEMP DEBUG, REMOVE OVER TIME!  This PD LVDS pads, LVDS & scan PLL
#define LP_LPP_FLAGS_DEBUG_XSYSPLL      (0x00004f3c)    // This is TEMP DEBUG, REMOVE OVER TIME!  This PD LVDS pads, LVDS & scan PLL
#define LP_LPP_FLAGS_DEBUG_NONE         (0x00000000)

//#define LP_LPP_FLAGS_MC_DEFAULT         (0x00001fd0)
#define LP_LPP_FLAGS_MC_DEFAULT         (0x00000fd0)
#define LP_LPP_FLAGS_AVS_DEFAULT        (0x00001000)    // AVS INTO reset, will default to 1.05V

#define LP_AP_FLAGS_DEFAULT             (LP_FLAGS_DDR_AUTO_SR )
#define LP_AP_AUTO_SR_IDLE_CLKS         0x000100
#define LP_AP_LIGHT_DEFAULT             false


#define LP_LPP_FLAGS_DEEP_SLEEP         (LP_LPP_FLAGS_SLEEP_HSR_DSC)
#define LP_LPP_FLAGS_DEEP_SERVICE       (0)
#define LP_LPP_FLAGS_DEEP_GLOBAL        (0x00130C00)    // optimize poll; IDLE=(WFI && MC IDLE); skip GPIO driver; Default LPP will SYNC to AP
#if (DEBUG==1)
#define LP_LPP_FLAGS_DEEP_DBG           (LP_LPP_FLAGS_DEBUG_XSYSPLL)    // This is TEMP DEBUG, REMOVE OVER TIME!
#else
#define LP_LPP_FLAGS_DEEP_DBG           (LP_LPP_FLAGS_DEBUG_NONE)
#endif
#define LP_LPP_FLAGS_DEEP_MC            (LP_LPP_FLAGS_MC_DEFAULT )

#define LP_LPP_FLAGS_SUSPEND_SLEEP         (LP_LPP_FLAGS_SLEEP_HSR_DDSDCD | LP_FLAGS_CORE0_PD)
#define LP_LPP_FLAGS_SUSPEND_SERVICE       (0)
#define LP_LPP_FLAGS_SUSPEND_GLOBAL        (0x00130C00)    // optimize poll; IDLE=(WFI && MC IDLE); skip GPIO driver; Default LPP will SYNC to AP
#if (DEBUG==1)
#define LP_LPP_FLAGS_SUSPEND_DBG           (LP_LPP_FLAGS_DEBUG_XSYSPLL)    // This is TEMP DEBUG, REMOVE OVER TIME!
#else
#define LP_LPP_FLAGS_SUSPEND_DBG           (LP_LPP_FLAGS_DEBUG_NONE)
#endif
#define LP_LPP_FLAGS_SUSPEND_MC            (LP_LPP_FLAGS_MC_DEFAULT )

#define LP_LPP_FLAGS_HIBERNATE_SLEEP    (LP_LPP_FLAGS_SLEEP_SR_DDSDCDA | LP_FLAGS_CORE0_PD)
#define LP_LPP_FLAGS_HIBERNATE_SERVICE  (LP_LPP_FLAGS_HIBERNATE_SLEEP)
#define LP_LPP_FLAGS_HIBERNATE_GLOBAL   (0x00000204)    // Default LPP will SYNC to AP
#define LP_LPP_FLAGS_HIBERNATE_DBG      (LP_LPP_FLAGS_DEBUG_XSYSPLL)    // This is TEMP DEBUG, REMOVE OVER TIME!
#define LP_LPP_FLAGS_HIBERNATE_MC       (LP_LPP_FLAGS_MC_DEFAULT )

#define LP_LPP_FLAGS_SOFTOFF_SLEEP      (LP_LPP_FLAGS_SLEEP_SR_DDSDCDA | LP_FLAGS_CORE0_PD)
#define LP_LPP_FLAGS_SOFTOFF_SERVICE    (LP_LPP_FLAGS_SOFTOFF_SLEEP)
#define LP_LPP_FLAGS_SOFTOFF_GLOBAL     (0x00000205)    // Default LPP will SYNC to AP
#define LP_LPP_FLAGS_SOFTOFF_DBG        (LP_LPP_FLAGS_DEBUG_XSYSPLL)    // This is TEMP DEBUG, REMOVE OVER TIME!
#define LP_LPP_FLAGS_SOFTOFF_MC         (LP_LPP_FLAGS_MC_DEFAULT | 0x00001021)    // add DDR nReset (phy14_nrst) & phy17_vreg & ddr_clk
                                                        //
#define LP_LPP_TEST_SOFTOFF_WAKE_TIMER  (120 * 100)      // 120 seconds in 10ms ticks
#define LP_LPP_TEST_SOFTOFF_WAKE_GPIO_0 (LPI_GPIO_PIN(4,1,26))  // bank 4(E), Ack interrupt, pin 26
#define LP_LPP_TEST_SOFTOFF_WAKE_INT_0  (37 | 0x100000) // RTC alarm 1, shared MPMU interrupt
#define LP_LPP_TEST_SOFTOFF_WAKE_INT_1  (37 | 0x200000) // RTC alarm 2, shared MPMU interrupt
//#define LP_LPP_TEST_SOFTOFF_WAKE_INT_2  (48)            // UART 1 (from intnums.h)
//#define LP_LPP_TEST_SOFTOFF_WAKE_INT_3  (xy)            // ?? (from intnums.h)

#define LP_LPP_TEST_HIBERNATE_WAKE_TIMER  (120 * 100)      // 120 seconds in 10ms ticks
#define LP_LPP_TEST_HIBERNATE_WAKE_GPIO_0 (LPI_GPIO_PIN(4,1,26))  // bank 4(E), Ack interrupt, pin 26
#define LP_LPP_TEST_HIBERNATE_WAKE_INT_0  (37 | 0x100000) // RTC alarm 1, shared MPMU interrupt
#define LP_LPP_TEST_HIBERNATE_WAKE_INT_1  (37 | 0x200000) // RTC alarm 2, shared MPMU interrupt
#define LP_LPP_TEST_HIBERNATE_WAKE_INT_2  (48)            // UART 1 (from intnums.h)

#define LP_LPP_SUSPEND_DEFAULT_WAKE_INT_0 (47)            // MAC (from intnums.h)
#define LP_LPP_SUSPEND_DEFAULT_WAKE_INT_1 (48)            // UART 1 (from intnums.h)

#endif   // #ifndef INC_LPI_DEFAULTS_H

