/*
 * Common definitions and parameters of watchdog drivers that support
 * pretimeout mechanics.
 *
 * This file is licensed under  the terms of the GNU General Public
 * License version 2. This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */

/* True if watchdog pre-timeout is enabled */
bool watchdog_pretimeout_enabled(void);

/* True if watchdog_pretimeout_handle will hang forever */
bool watchdog_pretimeout_will_hang(void);

/* What percent of the watchdog timeout to fire the pre-timeout */
int watchdog_pretimeout_percent(void);

/* Override the hang function */
void watchdog_pretimeout_set_hang_fn(void (*hang_fn)(void));

/* Handle a watchdog pre-timeout */
void watchdog_pretimeout_handle(void);
