/*
******************************************************************************
* (c) Copyright 2015-2016 Marvell International Ltd.
******************************************************************************
* pegmatite DWMAC specific glue layer
*
* Marvell GPL License
*
* This File is licensed to you in accordance with the terms and conditions of
* the General Public License Version 2, June 1991 (the "GPL License"). You
* can redistribute it and/or modify it under the terms of the GPL License.
*
* This program is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE. See the GPL License for more details.
*
* You should have received a copy of the GNU General Public License along with
* this program. If not, see
* http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
*
******************************************************************************
*/

#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/platform_device.h>
#include <linux/stmmac.h>
#include <linux/io.h>
#include <linux/delay.h>

#define PHY_CONFIG 0x14
#define PHY_RESET (1 << 28)

struct pegmatite_priv {
	void __iomem *base;
};

static int pegmatite_init(struct platform_device *pdev, void *priv)
{
	struct pegmatite_priv *p = priv;
	u32 val;

	val = readl(p->base + PHY_CONFIG);
	val |= PHY_RESET;
	writel(val, p->base + PHY_CONFIG);

	msleep(15);

	val &= ~PHY_RESET;
	writel(val, p->base + PHY_CONFIG);

	msleep(15);

	val |= PHY_RESET;
	writel(val, p->base + PHY_CONFIG);

	msleep(15);

	return 0;
}

static void pegmatite_exit(struct platform_device *pdev, void *priv)
{
	struct pegmatite_priv *p = priv;
	u32 val;

	val = readl(p->base + PHY_CONFIG);
	val &= ~PHY_RESET;
	writel(val, p->base + PHY_CONFIG);
}

static void *pegmatite_dwmac_setup(struct platform_device *pdev)
{
	struct resource *res;
	struct pegmatite_priv *priv;

	priv = devm_kzalloc(&pdev->dev, sizeof(*priv), GFP_KERNEL);
	if (!priv)
		return NULL;

	res = platform_get_resource_byname(pdev, IORESOURCE_MEM, "marvell,int-phy");
	priv->base = devm_ioremap_resource(&pdev->dev, res);
	if (IS_ERR(priv->base))
		return NULL;

	return priv;
}

const struct stmmac_of_data pegmatite_dwmac_data = {
	.setup = pegmatite_dwmac_setup,
	.init = pegmatite_init,
	.exit = pegmatite_exit,
};
