#include <linux/kernel.h>
#include <linux/smp.h>
#include <linux/io.h>
#include <linux/time.h>
#include <linux/cpumask.h>

#include <asm/cacheflush.h>
#include <asm/cp15.h>
#include <asm/smp_plat.h>

#include "apmu.h"

/*
 * platform-specific code to shutdown a CPU
 *
 * Called with IRQs disabled
 */
void __ref notrace pegmatite_cpu_die(unsigned int cpu)
{
        if (cpu == 0) flush_cache_all();
	/*
	 * Flush cache and disable coherency
	 *
	 * Copied from v7_exit_coherency_flush and modified for SMPEN in the
	 * CPUECTLR register.
	 *
	 * Note this is CPU-specific and only intended for the powerdown path.
	 *
	 */
	asm volatile(
	"stmfd	sp!, {fp, ip} \n\t" \
	"dsb	\n\t"
	"isb	\n\t"
	"mrc	p15, 0, r0, c1, c0, 0	@ get SCTLR \n\t"
	"bic	r0, r0, #"__stringify(CR_C)" \n\t"
	"mcr	p15, 0, r0, c1, c0, 0	@ set SCTLR \n\t"
	"isb	\n\t"
	"bl	v7_flush_dcache_louis \n\t"
	"mrrc	p15, 1, r0, r1, c15 \n\t"
	"bic	r0, r0, #(1 << 6)	@ disable local coherency \n\t"
	"mcrr	p15, 1, r0, r1, c15 \n\t"
	"isb	\n\t"
	"dsb	\n\t"
	"ldmfd	sp!, {fp, ip}"
	: : : "r0","r1","r2","r3","r4","r5","r6","r7",
	      "r9","r10","lr","memory" );

	/*
	 * Put the core into WFI until it is powered down
	 */
	for (;;)
		wfi();
}

/*
 * platform-specific code to power down a CPU
 */
int pegmatite_cpus_kill(const cpumask_t *cpus)
{
	ktime_t start = ktime_get();

	/*
	 * Make sure the CPUs are in wfi
	 */
	while (!pegmatite_check_wfi(cpus)) {
		if (WARN_ON(ktime_us_delta(ktime_get(), start) > 500000))
			return 0;
	}

	/*
	 * Power down the CPUs
	 */
	pegmatite_cores_powerdown(cpus);

	return 1;
}

