/*
 * Fabric support for Pegmatite platforms.
 *
 * This file is licensed under the terms of the GNU General Public
 * License version 2.  This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 *
 * The CPU interface controller provides various registers to configure
 * the various compute cores in the system
 */
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/of_address.h>
#include <linux/io.h>

static const struct of_device_id of_fabric_table[] = {
	{.compatible = "marvell,pegmatite-fabric"},
	{ /* end of list */ },
};

int __init pegmatite_fabric_init(void)
{
	u32 tmp;
	static void __iomem *fabric_base;
	struct device_node *np;

	pr_info("Initializing Pegmatite Fabric\n");

	for_each_matching_node(np, of_fabric_table) {
		fabric_base = of_iomap(np, 0);

		if (!of_property_read_u32(np, "fn-mod", &tmp))
			writel(tmp, fabric_base);

		iounmap(fabric_base);
	}

	return 0;
}
early_initcall(pegmatite_fabric_init);
