/*
 * ipctest2.c
 *
 *  Created on: 2015/03/23
 *      Author: sai495479
 */

#include <stdio.h>
#include <stdlib.h>

#include <fcntl.h>

#include <sys/sem.h>

#include <err.h>
#include <errno.h>
#include <unistd.h>

#include <pthread.h>

/* セマフォ操作 */
#define MFPRINTF_LOCK		(-1)
#define MFPRINTF_UNLOCK		1

/*
 * semget for mfprintf
 * 初回呼び出し元が不明でも複数プロセスから呼び出せるsemgetのラッパー
 * 初回は初期化を行い、次回からはただgetするだけ
 */
static inline int
_mfprintf_semget(int key)
{
	int semid = -1, rv;
	unsigned short vals[1] = {1};

	union semun {
		int		 val;
		struct semid_ds	 *buf;
		unsigned short	 *array;
	} ctl_arg;

	/* 引数検査 */
	if (key < 0) {
		return -EINVAL;
	}

	/* 初回作成要求 */
	if ((semid = semget(key, 1, IPC_CREAT | IPC_EXCL | 0777)) != -1) {
		/* セマフォ初期化 */
		ctl_arg.array = vals;
		if (semctl(semid, 0, SETALL, ctl_arg) == -1) {
			rv = -errno;
			warn("_mfprintf_semget:pid=%d, semctl key=%d",
			     getpid(), key);
			return rv;
		}
	} else {
		/* 既に存在していた？ */
		if (errno == EEXIST) {
			/* 再作成要求(初期化なし) */
			if ((semid = semget(key, 1, IPC_CREAT)) == -1) {
				rv = -errno;
				warn("_mfprintf_semget:pid=%d, resemget key=%d",
				     getpid(), key);
				return rv;
			}
		}else{
			/* 完全失敗 */
			rv = -errno;
			warn("_mfprintf_semget:pid=%d, semget failure key=%d",
			     getpid(), key);
			return rv;
		}
	}
	return semid;
}


/*
 * semop for mfprintf
 * セマフォ操作を行う
 */
static inline int
_mfprintf_semop(int semid, int op)
{
	struct sembuf	 sops[1];

	/* 引数検査 */
	if (semid < 0 ||
	    !((op == MFPRINTF_LOCK) || (op == MFPRINTF_UNLOCK))) {
		return -EINVAL;
	}

	sops[0].sem_num = 0;
	sops[0].sem_op = op;
	sops[0].sem_flg = SEM_UNDO;

	if (semop(semid, sops, 1) == -1) {
		int rv = -errno;
		warn( "_mfprintf_semop:pid=%d, failure id=%d, op=%d",
		      getpid(), semid, op);
		return rv;
	}
	return semid;
}

// write, read rsci cmd R4.1
// write, read leci cmd R4.2
// write, read rsci signal R4.3
// write, read leci signal R4.4
//CMD_SEM_KEY
//READ_SIGNAL_SEM_KEY
int write1(const char *devname, int semkey, char buf[4])
{
	int semid = -1;
	int fd;
	int size=-1;

	if ((semid = _mfprintf_semget(semkey)) == -1) {
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
		return -1;
	}
	if (_mfprintf_semop(semid, MFPRINTF_LOCK) == -1) {
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
		return -1;
	}

	fd = open(devname, O_WRONLY );
	if (fd < 0)
	{
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
	}

	printf("write %x,%x,%x,%x\n", buf[0], buf[1], buf[2], buf[3]);
	size = write(fd, buf, 4);
	printf("write ret %d\n", size);
	close(fd);

	_mfprintf_semop(semid, MFPRINTF_UNLOCK);
	return size;
}

//CMD_SEM_KEY
//READ_SIGNAL_SEM_KEY
int read1(const char *devname, int semkey, char buf[4])
{
	int semid = -1;
	int fd;
	int size=-1;

	if ((semid = _mfprintf_semget(semkey)) == -1) {
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
		return -1;
	}
	if (_mfprintf_semop(semid, MFPRINTF_LOCK) == -1) {
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
		return -1;
	}

	fd = open(devname, O_WRONLY );
	if (fd < 0)
	{
		printf("ERR! %s(%d)\n", __func__, __LINE__);
		exit(31);
	}

//	printf("read %x,%x,%x,%x\n", buf[0], buf[1], buf[2], buf[3]);
	size = read(fd, buf, 4);
//	printf("read ret %d\n", size);
	close(fd);

	_mfprintf_semop(semid, MFPRINTF_UNLOCK);
	return size;
}

/*
 * mfprintf/shmlog間で利用するセマフォ番号
 *   セマフォ番号割り当てはLPUX設計仕様書DBを参照のこと
 */
#define	CMDRW_SIGW_SEM_KEY	(0x8439327)
#define	RSCI_SIGR_SEM_KEY			(CMDRW_SIGW_SEM_KEY+0x423)
#define	LECI_SIGR_SEM_KEY			(RSCI_SIGR_SEM_KEY+0x34320)

int main(int argc, char *argv[])
{
	printf("thread_rsci_main\n");

	while(1)
	{
		int buf;
		int readcnt=0;

		printf("input(hex): ");
		fscanf(stdin, "%x", &buf);
		write1("/sys/class/ipc/R4/R4.1/rw", CMDRW_SIGW_SEM_KEY, &buf);

		readcnt=0;
		while(1) {
			int ret;
			ret = read1("/sys/class/ipc/R4/R4.1/rw", CMDRW_SIGW_SEM_KEY, &buf);
			if (ret == 4) {
				printf("r %x\n", buf);
				break;
			}
			readcnt++;
			if (readcnt > 100000) {
				printf("read cnt over 100000. clear.\n", buf);
				readcnt=0;
			}
		}
	}
	return 0;
}
