/*
 * testmain.c
 *
 *  Created on: 2014/11/13
 *      Author: sai495479
 */

#include <stdio.h>
#include <stdlib.h>

#include <fcntl.h>

#include <sys/sem.h>

#include <err.h>
#include <errno.h>
#include <unistd.h>

#include <pthread.h>

char gBuf[128];
pthread_t gThRsci, gThLeci, gThp;
pthread_cond_t gCondRSCI;
pthread_cond_t gCondLECI;
pthread_mutex_t gMutexRSCI;
pthread_mutex_t gMutexLECI;

struct usercmd {
	char wr;
	char cmdsig;
	int param;
};

struct usercmd gRSCIUserCmd;
struct usercmd gLECIUserCmd;

/* セマフォ操作 */
#define MFPRINTF_LOCK		(-1)
#define MFPRINTF_UNLOCK		1

/*
 * semget for mfprintf
 * 初回呼び出し元が不明でも複数プロセスから呼び出せるsemgetのラッパー
 * 初回は初期化を行い、次回からはただgetするだけ
 */
static inline int
_mfprintf_semget(int key)
{
	int semid = -1, rv;
	unsigned short vals[1] = {1};

	union semun {
		int		 val;
		struct semid_ds	 *buf;
		unsigned short	 *array;
	} ctl_arg;

	/* 引数検査 */
	if (key < 0) {
		return -EINVAL;
	}

	/* 初回作成要求 */
	if ((semid = semget(key, 1, IPC_CREAT | IPC_EXCL | 0777)) != -1) {
		/* セマフォ初期化 */
		ctl_arg.array = vals;
		if (semctl(semid, 0, SETALL, ctl_arg) == -1) {
			rv = -errno;
			warn("_mfprintf_semget:pid=%d, semctl key=%d",
			     getpid(), key);
			return rv;
		}
	} else {
		/* 既に存在していた？ */
		if (errno == EEXIST) {
			/* 再作成要求(初期化なし) */
			if ((semid = semget(key, 1, IPC_CREAT)) == -1) {
				rv = -errno;
				warn("_mfprintf_semget:pid=%d, resemget key=%d",
				     getpid(), key);
				return rv;
			}
		}else{
			/* 完全失敗 */
			rv = -errno;
			warn("_mfprintf_semget:pid=%d, semget failure key=%d",
			     getpid(), key);
			return rv;
		}
	}
	return semid;
}


/*
 * semop for mfprintf
 * セマフォ操作を行う
 */
static inline int
_mfprintf_semop(int semid, int op)
{
	struct sembuf	 sops[1];

	/* 引数検査 */
	if (semid < 0 ||
	    !((op == MFPRINTF_LOCK) || (op == MFPRINTF_UNLOCK))) {
		return -EINVAL;
	}

	sops[0].sem_num = 0;
	sops[0].sem_op = op;
	sops[0].sem_flg = SEM_UNDO;

	if (semop(semid, sops, 1) == -1) {
		int rv = -errno;
		warn( "_mfprintf_semop:pid=%d, failure id=%d, op=%d",
		      getpid(), semid, op);
		return rv;
	}
	return semid;
}

// write, read rsci cmd R4.1
// write, read leci cmd R4.2
// write, read rsci signal R4.3
// write, read leci signal R4.4
//CMD_SEM_KEY
//READ_SIGNAL_SEM_KEY
int write1(const char *devname, int semkey, unsigned int wdata)
{
	int semid = -1;
	int fd;
	unsigned char buf[4];
	int size=-1;
	
	buf[3] = (unsigned char) ((wdata & 0xff000000) >> 24);
	buf[2] = (unsigned char) ((wdata & 0x00ff0000) >> 16);
	buf[1] = (unsigned char) ((wdata & 0x0000ff00) >>  8);
	buf[0] = (unsigned char) ((wdata & 0x000000ff) );

	if ((semid = _mfprintf_semget(semkey)) == -1) {
		printf("%s:%s(%d) ERR!\n", __FILE__, __func__, __LINE__);
		exit(31);
		return -1;
	}
	if (_mfprintf_semop(semid, MFPRINTF_LOCK) == -1) {
		printf("%s:%s(%d) ERR!\n", __FILE__, __func__, __LINE__);
		exit(31);
		return -1;
	}

	printf("%s:%s(%d) open %s\n", __FILE__, __func__, __LINE__, devname);
	fd = open(devname, O_WRONLY );
	if (fd < 0)
	{
		printf("%s:%s(%d) ERR!\n", __FILE__, __func__, __LINE__);
		exit(31);
	}

	printf("%s:%s(%d):write %x,%x,%x,%x\n", __FILE__, __func__, __LINE__, buf[0], buf[1], buf[2], buf[3]);
	size = write(fd, buf, 4);
	printf("%s:%s(%d):write ret %d\n", __FILE__, __func__, __LINE__, size);
	close(fd);

	_mfprintf_semop(semid, MFPRINTF_UNLOCK);
	return size;
}

//CMD_SEM_KEY
//READ_SIGNAL_SEM_KEY
int read1(const char *devname, int semkey, unsigned int *rdata)
{
	int semid = -1;
	int fd;
	unsigned char buf[4];
	int size=-1;
	int rdatatmp;

	if ((semid = _mfprintf_semget(semkey)) == -1) {
		printf("%s:%s(%d) ERR!\n", __FILE__, __func__, __LINE__);
		exit(31);
		return -1;
	}
	if (_mfprintf_semop(semid, MFPRINTF_LOCK) == -1) {
		printf("%s:%s(%d) ERR!\n", __FILE__, __func__, __LINE__);
		exit(31);
		return -1;
	}

	printf("%s:%s(%d) open %s\n", __FILE__, __func__, __LINE__, devname);
	fd = open(devname, O_RDONLY );
	if (fd < 0)
	{
		printf("%s:%s(%d) ERR!\n", __FILE__, __func__, __LINE__);
		exit(31);
	}

	printf("%s:%s(%d):read \n", __FILE__, __func__, __LINE__);
	size = read(fd, buf, 4);
	printf("%s:%s(%d):read ret %d\n", __FILE__, __func__, __LINE__, size);
	close(fd);
	
	if (size == 4) {
		rdatatmp = 0;
		rdatatmp |= (unsigned int)buf[0];
		rdatatmp |= ((unsigned int)buf[1] <<  8);
		rdatatmp |= ((unsigned int)buf[2] << 16);
		rdatatmp |= ((unsigned int)buf[3] << 24);
		*rdata = rdatatmp;
		printf("%s:%s(%d):read receive 0x%x\n", __FILE__, __func__, __LINE__, *rdata);
	}
	
	_mfprintf_semop(semid, MFPRINTF_UNLOCK);
	return size;
}

/*
 * mfprintf/shmlog間で利用するセマフォ番号
 *   セマフォ番号割り当てはLPUX設計仕様書DBを参照のこと
 */
#define	CMDRW_SIGW_SEM_KEY	(0x8439327)
#define	RSCI_SIGR_SEM_KEY			(CMDRW_SIGW_SEM_KEY+0x423)
#define	LECI_SIGR_SEM_KEY			(RSCI_SIGR_SEM_KEY+0x34320)

#define RSCI_CMD_W(_a)	{printf("WRC "); write1("/sys/class/ipc/R4/R4.1/rw", CMDRW_SIGW_SEM_KEY, _a);}
#define RSCI_CMD_R(_a)	{printf("RRC "); read1("/sys/class/ipc/R4/R4.1/rw", CMDRW_SIGW_SEM_KEY, _a);}
#define LECI_CMD_W(_a)	{printf("WLC "); write1("/sys/class/ipc/R4/R4.2/rw", CMDRW_SIGW_SEM_KEY, _a);}
#define LECI_CMD_R(_a)	{printf("RLC "); read1("/sys/class/ipc/R4/R4.2/rw", CMDRW_SIGW_SEM_KEY, _a);}

#define RSCI_SIG_W(_a)	{printf("WRS "); write1("/sys/class/ipc/R4/R4.3/rw", CMDRW_SIGW_SEM_KEY, _a);}
#define RSCI_SIG_R(_a)	{printf("RRS "); read1("/sys/class/ipc/R4/R4.3/rw", RSCI_SIGR_SEM_KEY, _a);}
#define LECI_SIG_W(_a)	{printf("WLS "); write1("/sys/class/ipc/R4/R4.4/rw", CMDRW_SIGW_SEM_KEY, _a);}
#define LECI_SIG_R(_a)	{printf("RLS "); read1("/sys/class/ipc/R4/R4.4/rw", LECI_SIGR_SEM_KEY, _a);}

void *thread_rsci_recv_signal(void *param)
{
	unsigned int data;
	printf("%s:%s(%d)\n", __FILE__, __func__, __LINE__);
	while(1)
	{
		RSCI_SIG_R(&data);
	}
	return 0;
}

void *pthfunc_rsci(void *param)
{
	pthread_t rsci_recv_signal;
	unsigned int data;

	printf("%s:%s(%d)\n", __FILE__, __func__, __LINE__);

	//rsci信号線も対応のipcをテストする場合はここを有効にすること
//	if(pthread_create(&rsci_recv_signal , NULL , thread_rsci_recv_signal , NULL) !=0)  /*2番目の引数にNULLを指定することによりスレッドの属性にデフォルトとする*/
//	{}
	
	while(1)
	{
		pthread_mutex_lock(&gMutexRSCI);
		// mainスレッドからシグナルが飛ばされるまで停止する
		pthread_cond_wait(&gCondRSCI, &gMutexRSCI);
		printf("wake up rsci\n");
		pthread_mutex_unlock(&gMutexRSCI);
		printf("rsci:%c %c %x", gRSCIUserCmd.wr, gRSCIUserCmd.cmdsig, gRSCIUserCmd.param);
		if ( (gRSCIUserCmd.wr == 'w') && (gRSCIUserCmd.cmdsig == 'c') ) {
			RSCI_CMD_W( gRSCIUserCmd.param );
		} else if ( (gRSCIUserCmd.wr == 'w') && (gRSCIUserCmd.cmdsig == 's') ) {
			RSCI_SIG_W( gRSCIUserCmd.param );
		} else if ( (gRSCIUserCmd.wr == 'r') && (gRSCIUserCmd.cmdsig == 'c') ) {
			RSCI_CMD_R( &data );
		} else if ( (gRSCIUserCmd.wr == 'r') && (gRSCIUserCmd.cmdsig == 's') ) {
			printf("%s:%s(%d):ERR!\n", __FILE__, __func__, __LINE__);
		}
		fflush(stdout);
	}
	return 0;
}

void *thread_leci_recv_signal(void *param)
{
	unsigned int data;
	printf("%s:%s(%d)\n", __FILE__, __func__, __LINE__);
	while(1)
	{
		LECI_SIG_R(&data);
	}
	return 0;
}

void *pthfunc_leci(void *param)
{
	pthread_t leci_recv_signal;
	unsigned int data;
	printf("%s:%s(%d)\n", __FILE__, __func__, __LINE__);
	//leci信号線も対応のipcをテストする場合はここを有効にすること
//	if(pthread_create(&leci_recv_signal , NULL , thread_leci_recv_signal , NULL) !=0)  /*2番目の引数にNULLを指定することによりスレッドの属性にデフォルトとする*/
//	{}
	
	while(1)
	{
		pthread_mutex_lock(&gMutexLECI);
		// mainスレッドからシグナルが飛ばされるまで停止する
		pthread_cond_wait(&gCondLECI, &gMutexLECI);
		printf("wake up leci\n");
		pthread_mutex_unlock(&gMutexLECI);
		printf("leci:%c %c %x", gLECIUserCmd.wr, gLECIUserCmd.cmdsig, gLECIUserCmd.param);
		if ( (gLECIUserCmd.wr == 'w') && (gLECIUserCmd.cmdsig == 'c') ) {
			LECI_CMD_W( gLECIUserCmd.param );
		} else if ( (gLECIUserCmd.wr == 'w') && (gLECIUserCmd.cmdsig == 's') ) {
			LECI_SIG_W( gLECIUserCmd.param );
		} else if ( (gLECIUserCmd.wr == 'r') && (gLECIUserCmd.cmdsig == 'c') ) {
			LECI_CMD_R( &data );
		} else if ( (gLECIUserCmd.wr == 'r') && (gLECIUserCmd.cmdsig == 's') ) {
			printf("%s:%s(%d):ERR!\n", __FILE__, __func__, __LINE__);
		}
		fflush(stdout);
	}
	
	return 0;
}


int main(int argc, char *argv[])
{
	int ret;
	pthread_mutex_init(&gMutexRSCI, NULL);
	pthread_mutex_init(&gMutexLECI, NULL);
	pthread_cond_init(&gCondRSCI, NULL);
	pthread_cond_init(&gCondLECI, NULL);
	ret = pthread_create(&gThRsci, NULL, pthfunc_rsci, NULL);
	if (ret != 0) {
		printf("%s:%s(%d): ERR!\n", __FILE__, __func__, __LINE__); exit(-1);
	}
	ret = pthread_create(&gThLeci, NULL, pthfunc_leci, NULL);
	if (ret != 0) {
		printf("%s:%s(%d): ERR!\n", __FILE__, __func__, __LINE__); exit(-1);
	}

	printf("test (read or write)(rsci or leci)(cmd or sig) param\n");
	while(1)
	{
		struct usercmd *pusercmd=NULL;
		char wr='\0', cmdsig='\0',th='\0';
		int param2=0;
		fgets(gBuf, 128, stdin);
		sscanf(gBuf, "%c%c%c %x", &wr, &th, &cmdsig, &param2);//w c l xxxx
		if (th == 'r') {
			pusercmd = &gRSCIUserCmd;
			pusercmd->wr = wr;
			pusercmd->cmdsig = cmdsig;
			pusercmd->param = param2;
			pthread_cond_signal(&gCondRSCI);
		} else if (th == 'l') {
			pusercmd = &gLECIUserCmd;
			pusercmd->wr = wr;
			pusercmd->cmdsig = cmdsig;
			pusercmd->param = param2;
			pthread_cond_signal(&gCondLECI);
		}
		fflush(stdout);
	}
	
	return 0;
}

