/*
 * testmain.c
 *
 *  Created on: 2014/11/13
 *      Author: sai495479
 */

#include <stdio.h>
#include <stdlib.h>

#include <fcntl.h>

#include <sys/sem.h>

#include <err.h>
#include <errno.h>
#include <unistd.h>

#include <pthread.h>

char gBuf[128];

struct usercmd {
	char wr;
	char cmdsig;
	int param;
};

struct usercmd gRSCIUserCmd;
struct usercmd gLECIUserCmd;

/* セマフォ操作 */
#define MFPRINTF_LOCK		(-1)
#define MFPRINTF_UNLOCK		1

/*
 * semget for mfprintf
 * 初回呼び出し元が不明でも複数プロセスから呼び出せるsemgetのラッパー
 * 初回は初期化を行い、次回からはただgetするだけ
 */
static inline int
_mfprintf_semget(int key)
{
	int semid = -1, rv;
	unsigned short vals[1] = {1};

	union semun {
		int		 val;
		struct semid_ds	 *buf;
		unsigned short	 *array;
	} ctl_arg;

	/* 引数検査 */
	if (key < 0) {
		return -EINVAL;
	}

	/* 初回作成要求 */
	if ((semid = semget(key, 1, IPC_CREAT | IPC_EXCL | 0777)) != -1) {
		/* セマフォ初期化 */
		ctl_arg.array = vals;
		if (semctl(semid, 0, SETALL, ctl_arg) == -1) {
			rv = -errno;
			warn("_mfprintf_semget:pid=%d, semctl key=%d",
			     getpid(), key);
			return rv;
		}
	} else {
		/* 既に存在していた？ */
		if (errno == EEXIST) {
			/* 再作成要求(初期化なし) */
			if ((semid = semget(key, 1, IPC_CREAT)) == -1) {
				rv = -errno;
				warn("_mfprintf_semget:pid=%d, resemget key=%d",
				     getpid(), key);
				return rv;
			}
		}else{
			/* 完全失敗 */
			rv = -errno;
			warn("_mfprintf_semget:pid=%d, semget failure key=%d",
			     getpid(), key);
			return rv;
		}
	}
	return semid;
}


/*
 * semop for mfprintf
 * セマフォ操作を行う
 */
static inline int
_mfprintf_semop(int semid, int op)
{
	struct sembuf	 sops[1];

	/* 引数検査 */
	if (semid < 0 ||
	    !((op == MFPRINTF_LOCK) || (op == MFPRINTF_UNLOCK))) {
		return -EINVAL;
	}

	sops[0].sem_num = 0;
	sops[0].sem_op = op;
	sops[0].sem_flg = SEM_UNDO;

	if (semop(semid, sops, 1) == -1) {
		int rv = -errno;
		warn( "_mfprintf_semop:pid=%d, failure id=%d, op=%d",
		      getpid(), semid, op);
		return rv;
	}
	return semid;
}

// write, read rsci cmd R4.1
// write, read leci cmd R4.2
// write, read rsci signal R4.3
// write, read leci signal R4.4
//CMD_SEM_KEY
//READ_SIGNAL_SEM_KEY
int write1(const char *devname, int semkey, unsigned int wdata)
{
	int semid = -1;
	int fd;
	unsigned char buf[4];
	int size=-1;
	
	buf[3] = (unsigned char) ((wdata & 0xff000000) >> 24);
	buf[2] = (unsigned char) ((wdata & 0x00ff0000) >> 16);
	buf[1] = (unsigned char) ((wdata & 0x0000ff00) >>  8);
	buf[0] = (unsigned char) ((wdata & 0x000000ff) );

	if ((semid = _mfprintf_semget(semkey)) == -1) {
		printf("%s:%s(%d) ERR!\n", __FILE__, __func__, __LINE__);
		exit(31);
		return -1;
	}
	if (_mfprintf_semop(semid, MFPRINTF_LOCK) == -1) {
		printf("%s:%s(%d) ERR!\n", __FILE__, __func__, __LINE__);
		exit(31);
		return -1;
	}

	printf("%s:%s(%d) open %s\n", __FILE__, __func__, __LINE__, devname);
	fd = open(devname, O_WRONLY );
	if (fd < 0)
	{
		printf("%s:%s(%d) ERR!\n", __FILE__, __func__, __LINE__);
		exit(31);
	}

	printf("%s:%s(%d):write %x,%x,%x,%x\n", __FILE__, __func__, __LINE__, buf[0], buf[1], buf[2], buf[3]);
	size = write(fd, buf, 4);
	printf("%s:%s(%d):write ret %d\n", __FILE__, __func__, __LINE__, size);
	close(fd);

	_mfprintf_semop(semid, MFPRINTF_UNLOCK);
	return size;
}

//CMD_SEM_KEY
//READ_SIGNAL_SEM_KEY
int read1(const char *devname, int semkey, unsigned int *rdata)
{
	int semid = -1;
	int fd;
	unsigned char buf[4];
	int size=-1;
	int rdatatmp;

	if ((semid = _mfprintf_semget(semkey)) == -1) {
		printf("%s:%s(%d) ERR!\n", __FILE__, __func__, __LINE__);
		exit(31);
		return -1;
	}
	if (_mfprintf_semop(semid, MFPRINTF_LOCK) == -1) {
		printf("%s:%s(%d) ERR!\n", __FILE__, __func__, __LINE__);
		exit(31);
		return -1;
	}

	printf("%s:%s(%d) open %s\n", __FILE__, __func__, __LINE__, devname);
	fd = open(devname, O_RDONLY );
	if (fd < 0)
	{
		printf("%s:%s(%d) ERR!\n", __FILE__, __func__, __LINE__);
		exit(31);
	}

	printf("%s:%s(%d):read \n", __FILE__, __func__, __LINE__);
	size = read(fd, buf, 4);
	printf("%s:%s(%d):read ret %d\n", __FILE__, __func__, __LINE__, size);
	close(fd);
	
	if (size == 4) {
		rdatatmp = 0;
		rdatatmp |= (unsigned int)buf[0];
		rdatatmp |= ((unsigned int)buf[1] <<  8);
		rdatatmp |= ((unsigned int)buf[2] << 16);
		rdatatmp |= ((unsigned int)buf[3] << 24);
		*rdata = rdatatmp;
		printf("%s:%s(%d):read receive 0x%x\n", __FILE__, __func__, __LINE__, *rdata);
	}
	
	_mfprintf_semop(semid, MFPRINTF_UNLOCK);
	return size;
}

/*
 * mfprintf/shmlog間で利用するセマフォ番号
 *   セマフォ番号割り当てはLPUX設計仕様書DBを参照のこと
 */
#define	CMDRW_SIGW_SEM_KEY	(0x8439327)
#define	RSCI_SIGR_SEM_KEY			(CMDRW_SIGW_SEM_KEY+0x423)
#define	LECI_SIGR_SEM_KEY			(RSCI_SIGR_SEM_KEY+0x34320)


int test_write_n(const char *devname, char *buf, int size)
{
	int fd;
	int ret;

	printf("%s:%s(%d) open %s\n", __FILE__, __func__, __LINE__, devname);
	fd = open(devname, O_RDWR );
	if (fd < 0)
	{
		perror("open() ERR! ");
		exit(31);
	}
	
	ret = write(fd, buf, size);
	if (ret < 0)
	{
		perror("write() ERR! ");
	}
	printf("%s:%s(%d):write ret %d\n", __FILE__, __func__, __LINE__, ret);
	close(fd);

	return ret;
}

int test_read_n(const char *devname, char *buf, int size)
{
	int fd;
	int ret;

	printf("%s:%s(%d) open %s\n", __FILE__, __func__, __LINE__, devname);
	fd = open(devname, O_RDWR );
	if (fd < 0)
	{
		perror("open() ERR! ");
		exit(31);
	}
	
	ret = read(fd, buf, size);
	if (ret < 0)
	{
		perror("read() ERR! ");
	}
	printf("%s:%s(%d):read ret %d\n", __FILE__, __func__, __LINE__, ret);
	close(fd);

	return ret;
}

#define DEVNAME "/sys/class/ipc/R4/R4.1/rw"

int main(int argc, char *argv[])
{

	printf("test 1 or 2 or 3 or 4 or ...\n");
	while(1)
	{
		char testchr;
		char buf[10];
		fgets(gBuf, 128, stdin);
		sscanf(gBuf, "%c", &testchr);
		switch(testchr)
		{
		case '1':
			printf("test_write_n(DEVNAME, buf, 0);\n");
			test_write_n(DEVNAME, buf, 0);
			break;
		case '2':
			printf("test_write_n(DEVNAME, buf, 5);\n");
			test_write_n(DEVNAME, buf, 5);
			break;
		case '3':
			printf("test_write_n(DEVNAME, NULL, 4);\n");
			test_write_n(DEVNAME, NULL, 4);
			break;
		case '4':
			printf("test_read_n(DEVNAME, buf, 0);\n");
			test_read_n(DEVNAME, buf, 0);
			break;
		case '5':
			printf("test_read_n(DEVNAME, buf, 5);\n");
			test_read_n(DEVNAME, buf, 5);
			break;
		case '6':
			printf("test_read_n(DEVNAME, NULL, 4);\n");
			test_read_n(DEVNAME, NULL, 4);
			break;
		case '7':
			printf("test_read_n(DEVNAME, buf, 4);\n");
			test_read_n(DEVNAME, buf, 4);
			break;
		default:
			break;
		}
		printf("test %c finished\n", testchr);
		fflush(stdout);
	}
	
	return 0;
}

