#!/bin/sh

# Adjust source clock of lanmaclk2x : by hideaki at 2016/05/09
devmem 0xd0630558 32 0x01000002
# FIX TCP Vulnerability about RFC 5961
sysctl -w net.ipv4.tcp_challenge_ack_limit=1073741823

#Set IPv6 Param
sysctl -w net.ipv6.conf.eth0.accept_dad=2
sysctl -w net.ipv6.conf.all.log_martians=1

#echo "initialize gpio for shutdown"
#  XXX : resolve Uchiyama magic.
#        
stty -F /dev/ttyS2 115200 raw -echo
if [ -e /dev/ttyS3 ] ; then
    stty -F /dev/ttyS3 38400 raw parenb parodd -echo
    ln -s /dev/ttyS3 /dev/esif0
fi

mount -o remount,ro -t ubifs /dev/ubi0_0 /
mount -t tmpfs tmpfs /mnt
mkdir -p /mnt/hdd/firm
mkdir -p /mnt/hdd/ramdisk
ln -s /media/emmc /mnt/emmc

modprobe simva
modprobe low_power_idle

#watch KANSI->micon
gpioctrl -s 146 0


#  XXX : temporary interaction
#      write to a file on ramdisk, sometimes it's occured much alignment exception.
#      default, the settinng is 3, it means "warn and fixup".
#      now change to 2, it means "fixup", not warn.
echo 2 > /proc/cpu/alignment

#watch Power down mode at wifi driver
gpioctrl -s 150 0

#USB device driver load
modprobe ci_hdrc_imx
modprobe libcomposite

export KERNELNAME=`uname -r`
insmod "/lib/modules/${KERNELNAME}/kernel/drivers/usb/gadget/function/usb_simva_class.ko"
unset KERNELNAME

#print finished process program (monitor /tmp/gwinit_proc_info.txt)
if [ -f /usr/bin/disp_proc_info ]; then
    /usr/bin/disp_proc_info &
fi

ifconfig lo up
ifconfig eth0 down

/svarch/simva.conf &
