/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2015, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/

#include <linux/module.h>
#include "dros.h"
#include "list.h"
#include "interrupt_api.h"
// #include "memAPI.h"
#include "lassert.h"

// DrOS
EXPORT_SYMBOL( dros_sem_wait );
EXPORT_SYMBOL( dros_sem_trywait );
EXPORT_SYMBOL( dros_sem_post );
EXPORT_SYMBOL( dros_sem_init );
EXPORT_SYMBOL( dros_sem_getvalue );
//EXPORT_SYMBOL( dros_sem_timedwait );
EXPORT_SYMBOL( dros_sem_is_initialized );
EXPORT_SYMBOL( dros_create_thread );
EXPORT_SYMBOL( dros_destroy_thread );
EXPORT_SYMBOL( dros_mq_receive );
EXPORT_SYMBOL( dros_mq_send_nowait );
EXPORT_SYMBOL( dros_mq_init );
EXPORT_SYMBOL( dros_mq_free );
EXPORT_SYMBOL( dros_smplock_init );
EXPORT_SYMBOL( dros_smplock_acquire );
EXPORT_SYMBOL( dros_smplock_release );
EXPORT_SYMBOL( dros_smplock_acquire_isr );
EXPORT_SYMBOL( dros_smplock_release_isr );

//Lists
EXPORT_SYMBOL( ATInitNode );
EXPORT_SYMBOL( ATInitList );
EXPORT_SYMBOL( ATIsListEmpty );
EXPORT_SYMBOL( ATInsertHeadList );
EXPORT_SYMBOL( ATInsertTailList );
EXPORT_SYMBOL( ATRemoveHeadList );
EXPORT_SYMBOL( ATRemoveTailList );
EXPORT_SYMBOL( ATRemoveEntryList );
EXPORT_SYMBOL( ATListHead );
EXPORT_SYMBOL( ATListNext );
EXPORT_SYMBOL( ATListPrev );
EXPORT_SYMBOL( ATListTail );
EXPORT_SYMBOL( ATListInsertAfter );
EXPORT_SYMBOL( ATListInsertBefore );
EXPORT_SYMBOL( ATNumListNodes );

// Interrupts
EXPORT_SYMBOL( intAttach );
EXPORT_SYMBOL( intDetach );
EXPORT_SYMBOL( intEnable );
EXPORT_SYMBOL( intDisable );

// Memory
// EXPORT_SYMBOL( memMalloc );
// EXPORT_SYMBOL( memFree );
void *scanK_MEM_MALLOC( size_t size );
void scanK_memFree(void *address);
EXPORT_SYMBOL( scanK_MEM_MALLOC );
EXPORT_SYMBOL( scanK_memFree );

// Asserts
EXPORT_SYMBOL( _assert );
EXPORT_SYMBOL( XAssertFail );

static int __init dros_init(void)
{
    printk(KERN_INFO "dros_init\n");
    return 0;
}

static void __exit dros_exit(void)
{
    printk(KERN_INFO "dros_exit\n");
}

MODULE_AUTHOR("Marvell Semiconductor, Inc.");
MODULE_DESCRIPTION("DrOS");
MODULE_LICENSE("GPL");

module_init(dros_init);
module_exit(dros_exit);

