/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2012-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/

/**
 * \file mesg_queue.h
 *
 * \brief Generic Message Queue utils
 *
 *
 */

#ifndef __MESG_QUEUE_H__
#define __MESG_QUEUE_H__

#include <linux/kfifo.h>
#include <linux/mutex.h>
#include <linux/semaphore.h>
#include <linux/kernel.h>

#define MESGQ_WAIT_FOREVER  (~0)
#define MESGQ_NO_WAIT         0

typedef struct mesg_queue_s
{
    struct kfifo        mesg_queue_fifo;
    struct semaphore    mesg_queue_sem;
    spinlock_t          mesg_queue_lock;
    size_t              mesg_sz;
} mesg_queue_t;

extern void mesgq_free(mesg_queue_t *mesgq);

extern int mesgq_create(mesg_queue_t *mesgq, size_t mesg_sz, unsigned int depth);

extern int mesgq_wait_for_msg( mesg_queue_t *mesgq, void *msg, unsigned long int timeout_in_usec );

extern int mesgq_send_nowait( mesg_queue_t *mesgq, void *msg );

#endif //define __MESG_QUEUE_H__
