/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2013-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/
/**
 * \file os_system.h
 *
 * \brief Posix/linux replacement function for general 'system' fork/exec.
 *    Allows daemon restarts without propogating open file descriptors.
 *
 **/

#ifndef _LINUX_SYSTEM_WRAPPER_H
#define _LINUX_SYSTEM_WRAPPER_H

#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h> // waitpid()

int os_system(char* shell_request); // synchronous wait for an exit/err response
int os_shell(char* shell_request); // includes stdout/stderr results from sh

#endif // _LINUX_SYSTEM_WRAPPER_H eof
