/*
 ******************************************************************************
 * Copyright (c) 2013 Marvell International, Ltd. All Rights Reserved
 *
 *                         Marvell Confidential
 ******************************************************************************
 */

#ifdef __linux__

#include <stdint.h>
#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif

/** Interface to <sys/mman.h>::mmap() that assists with page offset math
 *  normally used to map hw register blocks into application space.
 *  fd < 0 create temporary file descriptor, fd >= 0 reuse given filedescriptor to /dev/mem
 */
void *mapMem(uint32_t phys_addr, size_t length, void **map_base, int fd);

/** free a single region assuming you held the map_base 
 */
int unMapMem(void *map_base, size_t length);

/** free all mapMem regions in the application.
 */   
void mapMem_destructor( void );

#ifdef __cplusplus
}
#endif


#else // !linux 

// threadx hwaddr and virtual address assumed to be the same
#define mapMem( addr, len, base, fd ) (void*)addr
#define unMapMem( base, len ) 
#define mapMem_destructor( )

#endif // linux


