/*
 ******************************************************************************
 * Copyright (c) 2013 Marvell International, Ltd. All Rights Reserved
 *
 *                         Marvell Confidential
 ******************************************************************************
 */

#ifdef __linux__

#include "map_mem.h"
#include <unistd.h>   // getpagesize(), usleep()
#include <sys/mman.h> // mmap(), munmap()
#include <fcntl.h> // open
#include "lassert.h"


#define G_MAX_MAPPED 10000
static int g_i = 0;
static void *g_map_base[G_MAX_MAPPED] = {0};
static uint32_t g_map_length[G_MAX_MAPPED] = {0};
static pthread_mutex_t the_mutex;
static pthread_mutex_t *mutex = 0;

void mapMem_destructor( )
{
    int i = 0;
    pthread_mutex_lock( mutex );
    for ( i = 0; i < G_MAX_MAPPED; i++ )
    {
	if ( g_map_base[i] ) 
	{
	    unMapMem(g_map_base[i], g_map_length[i]);
	    g_map_base[i] = 0;
	}
    }
    g_i = 0;
    pthread_mutex_unlock( mutex );
}


void *mapMem(uint32_t phys_addr, size_t length, void **map_base, int fd)
{
    uint32_t page_size = getpagesize();
    int have_fd;
    int i;

    have_fd = (fd >= 0);
    // printf ( "have %d\n", have_fd );

    if ( !have_fd )
    {
	if((fd = open("/dev/mem", (O_RDWR | O_SYNC | O_CLOEXEC))) < 0) 
	{
	    perror("mapMem()  open('dev/mem') failed ");
	    ASSERT(fd == 0);
	}
    }
    
    length += phys_addr & (off_t)(page_size - 1);
    if((*map_base = mmap(NULL, length, PROT_READ | PROT_WRITE, MAP_SHARED, fd,
                         phys_addr & ~(off_t)(page_size - 1))) == MAP_FAILED) 
    {
        close(fd);
        return(NULL);
    } 
    else 
    {
	    if (!mutex) {
		    mutex = &the_mutex;
		    posix_mutex_init( mutex );
	    }
	    pthread_mutex_lock( mutex );
	    if ( g_i + 1 < G_MAX_MAPPED ) {
		    for ( i = g_i + 1; i < G_MAX_MAPPED; i++ ) {
			    if ( g_map_base[i] == 0 ) {
				    g_i = i;
				    g_map_base[g_i] = *map_base;
				    g_map_length[g_i] = length;
				    break;
			    }
		    }  
	    } else {
		    for ( i = 0; i < G_MAX_MAPPED; i++ ) {
			    if ( g_map_base[i] == 0 ) {
				    g_i = i;
				    g_map_base[g_i] = *map_base;
				    g_map_length[g_i] = length;
				    break;
			    }
		    } 
		    ASSERT( i < /* compile time constant too small */ G_MAX_MAPPED );
	    }
	    pthread_mutex_unlock( mutex );

	    if (!have_fd) 
		    close(fd);
	    return((void *)(*map_base + (phys_addr & (page_size - 1))));
    }
}

int unMapMem(void *map_base, size_t length)
{
    uint32_t page_size = getpagesize();
    int i;

    length += (off_t)map_base & (page_size - 1);
    if(munmap((void*) ((off_t)map_base & ~(page_size - 1)), length) == -1) 
    {
        return(-1);
    } 
    else 
    {
        return(0);
    }
    pthread_mutex_lock( mutex );
    for ( i = 0; i < G_MAX_MAPPED; i++ )
    {
	if ( map_base == g_map_base[i] )
	{
	    g_map_base[i] = 0;
	    break;
	}
    }
    pthread_mutex_unlock( mutex );
}

#endif // linux


