/*
 ***************************************************************************************
 * (c) Copyright 2013 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIE_VERIFICATION_H_
#define _PIE_VERIFICATION_H_


// uncomment the next 2 lines if debugging buffers to have
// sequentially numbered pixel data
//#define DEBUG_NORANDOM_BUFS 1
//#define PIE_INDATA_DATA(x)     (*x = (i & 0xffff))  

// hardcode this - we know that pie has 3 IDMA channels
#define NUM_PIE_POGO_IDMA_CHANNELS 3

int setup_pogo_output(struct pie_handle_t *pie_handle, uint8_t pogo_fmt_type_out,
                      uint8_t pogo_bpp, uint8_t color_swap, uint32_t linewidth,
                      uint8_t  eatPIEData);

void setup_pogo_input(struct pie_handle_t *pie_handle, uint8_t pogo_fmt_type_in,
                      int num_idma_channels, uint32_t pogo_bpp_input,  uint8_t color_swap,
                      uint32_t input_linewidth, uint8_t rowheight);

struct pie_verification_data
{
    // input dma
    DMA_descriptor *device_idma_descriptor[NUM_PIE_POGO_IDMA_CHANNELS];  // virtual address
    dma_addr_t device_idma_descriptor_phys[NUM_PIE_POGO_IDMA_CHANNELS];  // physical address
    int num_input_strips; // 1 strip == 1 descriptor
    // input data to the dma    
    uint32_t *input_data; // virtual address for the input data
    dma_addr_t input_data_phys; // physical address for the input data
    int in_bufsize; // size of input data buffer (bytes)
    // output dma
    DMA_descriptor *device_odma_descriptor;  // virtual address
    dma_addr_t device_odma_descriptor_phys;  // physical address
    int num_output_strips; // 1 strip == 1 descriptor
    // output data from the dma
    uint32_t *output_data;  // the virtual address for the output data
    dma_addr_t output_data_phys; // phys
    int out_bufsize; // size of output data buffer (bytes)
    // ot input dma
    DMA_descriptor *device_ot_idma_descriptor;  // virtual address
    dma_addr_t device_ot_idma_descriptor_phys;  // physical address
    // ot input data from the dma
    uint32_t *ot_input_data;  // the virtual address for the ot input data
    dma_addr_t ot_input_data_phys; // phys
    int ot_in_bufsize;
    // ot output dma
    DMA_descriptor *device_ot_odma_descriptor;  // virtual address
    dma_addr_t device_ot_odma_descriptor_phys;  // physical address
    // ot output data from the dma
    uint32_t *ot_output_data;  // the virtual address for the ot output data
    dma_addr_t ot_output_data_phys; // phys
    int ot_out_bufsize;
};

#endif // _PIE_VERIFICATION_H_
