/*
 ***************************************************************************************
 * (c) Copyright 2004-2005,2009 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef STRIP_PREDICT_H
#define STRIP_PREDICT_H

struct predict_state {
    /* state machine fields */
    int R;      /* remainder */
    int iPtr;   /* input strip pointer */
    int oPtr;   /* output strip pointer */
    int lastInputShipped;

    /* user parameters; constant across an image */
    int strip_height;
    int fracY;

    /* davep 27-june-06 ; 1==linear, 0==RAPR */
    int linear;
    int cubic;
};

/* indices of values in strip[] array as returned by strip_next() */
#define STRIP_READ_FIRST  0
#define STRIP_READ_LAST   1
#define STRIP_WRITE_FIRST 2
#define STRIP_WRITE_LAST  3

#define STRIPPR_MODE_RAPR   1
#define STRIPPR_MODE_LINEAR 2
#define STRIPPR_MODE_CUBIC 3
void strip_start( struct predict_state *s, 
                  int strip_height, 
                  int y_numerator,
                  int y_denominator, 
                  int fracY,
                  int mode );
void strip_next( struct predict_state *s, int strip[] );

#endif

