/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

/*
 * pie_scaler_verification.h
 *
 *  Created on: Jun 27, 2014
 *      Author: ericyh
 */

#ifndef PIE_SCALER_VERIFICATION_H_
#define PIE_SCALER_VERIFICATION_H_


/* copied from piereset.h
 *  X-Y Scale
 */

/* XYScale */
#define PIE_XY_SCALER_BYPASS 0
#define PIE_XY_SCALER_RAPR   1
#define PIE_XY_SCALER_LINEAR 2
#define PIE_XY_SCALER_CUBIC 3

//#define ICE_DMA_BYTE_ALIGN 16
#define ICE_DMA_BYTE_ALIGN 32
/* round up to DMA alignment */
#define ICE_DMA_ALIGN_ME(n)  ( ((n)+(ICE_DMA_BYTE_ALIGN-1)) & ~(ICE_DMA_BYTE_ALIGN-1))

extern int run_pie_xyscaler_register_test(void);
extern int run_pie_xycscaler_register_test(void);
extern int run_pie_xyscaler_test(int pogo_fmt_type_in, int pogo_fmt_type_out,
    							 int pixels_per_row, int rowheight,
    							 int pogo_bpp_input, int color_swap,
    							 int scale_num, int scale_den,
    							 int scale_mode);

#endif /* PIE_SCALER_VERIFICATION_H_ */
