/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIC_VERIFICATION_H_
#define _PIC_VERIFICATION_H_

// TEST STATUS
#define BAD_COMPARE 70
#define BAD_INTERRUPT 71
#define BUF_CREATION_ERR 73
#define DESC_CREATION_ERR 74

#define TEST_IN_PROGRESS 1000
#define TEST_LOADED 1001

#define PIC_TEST_GENERIC_FAILURE 10000
#define PIC_TEST_DESC_ERR (PIC_TEST_GENERIC_FAILURE | DESC_CREATION_ERR)
#define PIC_TEST_BUF_ERR (PIC_TEST_GENERIC_FAILURE | BUF_CREATION_ERR)
#define PIC_TEST_COMPARE_ERR (PIC_TEST_GENERIC_FAILURE | BAD_COMPARE)
#define PIC_TEST_BAD_INTERRUPT (PIC_TEST_GENERIC_FAILURE | BAD_INTERRUPT)

#define PIC_TEST_PASS 0

// for ICETest IDMA, with a 64 bit bus, 8 "beats" (transfers) is 64 bits (8 bytes) * 8, 64 bytes
#define DMA_8_BEATS 1
#define DMA_WIDTH_32 5
#define DMA_WIDTH_16 4
#define DMA_ENABLE 1
#define DMA_DISABLE 0

// for PICWDMA
#define WDMA_PROCESS_DATA 2
#define WDMA_DISCARD_DATA 1
#define MONO_DMA_CRV 0

#define NUM_PICWDMA_CHAN 3

struct pic_verification_data
{
    // input dma
    DMA_descriptor *icetestdma_descriptor;  // virtual address
    dma_addr_t icetestdma_descriptor_phys;  // physical address
    int num_input_descriptors; 
    // input data to the dma    
    uint32_t *input_data; // virtual address for the input data
    dma_addr_t input_data_phys; // physical address for the input data
    int in_bufsize; // size of input data buffer (bytes)
    uint8_t num_colors;  // mono = 1, color = 3
    // output dma
    DMA_descriptor *device_odma_descriptor[NUM_PICWDMA_CHAN];  // virtual address
    dma_addr_t device_odma_descriptor_phys[NUM_PICWDMA_CHAN];  // physical address
    int num_output_descriptors; 
    // output data from the dma
    uint16_t *output_data;  // the virtual address for the output data
    dma_addr_t output_data_phys; // phys
    int out_bufsize; // size of output data buffer (bytes)    
};

#endif // _PIC_VERIFICATION_H_
