/*
 ***************************************************************************************
 * (c) Copyright 2013 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _ICE_COMMON_H_
#define _ICE_COMMON_H_

#define ICE_IOCTL_DO_SOMETHING 0  // placeholder for ioctl
#define ICE_ARCH_GR2 1

enum icesubblock {base=0, adc, bulb, lrmargin0, idma2d, prnudsnu, newman, ps_esd, efir, hscale, 
                  lrmargin1, pic_wdma, pic_wdma_dma0, pic_wdma_dma1, pic_wdma_dma2, 
                  skewdet, skew_odma, antiflin, antiflin_wdma0, antiflin_wdma1, antiflin_wdma2, 
                  pnu2d, bitreduct, ICETest, ICETestIDMA, end_subblock};

ssize_t run_test_get(struct device *dev, struct device_attribute *attr,
                            char *buf);
ssize_t run_test_set(struct device *dev, struct device_attribute *attr,
                            const char *buf, size_t count);
ssize_t continue_set(struct device *dev, struct device_attribute *attr,
                            const char *buf, size_t count);


irqreturn_t ice_platform_irq(int irq, void *pdev);
int __init ice_verification_onetime_init(void);

#endif
