#!/bin/sh
#
# ===========================================================================
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2014, Marvell International Ltd.
#
# Alternatively, this software may be distributed under the terms of the GNU
# General Public License Version 2, and any use shall comply with the terms and
# conditions of the GPL.  A copy of the GPL is available at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
# IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
# ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
# this warranty disclaimer.
# ================================================================================

#

# Preconditions:
#
# 1)loadscan should already run
#
# 2) An icetest input file has been generated with expected dimensions by icefile_prep.py
#    For this test purpose, the image need to be prepared as 2580x3300 and the LUT size should 
#    be 2560 pixel width after margin pixels are accounted.
#
#    Here is how to run icefile_prep.py:
#    From scanpipe/common/scan/pytools
#      ./icefile_prep.py graygrid2400.png 2580 3300 gray2580x3300.ice
# 
# 3) The lut.bin has been generated by running lut_gen or by other means. See lut_gen.c for details. Note
#    the size must match what scan code expeted. For this test, it should be 2560
#
#

#Set lut to be 2560 pixel wide, 32bit for each entry, prnu takes 16bit, dsnu take 16bits
# See 88PA6270RA programmer's guide 5.4.5.8.2.12 and 5.4.5.8.2.1.3 for details
echo "2560 32 16 16" > /sys/class/pic_ctrl/pic_ctrl0/lut
sleep 3
#Populate the LUT table with content from lut.bin. 
cat lut.bin > /dev/pic_ctrl0
sleep 3
#Enable dsnu and prnu. Disable all others
echo 0 >  /sys/class/pic_ctrl/pic_ctrl0/bypass_all
echo 1 >  /sys/class/pic_ctrl/pic_ctrl0/bypass_quad
echo 1 >  /sys/class/pic_ctrl/pic_ctrl0/bypass_exp_comp
echo 1 >  /sys/class/pic_ctrl/pic_ctrl0/bypass_bad_replace
echo 0 >  /sys/class/pic_ctrl/pic_ctrl0/bypass_dsnu
echo 0 >  /sys/class/pic_ctrl/pic_ctrl0/bypass_prnu
sleep 3
#Set dsnu's offset to 0,    multi=1, scale shift = 0 See 88PA6270RA programmer's 
#guide 5.4.5.8.2.12 . 
echo "0 1 0" >   /sys/class/pic_ctrl/pic_ctrl0/dsnu

#Set prnu's offset to 0x8000, multi=1, scale shift = 0 See 88PA6270RA programmer's
#guide 5.4.5.8.2.13 
echo "0x8000 1 0" > /sys/class/pic_ctrl/pic_ctrl0/prnu

#Setup scan with icefile
scancmd scan config nocisx nopie icefile
sleep 3
#print out all PIC registers to verify they are correct, no lut is printed
echo 0 >   /sys/devices/f95f0000.pic0/pictest1
sleep 3
#You can print out lut
#echo 0 >   /sys/devices/f95f0000.pic0/pd/pd_debug

#Start scan
runscan -t mono -r 300 -o page &
sleep 5

#Feed the icetest using gray2580x3300.ice, a file that is geneated by running 
#icefile_prep.py. Can use any other files.
cat gray2580x3300.ice > /dev/icefile

#Look for page_mono.pgm for the output

