/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
 ******************************************************************************
*/
#include <stdlib.h>
#include <stdio.h>
#include <stdint.h>
/*
See 88PA6270RA Programmer's guide 5.4.5.8.2.1.2,5.4.5.8.2.13 for how to
generate LUT entries. 
To illustrate, for 32-bits entries with PRNU = 16bit DSNU = 16-bit:
  Given PRNU OFFSET=0x8000, Multi = 1, Scale = 0, 
  Given DSNU PFFSET=0x0000, Multi = 1, Scale = 0;
  An entry value of 0x00000000 indicates DSNU adjustment = 0, PRNU gain =1.0
  An entry value of 0x00001000 indicates DSNU adjustment = 1000, PRNU gain = 1.0
  An entry value of 0x80001000 indicates DSNU adjustment = 1000, PRNU gain = 2.0

*/
int main(int argc, char* argv[]){
	FILE *f;
	const char *fname = "lut.bin";
	int i, lut_size, entry_size;
    uint32_t entry_value;
	int k;

	if(argc < 4){
		printf("lut_gen <lut_size_pixel> <entry_size> <entry_value>");
		exit(1);
	}
	
	sscanf(argv[1], "%d", &lut_size);
	sscanf(argv[2], "%d", &entry_size);
	sscanf(argv[3], "%x", &entry_value);
	
	printf("lut_size=%d, entry_size=%d, entry_value =%x\n",
			lut_size, entry_size, entry_value);

	if(entry_size!=16 && entry_size!=24 && entry_size!=32){
		printf("invalid entry_size %d\n", entry_size);
		exit(2);
	}

	f = fopen(fname, "w+");
	if(f == NULL){
		printf("Fail to open %s for write\n", fname);
		exit(3);
	}

	for(i = 0;i < lut_size;i++){
		uint32_t cur_val = entry_value;
		uint8_t  b;
		k = 0;
		
		for(k=0; k < entry_size/8;k++){
			b = cur_val&(0xff);
			fwrite(&b, 1, 1, f);
			cur_val = cur_val>>8;
		}
	}
	fclose(f);
}
