/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _SCANBLK_IF_H_
#define _SCANBLK_IF_H_

struct scanblk_irqs
{
    bool unexp_mtr_sync;
    bool queue_overrun;
    bool cmd_int_overrun;
    bool scan_cmd_complete;
};

struct scanblk_SCFG1_cfg
{
    uint8_t  p1clken;      // 1 bits -- sensor phase 1 clocks enable
    uint8_t  p2clken;      // 1 bits -- sensor phase 2 clocks enable
    uint8_t  rsclken;      // 1 bits -- sensor reset clocks enable
    uint8_t  cpclken;      // 1 bits -- sensor CP clocks enable
    uint8_t  mclken;       // 1 bits -- AFE master clock enable
    uint8_t  vsclken;      // 1 bits -- AFE VS (video sample?) clock enable
    uint8_t  clclken;      // 1 bits -- AFE clamp clock enable
    uint8_t  lclmpen;      // 1 bits -- AFE line clamp clock enable
    uint8_t  bulben;       // 1 bits -- enable bulb PBM generator on the LEDB pin
    uint8_t  ssmen;        // 4 bits -- sensor clock start signal mask enable (4 bits): 1000=P1Clk 0100=P2Clk 0010=RSClk 0001=SPClk
    uint8_t  smpol;        // 4 bits -- sensor clock start signal mask polarities (4 bits): 1000=P1Clk 0100=P2Clk 0010=RSClk 0001=SPClk
    uint8_t  p1apol;       // 1 bits -- P1Clk polarity; 0=initial low, asserts high; 1=initial high, asserts low
    uint8_t  sptog;        // 1 bits -- start pulse toggle
    uint8_t  sppol;        // 1 bits -- start pulse polarity
    uint8_t  scpol;        // 4 bits -- sensor clock polarities (4 bits): 1000=P1Clk 0100=P2Clk 0010=RSClk 0001=SPClk
    uint8_t  acpol;        // 4 bits -- AFE clock polarities (4 bits): 1000=MClk 0100=VSClk 0010=CD1Clk 0001=LCClk

    bool p1clken_valid;
    bool p2clken_valid;
    bool rsclken_valid;
    bool cpclken_valid;
    bool mclken_valid;
    bool vsclken_valid;
    bool clclken_valid;
    bool lclmpen_valid;
    bool bulben_valid;
    bool ssmen_valid;
    bool smpol_valid;
    bool p1apol_valid;
    bool sptog_valid;
    bool sppol_valid;
    bool scpol_valid;
    bool acpol_valid;
};

#define SCFG2_AFEWIDTH_4BIT 0
#define SCFG2_AFEWIDTH_8BIT 1
#define SCFG2_AFEWIDTH_16BIT 2
struct scanblk_SCFG2_cfg
{
    uint8_t  cmode;        // 1 bits
    uint8_t  stype;        // 1 bits
    uint8_t  ssel;         // 2 bits
    uint8_t  afewidth;     // 2 bits
    uint8_t  leden1;       // 3 bits
    uint8_t  leden0;       // 3 bits
    uint8_t  pixper;       // 8 bits

    bool cmode_valid;
    bool stype_valid;
    bool ssel_valid;
    bool afewidth_valid;
    bool leden1_valid;
    bool leden0_valid;
    bool pixper_valid;
};

struct scanblk_SCFG3_cfg
{
    /* Each register field is 2 bits:
     * 00: delay by 1/4 system clock period
     * 01: delay by 1/2 system clock period
     * 10: delay by 3/4 system clock period
     * 11: delay by 1 system clock period
     */
    uint8_t  p1rise;       // 2 bits
    uint8_t  p1fall;       // 2 bits
    uint8_t  p2rise;       // 2 bits
    uint8_t  p2fall;       // 2 bits
    uint8_t  rsrise;       // 2 bits
    uint8_t  rsfall;       // 2 bits
    uint8_t  cprise;       // 2 bits
    uint8_t  cpfall;       // 2 bits
    uint8_t  mcrise;       // 2 bits
    uint8_t  mcfall;       // 2 bits
    uint8_t  vsrise;       // 2 bits
    uint8_t  vsfall;       // 2 bits
    uint8_t  cd1rise;      // 2 bits
    uint8_t  cd1fall;      // 2 bits
    uint8_t  sprise;       // 2 bits
    uint8_t  spfall;       // 2 bits

    bool p1rise_valid;
    bool p1fall_valid;
    bool p2rise_valid;
    bool p2fall_valid;
    bool rsrise_valid;
    bool rsfall_valid;
    bool cprise_valid;
    bool cpfall_valid;
    bool mcrise_valid;
    bool mcfall_valid;
    bool vsrise_valid;
    bool vsfall_valid;
    bool cd1rise_valid;
    bool cd1fall_valid;
    bool sprise_valid;
    bool spfall_valid;
};

struct scanblk_SCTRL_cfg
{
    uint8_t  umsen;        // 1 bits -- see scanblk_irqs.unexp_mtr_sync
    uint8_t  cmdqen;       // 1 bits
    uint8_t  termcmd;      // 1 bits
    uint8_t  sreset;       // 1 bits
    uint8_t  scmdie;       // 1 bits -- see scanblk_irqs.scan_cmd_complete
    uint8_t  run;          // 1 bits
    uint8_t  scanen;       // 1 bits

    bool umsen_valid;
    bool cmdqen_valid;
    bool termcmd_valid;
    bool sreset_valid;
    bool scmdie_valid;
    bool run_valid;
    bool scanen_valid;
};

struct scanblk_SCMD_cfg
{
    uint8_t  eoi;          // 1 bits
    uint8_t  sdata;        // 1 bits
    uint8_t  sptogval;     // 1 bits
    uint16_t sclkper;      // 13 bits
    uint16_t scany;        // 16 bits

    bool eoi_valid;
    bool sdata_valid;
    bool sptogval_valid;
    bool sclkper_valid;
    bool scany_valid;
};

struct scanblk_SSTAT_cfg
{
    uint16_t scanyr;       // 16 bits
    uint8_t  extintstat;   // 4 bits
    uint8_t  unexpsync;    // 1 bits
    uint8_t  cmdstat;      // 1 bits
    uint8_t  qempty;       // 1 bits
    uint8_t  qfull;        // 1 bits
    uint8_t  qovr;         // 1 bits
    uint8_t  iovr;         // 1 bits
    uint8_t  scmdcomp;     // 1 bits

    bool scanyr_valid;
    bool extintstat_valid;
    bool unexpsync_valid;
    bool cmdstat_valid;
    bool qempty_valid;
    bool qfull_valid;
    bool qovr_valid;
    bool iovr_valid;
    bool scmdcomp_valid;
};

struct scanblk_SCANX_cfg
{
    uint16_t expval;       // 16 bits
    uint16_t scanx;        // 16 bits

    bool expval_valid;
    bool scanx_valid;
};

struct scanblk_SCYCLE_cfg
{
    uint8_t  scycle;       // 6 bits

    bool scycle_valid;
};

struct scanblk_STCFG1_cfg
{
    uint8_t  spgen;        // 1 bits
    uint8_t  sp2ctrl;      // 3 bits
    uint8_t  mskextd;      // 4 bits
    uint8_t  ssme1;        // 8 bits
    uint8_t  ssme2;        // 8 bits

    bool spgen_valid;
    bool sp2ctrl_valid;
    bool mskextd_valid;
    bool ssme1_valid;
    bool ssme2_valid;
};

struct scanblk_STCFG2_cfg
{
    uint8_t  spe1_2;       // 8 bits
    uint8_t  spe1;         // 8 bits
    uint8_t  spe2_2;       // 8 bits
    uint8_t  spe2;         // 8 bits

    bool spe1_2_valid;
    bool spe1_valid;
    bool spe2_2_valid;
    bool spe2_valid;
};

struct scanblk_STCFG3_cfg
{
    uint8_t  aph1e1;       // 8 bits
    uint8_t  aph1e2;       // 8 bits
    uint8_t  aph1e3;       // 8 bits
    uint8_t  aph1e4;       // 8 bits

    bool aph1e1_valid;
    bool aph1e2_valid;
    bool aph1e3_valid;
    bool aph1e4_valid;
};

struct scanblk_STCFG4_cfg
{
    uint8_t  aph1e5;       // 8 bits
    uint8_t  aph1e6;       // 8 bits
    uint8_t  aph1e7;       // 8 bits
    uint8_t  aph1e8;       // 8 bits

    bool aph1e5_valid;
    bool aph1e6_valid;
    bool aph1e7_valid;
    bool aph1e8_valid;
};

struct scanblk_CCFG_cfg
{
    uint8_t  cpmode;       // 1 bits
    uint8_t  clmode;       // 1 bits
    uint8_t  clsel;        // 1 bits
    uint8_t  cle1;         // 8 bits
    uint8_t  ccle2;        // 8 bits
    uint8_t  acle2;        // 8 bits

    bool cpmode_valid;
    bool clmode_valid;
    bool clsel_valid;
    bool cle1_valid;
    bool ccle2_valid;
    bool acle2_valid;
};

/* Phase 1 clocks */
struct scanblk_SCLK1_cfg
{
    uint8_t  p1e1;         // 8 bits
    uint8_t  p1e2;         // 8 bits
    uint8_t  p1e3;         // 8 bits
    uint8_t  p1e4;         // 8 bits

    bool p1e1_valid;
    bool p1e2_valid;
    bool p1e3_valid;
    bool p1e4_valid;
};

/* Phase 1 clocks */
struct scanblk_SCLK2_cfg
{
    uint8_t  p1e5;         // 8 bits
    uint8_t  p1e6;         // 8 bits
    uint8_t  p1e7;         // 8 bits
    uint8_t  p1e8;         // 8 bits

    bool p1e5_valid;
    bool p1e6_valid;
    bool p1e7_valid;
    bool p1e8_valid;
};

/* Phase 2 clocks */
struct scanblk_SCLK3_cfg
{
    uint8_t  p2e1;         // 8 bits
    uint8_t  p2e2;         // 8 bits
    uint8_t  p2e3;         // 8 bits
    uint8_t  p2e4;         // 8 bits

    bool p2e1_valid;
    bool p2e2_valid;
    bool p2e3_valid;
    bool p2e4_valid;
};

/* Phase 2 clocks */
struct scanblk_SCLK4_cfg
{
    uint8_t  p2e5;         // 8 bits
    uint8_t  p2e6;         // 8 bits
    uint8_t  p2e7;         // 8 bits
    uint8_t  p2e8;         // 8 bits

    bool p2e5_valid;
    bool p2e6_valid;
    bool p2e7_valid;
    bool p2e8_valid;
};

struct scanblk_SCLK5_cfg
{
    uint8_t  rse1;         // 8 bits
    uint8_t  rse2;         // 8 bits
    uint8_t  rse3;         // 8 bits
    uint8_t  rse4;         // 8 bits

    bool rse1_valid;
    bool rse2_valid;
    bool rse3_valid;
    bool rse4_valid;
};

struct scanblk_SCLK6_cfg
{
    uint8_t  cpe1;         // 8 bits
    uint8_t  cpe2;         // 8 bits
    uint8_t  cpe3;         // 8 bits
    uint8_t  cpe4;         // 8 bits

    bool cpe1_valid;
    bool cpe2_valid;
    bool cpe3_valid;
    bool cpe4_valid;
};

struct scanblk_ACLK1_cfg
{
    uint8_t  mce1;         // 8 bits
    uint8_t  mce2;         // 8 bits
    uint8_t  mce3;         // 8 bits
    uint8_t  mce4;         // 8 bits

    bool mce1_valid;
    bool mce2_valid;
    bool mce3_valid;
    bool mce4_valid;
};

struct scanblk_ACLK2_cfg
{
    uint8_t  mce5;         // 8 bits
    uint8_t  mce6;         // 8 bits
    uint8_t  mce7;         // 8 bits
    uint8_t  mce8;         // 8 bits

    bool mce5_valid;
    bool mce6_valid;
    bool mce7_valid;
    bool mce8_valid;
};

struct scanblk_ACLK3_cfg
{
    uint8_t  mce9;         // 8 bits
    uint8_t  mce10;        // 8 bits
    uint8_t  mce11;        // 8 bits
    uint8_t  mce12;        // 8 bits

    bool mce9_valid;
    bool mce10_valid;
    bool mce11_valid;
    bool mce12_valid;
};

struct scanblk_ACLK6_cfg
{
    uint8_t  mce13;        // 8 bits
    uint8_t  mce14;        // 8 bits
    uint8_t  mce15;        // 8 bits
    uint8_t  mce16;        // 8 bits

    bool mce13_valid;
    bool mce14_valid;
    bool mce15_valid;
    bool mce16_valid;
};

struct scanblk_ACLK4_cfg
{
    uint8_t  vse1;         // 8 bits
    uint8_t  vse2;         // 8 bits
    uint8_t  vse3;         // 8 bits
    uint8_t  vse4;         // 8 bits

    bool vse1_valid;
    bool vse2_valid;
    bool vse3_valid;
    bool vse4_valid;
};

struct scanblk_ACLK5_cfg
{
    uint8_t  cd1e1;        // 8 bits
    uint8_t  cd1e2;        // 8 bits
    uint8_t  cd1e3;        // 8 bits
    uint8_t  cd1e4;        // 8 bits

    bool cd1e1_valid;
    bool cd1e2_valid;
    bool cd1e3_valid;
    bool cd1e4_valid;
};

/* AFE Load Data codes; 3 bits each; 16-bit value "ABCD" */
#define LDATA_CODE_CLEAR           0  /* clear all bits */
#define LDATA_CODE_AB_BITS         1  /* "AB", 8 MS bits */
#define LDATA_CODE_CD_BITS         2  /* "CD", LS bits */
#define LDATA_CODE_ABCD_BITS       3  /* "ABCD" (not implemented) */
#define LDATA_CODE_A_BITS          4  /* "A", 4 MS bits */
#define LDATA_CODE_B_BITS          5  /* "B", next 4 bits */
#define LDATA_CODE_C_BITS          6  /* "C", next 4 bits */
#define LDATA_CODE_D_BITS          7  /* "D", 4 LS bits */
#define LDATA_CODE_LOAD_COMPL  (1<<3) /* load complete */
#define LDATA_CODE_SEQ_COMPL   (1<<4) /* sequence complete */
struct scanblk_LDATA10_cfg
{
    uint8_t  ds1;          // 8 bits
    uint8_t  dc1;          // 6 bits
    uint8_t  ds2;          // 8 bits
    uint8_t  dc2;          // 6 bits

    bool ds1_valid;
    bool dc1_valid;
    bool ds2_valid;
    bool dc2_valid;
};

struct scanblk_LDATA11_cfg
{
    uint8_t  ds1;          // 8 bits
    uint8_t  dc1;          // 6 bits
    uint8_t  ds2;          // 8 bits
    uint8_t  dc2;          // 6 bits

    bool ds1_valid;
    bool dc1_valid;
    bool ds2_valid;
    bool dc2_valid;
};

struct scanblk_LDATA20_cfg
{
    uint8_t  ds3;          // 8 bits
    uint8_t  dc3;          // 6 bits
    uint8_t  ds4;          // 8 bits
    uint8_t  dc4;          // 6 bits

    bool ds3_valid;
    bool dc3_valid;
    bool ds4_valid;
    bool dc4_valid;
};

struct scanblk_LDATA21_cfg
{
    uint8_t  ds3;          // 8 bits
    uint8_t  dc3;          // 6 bits
    uint8_t  ds4;          // 8 bits
    uint8_t  dc4;          // 6 bits

    bool ds3_valid;
    bool dc3_valid;
    bool ds4_valid;
    bool dc4_valid;
};

struct scanblk_LDATA30_cfg
{
    uint8_t  ds5;          // 8 bits
    uint8_t  dc5;          // 6 bits
    uint8_t  ds6;          // 8 bits
    uint8_t  dc6;          // 6 bits

    bool ds5_valid;
    bool dc5_valid;
    bool ds6_valid;
    bool dc6_valid;
};

struct scanblk_LDATA31_cfg
{
    uint8_t  ds5;          // 8 bits
    uint8_t  dc5;          // 6 bits
    uint8_t  ds6;          // 8 bits
    uint8_t  dc6;          // 6 bits

    bool ds5_valid;
    bool dc5_valid;
    bool ds6_valid;
    bool dc6_valid;
};

struct scanblk_LDATA40_cfg
{
    uint8_t  ds7;          // 8 bits
    uint8_t  dc7;          // 6 bits
    uint8_t  ds8;          // 8 bits
    uint8_t  dc8;          // 6 bits

    bool ds7_valid;
    bool dc7_valid;
    bool ds8_valid;
    bool dc8_valid;
};

struct scanblk_LDATA41_cfg
{
    uint8_t  ds7;          // 8 bits
    uint8_t  dc7;          // 6 bits
    uint8_t  ds8;          // 8 bits
    uint8_t  dc8;          // 6 bits

    bool ds7_valid;
    bool dc7_valid;
    bool ds8_valid;
    bool dc8_valid;
};

struct scanblk_LDATA50_cfg
{
    uint8_t  ds9;          // 8 bits
    uint8_t  dc9;          // 6 bits
    uint8_t  ds10;         // 8 bits
    uint8_t  dc10;         // 6 bits

    bool ds9_valid;
    bool dc9_valid;
    bool ds10_valid;
    bool dc10_valid;
};

struct scanblk_LDATA51_cfg
{
    uint8_t  ds9;          // 8 bits
    uint8_t  dc9;          // 6 bits
    uint8_t  ds10;         // 8 bits
    uint8_t  dc10;         // 6 bits

    bool ds9_valid;
    bool dc9_valid;
    bool ds10_valid;
    bool dc10_valid;
};

struct scanblk_LDATA60_cfg
{
    uint8_t  ds11;         // 8 bits
    uint8_t  dc11;         // 6 bits
    uint8_t  ds12;         // 8 bits
    uint8_t  dc12;         // 6 bits

    bool ds11_valid;
    bool dc11_valid;
    bool ds12_valid;
    bool dc12_valid;
};

struct scanblk_LDATA61_cfg
{
    uint8_t  ds11;         // 8 bits
    uint8_t  dc11;         // 6 bits
    uint8_t  ds12;         // 8 bits
    uint8_t  dc12;         // 6 bits

    bool ds11_valid;
    bool dc11_valid;
    bool ds12_valid;
    bool dc12_valid;
};

struct scanblk_PSEQ1_cfg
{
    uint8_t  pseq1;        // 6 bits
    uint8_t  pseq2;        // 6 bits
    uint8_t  pseq3;        // 6 bits
    uint8_t  pseq4;        // 6 bits

    bool pseq1_valid;
    bool pseq2_valid;
    bool pseq3_valid;
    bool pseq4_valid;
};

struct scanblk_PSEQ2_cfg
{
    uint8_t  pseq5;        // 6 bits
    uint8_t  pseq6;        // 6 bits

    bool pseq5_valid;
    bool pseq6_valid;
};

struct scanblk_BPWM_cfg
{
    uint16_t bpwmper;      // 12 bits
    uint16_t bpwmdty;      // 12 bits

    bool bpwmper_valid;
    bool bpwmdty_valid;
};

struct scanblk_MCFG_cfg
{
    uint8_t  psmode;       // 1 bits
    uint8_t  pscfg;        // 3 bits
    uint16_t pscount;      // 10 bits
    uint8_t  lsmode;       // 2 bits
    uint8_t  mtype;        // 1 bits

    bool psmode_valid;
    bool pscfg_valid;
    bool pscount_valid;
    bool lsmode_valid;
    bool mtype_valid;
};

struct scanblk_MOTORSYNCMIN_cfg
{
    uint32_t msmin;        // 32 bits

    bool msmin_valid;
};

struct scanblk_AFEPC_cfg
{
    uint8_t  field_auto;   // 1 bits

    bool field_auto_valid;
};

struct scanblk_CFGARB_cfg
{
    uint8_t  channel;      // 6 bits
    uint8_t  extenable;    // 4 bits
    uint8_t  parenable;    // 2 bits

    bool channel_valid;
    bool extenable_valid;
    bool parenable_valid;
};

struct scanblk_LED00_cfg
{
    uint16_t led0pos;      // 16 bits
    uint16_t led0neg;      // 16 bits

    bool led0pos_valid;
    bool led0neg_valid;
};

struct scanblk_LED01_cfg
{
    uint16_t led0pos;      // 16 bits
    uint16_t led0neg;      // 16 bits

    bool led0pos_valid;
    bool led0neg_valid;
};

struct scanblk_LED10_cfg
{
    uint16_t led1pos;      // 16 bits
    uint16_t led1neg;      // 16 bits

    bool led1pos_valid;
    bool led1neg_valid;
};

struct scanblk_LED11_cfg
{
    uint16_t led1pos;      // 16 bits
    uint16_t led1neg;      // 16 bits

    bool led1pos_valid;
    bool led1neg_valid;
};

struct scanblk_LED20_cfg
{
    uint16_t led2pos;      // 16 bits
    uint16_t led2neg;      // 16 bits

    bool led2pos_valid;
    bool led2neg_valid;
};

struct scanblk_LED21_cfg
{
    uint16_t led2pos;      // 16 bits
    uint16_t led2neg;      // 16 bits

    bool led2pos_valid;
    bool led2neg_valid;
};

struct scanblk_LPWMCONFIG0_cfg
{
    uint16_t lpwmper;      // 16 bits
    uint8_t  ledpol;       // 3 bits

    bool lpwmper_valid;
    bool ledpol_valid;
};

struct scanblk_LPWMCONFIG1_cfg
{
    uint16_t lpwmper;      // 16 bits
    uint8_t  ledpol;       // 3 bits

    bool lpwmper_valid;
    bool ledpol_valid;
};

struct scanblk_LPWM00_cfg
{
    uint16_t led0on;       // 16 bits
    uint16_t led0off;      // 16 bits

    bool led0on_valid;
    bool led0off_valid;
};

struct scanblk_LPWM01_cfg
{
    uint16_t led0on;       // 16 bits
    uint16_t led0off;      // 16 bits

    bool led0on_valid;
    bool led0off_valid;
};

struct scanblk_LPWM10_cfg
{
    uint16_t led1on;       // 16 bits
    uint16_t led1off;      // 16 bits

    bool led1on_valid;
    bool led1off_valid;
};

struct scanblk_LPWM11_cfg
{
    uint16_t led1on;       // 16 bits
    uint16_t led1off;      // 16 bits

    bool led1on_valid;
    bool led1off_valid;
};

struct scanblk_LPWM20_cfg
{
    uint16_t led2on;       // 16 bits
    uint16_t led2off;      // 16 bits

    bool led2on_valid;
    bool led2off_valid;
};

struct scanblk_LPWM21_cfg
{
    uint16_t led2on;       // 16 bits
    uint16_t led2off;      // 16 bits

    bool led2on_valid;
    bool led2off_valid;
};

struct scanblk_EXCFG_cfg
{
    uint8_t  expenable;    // 8 bits
    uint8_t  expmask;      // 8 bits
    uint8_t  expdiv;       // 8 bits

    bool expenable_valid;
    bool expmask_valid;
    bool expdiv_valid;
};

struct scanblk_OFIE_cfg
{
    uint8_t  eovf_ie;      // 4 bits
    uint8_t  iovf_ie;      // 2 bits

    bool eovf_ie_valid;
    bool iovf_ie_valid;
};

struct scanblk_OFIP_cfg
{
    uint8_t  eovf_ip;      // 4 bits
    uint8_t  iovf_ip;      // 2 bits

    bool eovf_ip_valid;
    bool iovf_ip_valid;
};

struct scanblk_OFIA_cfg
{
    uint8_t  eovf_ia;      // 4 bits
    uint8_t  iovf_ia;      // 2 bits

    bool eovf_ia_valid;
    bool iovf_ia_valid;
};

struct scanblk_OFIF_cfg
{
    uint8_t  eovf_if;      // 4 bits
    uint8_t  iovf_if;      // 2 bits

    bool eovf_if_valid;
    bool iovf_if_valid;
};

struct scanblk_REV0_cfg
{
    uint16_t cfg;          // 16 bits
    uint16_t maj;          // 16 bits

    bool cfg_valid;
    bool maj_valid;
};

struct scanblk_REV1_cfg
{
    uint16_t mid;          // 16 bits

    bool mid_valid;
};

/*
 * This is what your callback should look like, when you want to be told about a scan block interrupt.
 * It'll populate the fields of scanblk_int_info to let you know what interrupts were fired.
 */
typedef int (*scanblk_irqcallback_fcn) (struct scanblk_irqs *scanblk_irq_info);

void scanblk_register_irqcallback(scanblk_irqcallback_fcn);
void scanblk_enable_int(struct scanblk_irqs *irqstruct);
void scanblk_get_enabled_ints(struct scanblk_irqs *irqstruct);
void scanblk_disable_int(struct scanblk_irqs *irqstruct);
void scanblk_clear_irqs(struct scanblk_irqs *irqstruct); // ack them
void scanblk_dump_regs(void);
void scanblk_soft_reset(void);
void scanblk_exit(void);
uint32_t scanblk_get_clk_speed(void);

/* Generated getters and setters: */

void scanblk_get_SCFG1(struct scanblk_SCFG1_cfg *cfg);
void scanblk_set_SCFG1(struct scanblk_SCFG1_cfg *cfg);
void scanblk_get_SCFG2(struct scanblk_SCFG2_cfg *cfg);
void scanblk_set_SCFG2(struct scanblk_SCFG2_cfg *cfg);
void scanblk_get_SCFG3(struct scanblk_SCFG3_cfg *cfg);
void scanblk_set_SCFG3(struct scanblk_SCFG3_cfg *cfg);
void scanblk_get_SCTRL(struct scanblk_SCTRL_cfg *cfg);
void scanblk_set_SCTRL(struct scanblk_SCTRL_cfg *cfg);
void scanblk_set_SCTRL_isr(struct scanblk_SCTRL_cfg *cfg);
void scanblk_get_SCMD(struct scanblk_SCMD_cfg *cfg);
void scanblk_set_SCMD(struct scanblk_SCMD_cfg *cfg);
void scanblk_set_SCMD_isr(struct scanblk_SCMD_cfg *cfg);
void scanblk_get_SSTAT(struct scanblk_SSTAT_cfg *cfg);
// no setter for SSTAT -- read only
// no getter for SIACK -- write only
void scanblk_set_SIACK(struct scanblk_irqs *cfg);
void scanblk_get_SCANX(struct scanblk_SCANX_cfg *cfg);
void scanblk_set_SCANX(struct scanblk_SCANX_cfg *cfg);
void scanblk_get_SCYCLE(struct scanblk_SCYCLE_cfg *cfg);
void scanblk_set_SCYCLE(struct scanblk_SCYCLE_cfg *cfg);
void scanblk_get_STCFG1(struct scanblk_STCFG1_cfg *cfg);
void scanblk_set_STCFG1(struct scanblk_STCFG1_cfg *cfg);
void scanblk_get_STCFG2(struct scanblk_STCFG2_cfg *cfg);
void scanblk_set_STCFG2(struct scanblk_STCFG2_cfg *cfg);
void scanblk_get_STCFG3(struct scanblk_STCFG3_cfg *cfg);
void scanblk_set_STCFG3(struct scanblk_STCFG3_cfg *cfg);
void scanblk_get_STCFG4(struct scanblk_STCFG4_cfg *cfg);
void scanblk_set_STCFG4(struct scanblk_STCFG4_cfg *cfg);
void scanblk_get_CCFG(struct scanblk_CCFG_cfg *cfg);
void scanblk_set_CCFG(struct scanblk_CCFG_cfg *cfg);
void scanblk_get_SCLK1(struct scanblk_SCLK1_cfg *cfg);
void scanblk_set_SCLK1(struct scanblk_SCLK1_cfg *cfg);
void scanblk_get_SCLK2(struct scanblk_SCLK2_cfg *cfg);
void scanblk_set_SCLK2(struct scanblk_SCLK2_cfg *cfg);
void scanblk_get_SCLK3(struct scanblk_SCLK3_cfg *cfg);
void scanblk_set_SCLK3(struct scanblk_SCLK3_cfg *cfg);
void scanblk_get_SCLK4(struct scanblk_SCLK4_cfg *cfg);
void scanblk_set_SCLK4(struct scanblk_SCLK4_cfg *cfg);
void scanblk_get_SCLK5(struct scanblk_SCLK5_cfg *cfg);
void scanblk_set_SCLK5(struct scanblk_SCLK5_cfg *cfg);
void scanblk_get_SCLK6(struct scanblk_SCLK6_cfg *cfg);
void scanblk_set_SCLK6(struct scanblk_SCLK6_cfg *cfg);
void scanblk_get_ACLK1(struct scanblk_ACLK1_cfg *cfg);
void scanblk_set_ACLK1(struct scanblk_ACLK1_cfg *cfg);
void scanblk_get_ACLK2(struct scanblk_ACLK2_cfg *cfg);
void scanblk_set_ACLK2(struct scanblk_ACLK2_cfg *cfg);
void scanblk_get_ACLK3(struct scanblk_ACLK3_cfg *cfg);
void scanblk_set_ACLK3(struct scanblk_ACLK3_cfg *cfg);
void scanblk_get_ACLK6(struct scanblk_ACLK6_cfg *cfg);
void scanblk_set_ACLK6(struct scanblk_ACLK6_cfg *cfg);
void scanblk_get_ACLK4(struct scanblk_ACLK4_cfg *cfg);
void scanblk_set_ACLK4(struct scanblk_ACLK4_cfg *cfg);
void scanblk_get_ACLK5(struct scanblk_ACLK5_cfg *cfg);
void scanblk_set_ACLK5(struct scanblk_ACLK5_cfg *cfg);
void scanblk_get_LDATA10(struct scanblk_LDATA10_cfg *cfg);
void scanblk_set_LDATA10(struct scanblk_LDATA10_cfg *cfg);
void scanblk_get_LDATA11(struct scanblk_LDATA11_cfg *cfg);
void scanblk_set_LDATA11(struct scanblk_LDATA11_cfg *cfg);
void scanblk_get_LDATA20(struct scanblk_LDATA20_cfg *cfg);
void scanblk_set_LDATA20(struct scanblk_LDATA20_cfg *cfg);
void scanblk_get_LDATA21(struct scanblk_LDATA21_cfg *cfg);
void scanblk_set_LDATA21(struct scanblk_LDATA21_cfg *cfg);
void scanblk_get_LDATA30(struct scanblk_LDATA30_cfg *cfg);
void scanblk_set_LDATA30(struct scanblk_LDATA30_cfg *cfg);
void scanblk_get_LDATA31(struct scanblk_LDATA31_cfg *cfg);
void scanblk_set_LDATA31(struct scanblk_LDATA31_cfg *cfg);
void scanblk_get_LDATA40(struct scanblk_LDATA40_cfg *cfg);
void scanblk_set_LDATA40(struct scanblk_LDATA40_cfg *cfg);
void scanblk_get_LDATA41(struct scanblk_LDATA41_cfg *cfg);
void scanblk_set_LDATA41(struct scanblk_LDATA41_cfg *cfg);
void scanblk_get_LDATA50(struct scanblk_LDATA50_cfg *cfg);
void scanblk_set_LDATA50(struct scanblk_LDATA50_cfg *cfg);
void scanblk_get_LDATA51(struct scanblk_LDATA51_cfg *cfg);
void scanblk_set_LDATA51(struct scanblk_LDATA51_cfg *cfg);
void scanblk_get_LDATA60(struct scanblk_LDATA60_cfg *cfg);
void scanblk_set_LDATA60(struct scanblk_LDATA60_cfg *cfg);
void scanblk_get_LDATA61(struct scanblk_LDATA61_cfg *cfg);
void scanblk_set_LDATA61(struct scanblk_LDATA61_cfg *cfg);
void scanblk_get_PSEQ1(struct scanblk_PSEQ1_cfg *cfg);
void scanblk_set_PSEQ1(struct scanblk_PSEQ1_cfg *cfg);
void scanblk_get_PSEQ2(struct scanblk_PSEQ2_cfg *cfg);
void scanblk_set_PSEQ2(struct scanblk_PSEQ2_cfg *cfg);
void scanblk_get_BPWM(struct scanblk_BPWM_cfg *cfg);
void scanblk_set_BPWM(struct scanblk_BPWM_cfg *cfg);
void scanblk_get_MCFG(struct scanblk_MCFG_cfg *cfg);
void scanblk_set_MCFG(struct scanblk_MCFG_cfg *cfg);
void scanblk_get_MOTORSYNCMIN(struct scanblk_MOTORSYNCMIN_cfg *cfg);
void scanblk_set_MOTORSYNCMIN(struct scanblk_MOTORSYNCMIN_cfg *cfg);
void scanblk_get_AFEPC(struct scanblk_AFEPC_cfg *cfg);
void scanblk_set_AFEPC(struct scanblk_AFEPC_cfg *cfg);
void scanblk_get_CFGARB(struct scanblk_CFGARB_cfg *cfg);
void scanblk_set_CFGARB(struct scanblk_CFGARB_cfg *cfg);
void scanblk_get_LED00(struct scanblk_LED00_cfg *cfg);
void scanblk_set_LED00(struct scanblk_LED00_cfg *cfg);
void scanblk_get_LED01(struct scanblk_LED01_cfg *cfg);
void scanblk_set_LED01(struct scanblk_LED01_cfg *cfg);
void scanblk_get_LED10(struct scanblk_LED10_cfg *cfg);
void scanblk_set_LED10(struct scanblk_LED10_cfg *cfg);
void scanblk_get_LED11(struct scanblk_LED11_cfg *cfg);
void scanblk_set_LED11(struct scanblk_LED11_cfg *cfg);
void scanblk_get_LED20(struct scanblk_LED20_cfg *cfg);
void scanblk_set_LED20(struct scanblk_LED20_cfg *cfg);
void scanblk_get_LED21(struct scanblk_LED21_cfg *cfg);
void scanblk_set_LED21(struct scanblk_LED21_cfg *cfg);
void scanblk_get_LPWMCONFIG0(struct scanblk_LPWMCONFIG0_cfg *cfg);
void scanblk_set_LPWMCONFIG0(struct scanblk_LPWMCONFIG0_cfg *cfg);
void scanblk_get_LPWMCONFIG1(struct scanblk_LPWMCONFIG1_cfg *cfg);
void scanblk_set_LPWMCONFIG1(struct scanblk_LPWMCONFIG1_cfg *cfg);
void scanblk_get_LPWM00(struct scanblk_LPWM00_cfg *cfg);
void scanblk_set_LPWM00(struct scanblk_LPWM00_cfg *cfg);
void scanblk_get_LPWM01(struct scanblk_LPWM01_cfg *cfg);
void scanblk_set_LPWM01(struct scanblk_LPWM01_cfg *cfg);
void scanblk_get_LPWM10(struct scanblk_LPWM10_cfg *cfg);
void scanblk_set_LPWM10(struct scanblk_LPWM10_cfg *cfg);
void scanblk_get_LPWM11(struct scanblk_LPWM11_cfg *cfg);
void scanblk_set_LPWM11(struct scanblk_LPWM11_cfg *cfg);
void scanblk_get_LPWM20(struct scanblk_LPWM20_cfg *cfg);
void scanblk_set_LPWM20(struct scanblk_LPWM20_cfg *cfg);
void scanblk_get_LPWM21(struct scanblk_LPWM21_cfg *cfg);
void scanblk_set_LPWM21(struct scanblk_LPWM21_cfg *cfg);
void scanblk_get_EXCFG(struct scanblk_EXCFG_cfg *cfg);
void scanblk_set_EXCFG(struct scanblk_EXCFG_cfg *cfg);
void scanblk_get_OFIE(struct scanblk_OFIE_cfg *cfg);
void scanblk_set_OFIE(struct scanblk_OFIE_cfg *cfg);
void scanblk_get_OFIP(struct scanblk_OFIP_cfg *cfg);
// no setter for OFIP -- read only
// no getter for OFIA -- write only
void scanblk_set_OFIA(struct scanblk_OFIA_cfg *cfg);
// no getter for OFIF -- write only
void scanblk_set_OFIF(struct scanblk_OFIF_cfg *cfg);
void scanblk_get_REV0(struct scanblk_REV0_cfg *cfg);
// no setter for REV0 -- read only
void scanblk_get_REV1(struct scanblk_REV1_cfg *cfg);
// no setter for REV1 -- read only

#endif
