/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _SCANBLK_driver_H_
#define _SCANBLK_driver_H_

// interface between scanblk.c and the layer below it

enum scanblk_subblock
{
    scanblk_top,            /* Not yet implemented */
    scanblk_common,
    scanblk_vcap,           /* Not yet implemented */
    scanblk_lvdsafe0,       /* Not yet implemented */
    scanblk_lvdsafe1,       /* Not yet implemented */
};

// These objects (handles to the blocks) are kept by scanblk.c at subblock registration time
typedef struct device_data scanblkDeviceHandle;

/////////////////////////////////////////////////////////////////////////////
// function tables passed to scanblk.c

struct scanblk_common_function_struct
{
    int version;

    void (*register_irqcallback) (scanblkDeviceHandle *device_data, scanblk_irqcallback_fcn fcn);
    void (*enable_int)           (scanblkDeviceHandle *device_data, struct scanblk_irqs *irqstruct);
    void (*get_enabled_ints)     (scanblkDeviceHandle *device_data, struct scanblk_irqs *irqstruct);
    void (*disable_int)          (scanblkDeviceHandle *device_data, struct scanblk_irqs *irqstruct);
    void (*clear_scan_irqs)      (scanblkDeviceHandle *device_data, struct scanblk_irqs *irqstruct);
    void (*dump_regs)            (scanblkDeviceHandle *device_data);
    void (*soft_reset)           (scanblkDeviceHandle *device_data);
    void (*register_override)    (scanblkDeviceHandle *device_data, char * regname, uint32_t value);
    uint32_t (*get_clk_speed)    (scanblkDeviceHandle *device_data);

    /* Getters and setters for various properties */
    void (*get_scanblk_SCFG1) (scanblkDeviceHandle *device_data, struct scanblk_SCFG1_cfg *cfg);
    void (*set_scanblk_SCFG1) (scanblkDeviceHandle *device_data, struct scanblk_SCFG1_cfg *cfg);

    void (*get_scanblk_SCFG2) (scanblkDeviceHandle *device_data, struct scanblk_SCFG2_cfg *cfg);
    void (*set_scanblk_SCFG2) (scanblkDeviceHandle *device_data, struct scanblk_SCFG2_cfg *cfg);

    void (*get_scanblk_SCFG3) (scanblkDeviceHandle *device_data, struct scanblk_SCFG3_cfg *cfg);
    void (*set_scanblk_SCFG3) (scanblkDeviceHandle *device_data, struct scanblk_SCFG3_cfg *cfg);

    void (*get_scanblk_SCTRL)     (scanblkDeviceHandle *device_data, struct scanblk_SCTRL_cfg *cfg);
    void (*set_scanblk_SCTRL)     (scanblkDeviceHandle *device_data, struct scanblk_SCTRL_cfg *cfg);
    void (*set_scanblk_SCTRL_isr) (scanblkDeviceHandle *device_data, struct scanblk_SCTRL_cfg *cfg);

    void (*get_scanblk_SCMD)     (scanblkDeviceHandle *device_data, struct scanblk_SCMD_cfg *cfg);
    void (*set_scanblk_SCMD)     (scanblkDeviceHandle *device_data, struct scanblk_SCMD_cfg *cfg);
    void (*set_scanblk_SCMD_isr) (scanblkDeviceHandle *device_data, struct scanblk_SCMD_cfg *cfg);

    void (*get_scanblk_SSTAT) (scanblkDeviceHandle *device_data, struct scanblk_SSTAT_cfg *cfg);
    /* read only -- no setter */

    /* write only -- no getter */
    void (*set_scanblk_SIACK) (scanblkDeviceHandle *device_data, struct scanblk_irqs *cfg);

    void (*get_scanblk_SCANX) (scanblkDeviceHandle *device_data, struct scanblk_SCANX_cfg *cfg);
    void (*set_scanblk_SCANX) (scanblkDeviceHandle *device_data, struct scanblk_SCANX_cfg *cfg);

    void (*get_scanblk_SCYCLE) (scanblkDeviceHandle *device_data, struct scanblk_SCYCLE_cfg *cfg);
    void (*set_scanblk_SCYCLE) (scanblkDeviceHandle *device_data, struct scanblk_SCYCLE_cfg *cfg);

    void (*get_scanblk_STCFG1) (scanblkDeviceHandle *device_data, struct scanblk_STCFG1_cfg *cfg);
    void (*set_scanblk_STCFG1) (scanblkDeviceHandle *device_data, struct scanblk_STCFG1_cfg *cfg);

    void (*get_scanblk_STCFG2) (scanblkDeviceHandle *device_data, struct scanblk_STCFG2_cfg *cfg);
    void (*set_scanblk_STCFG2) (scanblkDeviceHandle *device_data, struct scanblk_STCFG2_cfg *cfg);

    void (*get_scanblk_STCFG3) (scanblkDeviceHandle *device_data, struct scanblk_STCFG3_cfg *cfg);
    void (*set_scanblk_STCFG3) (scanblkDeviceHandle *device_data, struct scanblk_STCFG3_cfg *cfg);

    void (*get_scanblk_STCFG4) (scanblkDeviceHandle *device_data, struct scanblk_STCFG4_cfg *cfg);
    void (*set_scanblk_STCFG4) (scanblkDeviceHandle *device_data, struct scanblk_STCFG4_cfg *cfg);

    void (*get_scanblk_CCFG) (scanblkDeviceHandle *device_data, struct scanblk_CCFG_cfg *cfg);
    void (*set_scanblk_CCFG) (scanblkDeviceHandle *device_data, struct scanblk_CCFG_cfg *cfg);

    void (*get_scanblk_SCLK1) (scanblkDeviceHandle *device_data, struct scanblk_SCLK1_cfg *cfg);
    void (*set_scanblk_SCLK1) (scanblkDeviceHandle *device_data, struct scanblk_SCLK1_cfg *cfg);

    void (*get_scanblk_SCLK2) (scanblkDeviceHandle *device_data, struct scanblk_SCLK2_cfg *cfg);
    void (*set_scanblk_SCLK2) (scanblkDeviceHandle *device_data, struct scanblk_SCLK2_cfg *cfg);

    void (*get_scanblk_SCLK3) (scanblkDeviceHandle *device_data, struct scanblk_SCLK3_cfg *cfg);
    void (*set_scanblk_SCLK3) (scanblkDeviceHandle *device_data, struct scanblk_SCLK3_cfg *cfg);

    void (*get_scanblk_SCLK4) (scanblkDeviceHandle *device_data, struct scanblk_SCLK4_cfg *cfg);
    void (*set_scanblk_SCLK4) (scanblkDeviceHandle *device_data, struct scanblk_SCLK4_cfg *cfg);

    void (*get_scanblk_SCLK5) (scanblkDeviceHandle *device_data, struct scanblk_SCLK5_cfg *cfg);
    void (*set_scanblk_SCLK5) (scanblkDeviceHandle *device_data, struct scanblk_SCLK5_cfg *cfg);

    void (*get_scanblk_SCLK6) (scanblkDeviceHandle *device_data, struct scanblk_SCLK6_cfg *cfg);
    void (*set_scanblk_SCLK6) (scanblkDeviceHandle *device_data, struct scanblk_SCLK6_cfg *cfg);

    void (*get_scanblk_ACLK1) (scanblkDeviceHandle *device_data, struct scanblk_ACLK1_cfg *cfg);
    void (*set_scanblk_ACLK1) (scanblkDeviceHandle *device_data, struct scanblk_ACLK1_cfg *cfg);

    void (*get_scanblk_ACLK2) (scanblkDeviceHandle *device_data, struct scanblk_ACLK2_cfg *cfg);
    void (*set_scanblk_ACLK2) (scanblkDeviceHandle *device_data, struct scanblk_ACLK2_cfg *cfg);

    void (*get_scanblk_ACLK3) (scanblkDeviceHandle *device_data, struct scanblk_ACLK3_cfg *cfg);
    void (*set_scanblk_ACLK3) (scanblkDeviceHandle *device_data, struct scanblk_ACLK3_cfg *cfg);

    void (*get_scanblk_ACLK6) (scanblkDeviceHandle *device_data, struct scanblk_ACLK6_cfg *cfg);
    void (*set_scanblk_ACLK6) (scanblkDeviceHandle *device_data, struct scanblk_ACLK6_cfg *cfg);

    void (*get_scanblk_ACLK4) (scanblkDeviceHandle *device_data, struct scanblk_ACLK4_cfg *cfg);
    void (*set_scanblk_ACLK4) (scanblkDeviceHandle *device_data, struct scanblk_ACLK4_cfg *cfg);

    void (*get_scanblk_ACLK5) (scanblkDeviceHandle *device_data, struct scanblk_ACLK5_cfg *cfg);
    void (*set_scanblk_ACLK5) (scanblkDeviceHandle *device_data, struct scanblk_ACLK5_cfg *cfg);

    void (*get_scanblk_LDATA10) (scanblkDeviceHandle *device_data, struct scanblk_LDATA10_cfg *cfg);
    void (*set_scanblk_LDATA10) (scanblkDeviceHandle *device_data, struct scanblk_LDATA10_cfg *cfg);

    void (*get_scanblk_LDATA11) (scanblkDeviceHandle *device_data, struct scanblk_LDATA11_cfg *cfg);
    void (*set_scanblk_LDATA11) (scanblkDeviceHandle *device_data, struct scanblk_LDATA11_cfg *cfg);

    void (*get_scanblk_LDATA20) (scanblkDeviceHandle *device_data, struct scanblk_LDATA20_cfg *cfg);
    void (*set_scanblk_LDATA20) (scanblkDeviceHandle *device_data, struct scanblk_LDATA20_cfg *cfg);

    void (*get_scanblk_LDATA21) (scanblkDeviceHandle *device_data, struct scanblk_LDATA21_cfg *cfg);
    void (*set_scanblk_LDATA21) (scanblkDeviceHandle *device_data, struct scanblk_LDATA21_cfg *cfg);

    void (*get_scanblk_LDATA30) (scanblkDeviceHandle *device_data, struct scanblk_LDATA30_cfg *cfg);
    void (*set_scanblk_LDATA30) (scanblkDeviceHandle *device_data, struct scanblk_LDATA30_cfg *cfg);

    void (*get_scanblk_LDATA31) (scanblkDeviceHandle *device_data, struct scanblk_LDATA31_cfg *cfg);
    void (*set_scanblk_LDATA31) (scanblkDeviceHandle *device_data, struct scanblk_LDATA31_cfg *cfg);

    void (*get_scanblk_LDATA40) (scanblkDeviceHandle *device_data, struct scanblk_LDATA40_cfg *cfg);
    void (*set_scanblk_LDATA40) (scanblkDeviceHandle *device_data, struct scanblk_LDATA40_cfg *cfg);

    void (*get_scanblk_LDATA41) (scanblkDeviceHandle *device_data, struct scanblk_LDATA41_cfg *cfg);
    void (*set_scanblk_LDATA41) (scanblkDeviceHandle *device_data, struct scanblk_LDATA41_cfg *cfg);

    void (*get_scanblk_LDATA50) (scanblkDeviceHandle *device_data, struct scanblk_LDATA50_cfg *cfg);
    void (*set_scanblk_LDATA50) (scanblkDeviceHandle *device_data, struct scanblk_LDATA50_cfg *cfg);

    void (*get_scanblk_LDATA51) (scanblkDeviceHandle *device_data, struct scanblk_LDATA51_cfg *cfg);
    void (*set_scanblk_LDATA51) (scanblkDeviceHandle *device_data, struct scanblk_LDATA51_cfg *cfg);

    void (*get_scanblk_LDATA60) (scanblkDeviceHandle *device_data, struct scanblk_LDATA60_cfg *cfg);
    void (*set_scanblk_LDATA60) (scanblkDeviceHandle *device_data, struct scanblk_LDATA60_cfg *cfg);

    void (*get_scanblk_LDATA61) (scanblkDeviceHandle *device_data, struct scanblk_LDATA61_cfg *cfg);
    void (*set_scanblk_LDATA61) (scanblkDeviceHandle *device_data, struct scanblk_LDATA61_cfg *cfg);

    void (*get_scanblk_PSEQ1) (scanblkDeviceHandle *device_data, struct scanblk_PSEQ1_cfg *cfg);
    void (*set_scanblk_PSEQ1) (scanblkDeviceHandle *device_data, struct scanblk_PSEQ1_cfg *cfg);

    void (*get_scanblk_PSEQ2) (scanblkDeviceHandle *device_data, struct scanblk_PSEQ2_cfg *cfg);
    void (*set_scanblk_PSEQ2) (scanblkDeviceHandle *device_data, struct scanblk_PSEQ2_cfg *cfg);

    void (*get_scanblk_BPWM) (scanblkDeviceHandle *device_data, struct scanblk_BPWM_cfg *cfg);
    void (*set_scanblk_BPWM) (scanblkDeviceHandle *device_data, struct scanblk_BPWM_cfg *cfg);

    void (*get_scanblk_MCFG) (scanblkDeviceHandle *device_data, struct scanblk_MCFG_cfg *cfg);
    void (*set_scanblk_MCFG) (scanblkDeviceHandle *device_data, struct scanblk_MCFG_cfg *cfg);

    void (*get_scanblk_MOTORSYNCMIN) (scanblkDeviceHandle *device_data, struct scanblk_MOTORSYNCMIN_cfg *cfg);
    void (*set_scanblk_MOTORSYNCMIN) (scanblkDeviceHandle *device_data, struct scanblk_MOTORSYNCMIN_cfg *cfg);

    void (*get_scanblk_AFEPC) (scanblkDeviceHandle *device_data, struct scanblk_AFEPC_cfg *cfg);
    void (*set_scanblk_AFEPC) (scanblkDeviceHandle *device_data, struct scanblk_AFEPC_cfg *cfg);

    void (*get_scanblk_CFGARB) (scanblkDeviceHandle *device_data, struct scanblk_CFGARB_cfg *cfg);
    void (*set_scanblk_CFGARB) (scanblkDeviceHandle *device_data, struct scanblk_CFGARB_cfg *cfg);

    void (*get_scanblk_LED00) (scanblkDeviceHandle *device_data, struct scanblk_LED00_cfg *cfg);
    void (*set_scanblk_LED00) (scanblkDeviceHandle *device_data, struct scanblk_LED00_cfg *cfg);

    void (*get_scanblk_LED01) (scanblkDeviceHandle *device_data, struct scanblk_LED01_cfg *cfg);
    void (*set_scanblk_LED01) (scanblkDeviceHandle *device_data, struct scanblk_LED01_cfg *cfg);

    void (*get_scanblk_LED10) (scanblkDeviceHandle *device_data, struct scanblk_LED10_cfg *cfg);
    void (*set_scanblk_LED10) (scanblkDeviceHandle *device_data, struct scanblk_LED10_cfg *cfg);

    void (*get_scanblk_LED11) (scanblkDeviceHandle *device_data, struct scanblk_LED11_cfg *cfg);
    void (*set_scanblk_LED11) (scanblkDeviceHandle *device_data, struct scanblk_LED11_cfg *cfg);

    void (*get_scanblk_LED20) (scanblkDeviceHandle *device_data, struct scanblk_LED20_cfg *cfg);
    void (*set_scanblk_LED20) (scanblkDeviceHandle *device_data, struct scanblk_LED20_cfg *cfg);

    void (*get_scanblk_LED21) (scanblkDeviceHandle *device_data, struct scanblk_LED21_cfg *cfg);
    void (*set_scanblk_LED21) (scanblkDeviceHandle *device_data, struct scanblk_LED21_cfg *cfg);

    void (*get_scanblk_LPWMCONFIG0) (scanblkDeviceHandle *device_data, struct scanblk_LPWMCONFIG0_cfg *cfg);
    void (*set_scanblk_LPWMCONFIG0) (scanblkDeviceHandle *device_data, struct scanblk_LPWMCONFIG0_cfg *cfg);

    void (*get_scanblk_LPWMCONFIG1) (scanblkDeviceHandle *device_data, struct scanblk_LPWMCONFIG1_cfg *cfg);
    void (*set_scanblk_LPWMCONFIG1) (scanblkDeviceHandle *device_data, struct scanblk_LPWMCONFIG1_cfg *cfg);

    void (*get_scanblk_LPWM00) (scanblkDeviceHandle *device_data, struct scanblk_LPWM00_cfg *cfg);
    void (*set_scanblk_LPWM00) (scanblkDeviceHandle *device_data, struct scanblk_LPWM00_cfg *cfg);

    void (*get_scanblk_LPWM01) (scanblkDeviceHandle *device_data, struct scanblk_LPWM01_cfg *cfg);
    void (*set_scanblk_LPWM01) (scanblkDeviceHandle *device_data, struct scanblk_LPWM01_cfg *cfg);

    void (*get_scanblk_LPWM10) (scanblkDeviceHandle *device_data, struct scanblk_LPWM10_cfg *cfg);
    void (*set_scanblk_LPWM10) (scanblkDeviceHandle *device_data, struct scanblk_LPWM10_cfg *cfg);

    void (*get_scanblk_LPWM11) (scanblkDeviceHandle *device_data, struct scanblk_LPWM11_cfg *cfg);
    void (*set_scanblk_LPWM11) (scanblkDeviceHandle *device_data, struct scanblk_LPWM11_cfg *cfg);

    void (*get_scanblk_LPWM20) (scanblkDeviceHandle *device_data, struct scanblk_LPWM20_cfg *cfg);
    void (*set_scanblk_LPWM20) (scanblkDeviceHandle *device_data, struct scanblk_LPWM20_cfg *cfg);

    void (*get_scanblk_LPWM21) (scanblkDeviceHandle *device_data, struct scanblk_LPWM21_cfg *cfg);
    void (*set_scanblk_LPWM21) (scanblkDeviceHandle *device_data, struct scanblk_LPWM21_cfg *cfg);

    void (*get_scanblk_EXCFG) (scanblkDeviceHandle *device_data, struct scanblk_EXCFG_cfg *cfg);
    void (*set_scanblk_EXCFG) (scanblkDeviceHandle *device_data, struct scanblk_EXCFG_cfg *cfg);

    void (*get_scanblk_OFIE) (scanblkDeviceHandle *device_data, struct scanblk_OFIE_cfg *cfg);
    void (*set_scanblk_OFIE) (scanblkDeviceHandle *device_data, struct scanblk_OFIE_cfg *cfg);

    void (*get_scanblk_OFIP) (scanblkDeviceHandle *device_data, struct scanblk_OFIP_cfg *cfg);
    /* read only -- no setter */

    /* write only -- no getter */
    void (*set_scanblk_OFIA) (scanblkDeviceHandle *device_data, struct scanblk_OFIA_cfg *cfg);

    /* write only -- no getter */
    void (*set_scanblk_OFIF) (scanblkDeviceHandle *device_data, struct scanblk_OFIF_cfg *cfg);

    void (*get_scanblk_REV0) (scanblkDeviceHandle *device_data, struct scanblk_REV0_cfg *cfg);
    /* read only -- no setter */

    void (*get_scanblk_REV1) (scanblkDeviceHandle *device_data, struct scanblk_REV1_cfg *cfg);
    /* read only -- no setter */
};
////////////////////////////////////////////////////////////////////////////

//registration function - subblocks register at init or probe time, and unregister at remove time
void register_scanblk_subblock(enum scanblk_subblock subblock,
                               void *scanblk_subblock_data);
void *unregister_scanblk_subblock(enum scanblk_subblock subblock);



#endif
