/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

// top level driver for the icetest block
#include <linux/spinlock.h> // for spinlock_t, printk, BUG_ON
#include <linux/export.h>

#include "scanblk_if.h"
#include "scanblk_driver.h"
#include "scanblk_data.h"

struct scanblk_object_struct
{
    scanblkDeviceHandle *scanblk_handle;
    // If we add further subblocks (or a second scanblk), it would go here
};

struct scanblk_object_struct scanblk_object;

#define SCANBLK_RETRIEVE_handle_ft                  \
    scanblkDeviceHandle *scanblk_handle;            \
    struct scanblk_common_function_struct *ft;      \
                                                    \
    scanblk_handle = scanblk_object.scanblk_handle; \
    BUG_ON(scanblk_handle == NULL);                 \
    ft = scanblk_handle->fcn_tbl;


static void init_scanblk_object_struct(void)
{
    scanblk_object.scanblk_handle = NULL;
}

void register_scanblk_subblock(enum scanblk_subblock subblock,
                               void *scanblk_subblock_data)
{
    static int initialized=0;

    if (initialized == 0)
    {
        init_scanblk_object_struct();
        initialized = 1;
    }

    if (subblock == scanblk_common)
    {
        debug_print("registered scanblk with scanblk.c\n");
        scanblk_object.scanblk_handle = scanblk_subblock_data;
    }
    else
    {
        debug_print("Error!!! no support yet for block %d\n", subblock);
    }
}
EXPORT_SYMBOL(register_scanblk_subblock);

void *unregister_scanblk_subblock(enum scanblk_subblock subblock)
{
    void *subblock_data;

    if (subblock == scanblk_common)
    {
        subblock_data = scanblk_object.scanblk_handle;
        scanblk_object.scanblk_handle = NULL;
    }
    else
    {
        debug_print("Error!!! no support yet for block %d\n", subblock);
        return NULL;
    }
    return subblock_data;
}
EXPORT_SYMBOL(unregister_scanblk_subblock);

//////////////////////// start of public API functions /////////////////////
void scanblk_register_irqcallback(scanblk_irqcallback_fcn fcn)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->register_irqcallback == NULL);
    ft->register_irqcallback(scanblk_handle, fcn);
}
EXPORT_SYMBOL(scanblk_register_irqcallback);

void scanblk_enable_int(struct scanblk_irqs *irqstruct)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->enable_int == NULL);
    ft->enable_int(scanblk_handle, irqstruct);
}
EXPORT_SYMBOL(scanblk_enable_int);

void scanblk_get_enabled_ints(struct scanblk_irqs *irqstruct)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_enabled_ints == NULL);
    ft->get_enabled_ints(scanblk_handle, irqstruct);
}
EXPORT_SYMBOL(scanblk_get_enabled_ints);

void scanblk_disable_int(struct scanblk_irqs *irqstruct)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->disable_int == NULL);
    ft->disable_int(scanblk_handle, irqstruct);
}
EXPORT_SYMBOL(scanblk_disable_int);

void scanblk_clear_irqs(struct scanblk_irqs *irqstruct) // ack them
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->clear_scan_irqs == NULL);
    ft->clear_scan_irqs(scanblk_handle, irqstruct);
}
EXPORT_SYMBOL(scanblk_clear_irqs);

void scanblk_dump_regs(void)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->dump_regs == NULL);
    ft->dump_regs(scanblk_handle);
}
EXPORT_SYMBOL(scanblk_dump_regs);

void scanblk_soft_reset(void)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->soft_reset == NULL);
    ft->soft_reset(scanblk_handle);
}
EXPORT_SYMBOL(scanblk_soft_reset);

void scanblk_exit(void)
{
    debug_print("%s: empty stub for now\n", __func__);
}
EXPORT_SYMBOL(scanblk_exit);


void scanblk_register_override(char * regname, uint32_t value)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->register_override == NULL);
    ft->register_override(scanblk_handle, regname, value);
}
EXPORT_SYMBOL(scanblk_register_override);

uint32_t scanblk_get_clk_speed(void)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_clk_speed == NULL);
    return ft->get_clk_speed(scanblk_handle);
}
EXPORT_SYMBOL(scanblk_get_clk_speed);

/************************************************************************/
/************************************************************************/
/************************************************************************/
/******************** Generated stuff: **********************************/
/************************************************************************/
/************************************************************************/
/************************************************************************/
void scanblk_get_SCFG1(struct scanblk_SCFG1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCFG1 == NULL);
    ft->get_scanblk_SCFG1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCFG1);

void scanblk_set_SCFG1(struct scanblk_SCFG1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCFG1 == NULL);
    ft->set_scanblk_SCFG1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCFG1);

void scanblk_get_SCFG2(struct scanblk_SCFG2_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCFG2 == NULL);
    ft->get_scanblk_SCFG2(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCFG2);

void scanblk_set_SCFG2(struct scanblk_SCFG2_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCFG2 == NULL);
    ft->set_scanblk_SCFG2(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCFG2);

void scanblk_get_SCFG3(struct scanblk_SCFG3_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCFG3 == NULL);
    ft->get_scanblk_SCFG3(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCFG3);

void scanblk_set_SCFG3(struct scanblk_SCFG3_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCFG3 == NULL);
    ft->set_scanblk_SCFG3(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCFG3);

void scanblk_get_SCTRL(struct scanblk_SCTRL_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCTRL == NULL);
    ft->get_scanblk_SCTRL(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCTRL);

void scanblk_set_SCTRL(struct scanblk_SCTRL_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCTRL == NULL);
    ft->set_scanblk_SCTRL(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCTRL);

void scanblk_set_SCTRL_isr(struct scanblk_SCTRL_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCTRL_isr == NULL);
    ft->set_scanblk_SCTRL_isr(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCTRL_isr);

void scanblk_get_SCMD(struct scanblk_SCMD_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCMD == NULL);
    ft->get_scanblk_SCMD(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCMD);

void scanblk_set_SCMD(struct scanblk_SCMD_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCMD == NULL);
    ft->set_scanblk_SCMD(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCMD);

void scanblk_set_SCMD_isr(struct scanblk_SCMD_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCMD_isr == NULL);
    ft->set_scanblk_SCMD_isr(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCMD_isr);

void scanblk_get_SSTAT(struct scanblk_SSTAT_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SSTAT == NULL);
    ft->get_scanblk_SSTAT(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SSTAT);

void scanblk_set_SIACK(struct scanblk_irqs *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SIACK == NULL);
    ft->set_scanblk_SIACK(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SIACK);

void scanblk_get_SCANX(struct scanblk_SCANX_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCANX == NULL);
    ft->get_scanblk_SCANX(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCANX);

void scanblk_set_SCANX(struct scanblk_SCANX_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCANX == NULL);
    ft->set_scanblk_SCANX(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCANX);

void scanblk_get_SCYCLE(struct scanblk_SCYCLE_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCYCLE == NULL);
    ft->get_scanblk_SCYCLE(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCYCLE);

void scanblk_set_SCYCLE(struct scanblk_SCYCLE_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCYCLE == NULL);
    ft->set_scanblk_SCYCLE(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCYCLE);

void scanblk_get_STCFG1(struct scanblk_STCFG1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_STCFG1 == NULL);
    ft->get_scanblk_STCFG1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_STCFG1);

void scanblk_set_STCFG1(struct scanblk_STCFG1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_STCFG1 == NULL);
    ft->set_scanblk_STCFG1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_STCFG1);

void scanblk_get_STCFG2(struct scanblk_STCFG2_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_STCFG2 == NULL);
    ft->get_scanblk_STCFG2(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_STCFG2);

void scanblk_set_STCFG2(struct scanblk_STCFG2_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_STCFG2 == NULL);
    ft->set_scanblk_STCFG2(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_STCFG2);

void scanblk_get_STCFG3(struct scanblk_STCFG3_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_STCFG3 == NULL);
    ft->get_scanblk_STCFG3(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_STCFG3);

void scanblk_set_STCFG3(struct scanblk_STCFG3_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_STCFG3 == NULL);
    ft->set_scanblk_STCFG3(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_STCFG3);

void scanblk_get_STCFG4(struct scanblk_STCFG4_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_STCFG4 == NULL);
    ft->get_scanblk_STCFG4(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_STCFG4);

void scanblk_set_STCFG4(struct scanblk_STCFG4_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_STCFG4 == NULL);
    ft->set_scanblk_STCFG4(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_STCFG4);

void scanblk_get_CCFG(struct scanblk_CCFG_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_CCFG == NULL);
    ft->get_scanblk_CCFG(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_CCFG);

void scanblk_set_CCFG(struct scanblk_CCFG_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_CCFG == NULL);
    ft->set_scanblk_CCFG(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_CCFG);

void scanblk_get_SCLK1(struct scanblk_SCLK1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCLK1 == NULL);
    ft->get_scanblk_SCLK1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCLK1);

void scanblk_set_SCLK1(struct scanblk_SCLK1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCLK1 == NULL);
    ft->set_scanblk_SCLK1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCLK1);

void scanblk_get_SCLK2(struct scanblk_SCLK2_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCLK2 == NULL);
    ft->get_scanblk_SCLK2(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCLK2);

void scanblk_set_SCLK2(struct scanblk_SCLK2_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCLK2 == NULL);
    ft->set_scanblk_SCLK2(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCLK2);

void scanblk_get_SCLK3(struct scanblk_SCLK3_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCLK3 == NULL);
    ft->get_scanblk_SCLK3(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCLK3);

void scanblk_set_SCLK3(struct scanblk_SCLK3_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCLK3 == NULL);
    ft->set_scanblk_SCLK3(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCLK3);

void scanblk_get_SCLK4(struct scanblk_SCLK4_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCLK4 == NULL);
    ft->get_scanblk_SCLK4(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCLK4);

void scanblk_set_SCLK4(struct scanblk_SCLK4_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCLK4 == NULL);
    ft->set_scanblk_SCLK4(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCLK4);

void scanblk_get_SCLK5(struct scanblk_SCLK5_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCLK5 == NULL);
    ft->get_scanblk_SCLK5(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCLK5);

void scanblk_set_SCLK5(struct scanblk_SCLK5_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCLK5 == NULL);
    ft->set_scanblk_SCLK5(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCLK5);

void scanblk_get_SCLK6(struct scanblk_SCLK6_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_SCLK6 == NULL);
    ft->get_scanblk_SCLK6(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_SCLK6);

void scanblk_set_SCLK6(struct scanblk_SCLK6_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_SCLK6 == NULL);
    ft->set_scanblk_SCLK6(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_SCLK6);

void scanblk_get_ACLK1(struct scanblk_ACLK1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_ACLK1 == NULL);
    ft->get_scanblk_ACLK1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_ACLK1);

void scanblk_set_ACLK1(struct scanblk_ACLK1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_ACLK1 == NULL);
    ft->set_scanblk_ACLK1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_ACLK1);

void scanblk_get_ACLK2(struct scanblk_ACLK2_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_ACLK2 == NULL);
    ft->get_scanblk_ACLK2(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_ACLK2);

void scanblk_set_ACLK2(struct scanblk_ACLK2_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_ACLK2 == NULL);
    ft->set_scanblk_ACLK2(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_ACLK2);

void scanblk_get_ACLK3(struct scanblk_ACLK3_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_ACLK3 == NULL);
    ft->get_scanblk_ACLK3(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_ACLK3);

void scanblk_set_ACLK3(struct scanblk_ACLK3_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_ACLK3 == NULL);
    ft->set_scanblk_ACLK3(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_ACLK3);

void scanblk_get_ACLK6(struct scanblk_ACLK6_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_ACLK6 == NULL);
    ft->get_scanblk_ACLK6(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_ACLK6);

void scanblk_set_ACLK6(struct scanblk_ACLK6_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_ACLK6 == NULL);
    ft->set_scanblk_ACLK6(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_ACLK6);

void scanblk_get_ACLK4(struct scanblk_ACLK4_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_ACLK4 == NULL);
    ft->get_scanblk_ACLK4(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_ACLK4);

void scanblk_set_ACLK4(struct scanblk_ACLK4_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_ACLK4 == NULL);
    ft->set_scanblk_ACLK4(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_ACLK4);

void scanblk_get_ACLK5(struct scanblk_ACLK5_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_ACLK5 == NULL);
    ft->get_scanblk_ACLK5(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_ACLK5);

void scanblk_set_ACLK5(struct scanblk_ACLK5_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_ACLK5 == NULL);
    ft->set_scanblk_ACLK5(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_ACLK5);

void scanblk_get_LDATA10(struct scanblk_LDATA10_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LDATA10 == NULL);
    ft->get_scanblk_LDATA10(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LDATA10);

void scanblk_set_LDATA10(struct scanblk_LDATA10_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LDATA10 == NULL);
    ft->set_scanblk_LDATA10(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LDATA10);

void scanblk_get_LDATA11(struct scanblk_LDATA11_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LDATA11 == NULL);
    ft->get_scanblk_LDATA11(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LDATA11);

void scanblk_set_LDATA11(struct scanblk_LDATA11_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LDATA11 == NULL);
    ft->set_scanblk_LDATA11(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LDATA11);

void scanblk_get_LDATA20(struct scanblk_LDATA20_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LDATA20 == NULL);
    ft->get_scanblk_LDATA20(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LDATA20);

void scanblk_set_LDATA20(struct scanblk_LDATA20_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LDATA20 == NULL);
    ft->set_scanblk_LDATA20(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LDATA20);

void scanblk_get_LDATA21(struct scanblk_LDATA21_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LDATA21 == NULL);
    ft->get_scanblk_LDATA21(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LDATA21);

void scanblk_set_LDATA21(struct scanblk_LDATA21_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LDATA21 == NULL);
    ft->set_scanblk_LDATA21(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LDATA21);

void scanblk_get_LDATA30(struct scanblk_LDATA30_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LDATA30 == NULL);
    ft->get_scanblk_LDATA30(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LDATA30);

void scanblk_set_LDATA30(struct scanblk_LDATA30_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LDATA30 == NULL);
    ft->set_scanblk_LDATA30(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LDATA30);

void scanblk_get_LDATA31(struct scanblk_LDATA31_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LDATA31 == NULL);
    ft->get_scanblk_LDATA31(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LDATA31);

void scanblk_set_LDATA31(struct scanblk_LDATA31_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LDATA31 == NULL);
    ft->set_scanblk_LDATA31(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LDATA31);

void scanblk_get_LDATA40(struct scanblk_LDATA40_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LDATA40 == NULL);
    ft->get_scanblk_LDATA40(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LDATA40);

void scanblk_set_LDATA40(struct scanblk_LDATA40_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LDATA40 == NULL);
    ft->set_scanblk_LDATA40(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LDATA40);

void scanblk_get_LDATA41(struct scanblk_LDATA41_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LDATA41 == NULL);
    ft->get_scanblk_LDATA41(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LDATA41);

void scanblk_set_LDATA41(struct scanblk_LDATA41_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LDATA41 == NULL);
    ft->set_scanblk_LDATA41(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LDATA41);

void scanblk_get_LDATA50(struct scanblk_LDATA50_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LDATA50 == NULL);
    ft->get_scanblk_LDATA50(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LDATA50);

void scanblk_set_LDATA50(struct scanblk_LDATA50_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LDATA50 == NULL);
    ft->set_scanblk_LDATA50(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LDATA50);

void scanblk_get_LDATA51(struct scanblk_LDATA51_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LDATA51 == NULL);
    ft->get_scanblk_LDATA51(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LDATA51);

void scanblk_set_LDATA51(struct scanblk_LDATA51_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LDATA51 == NULL);
    ft->set_scanblk_LDATA51(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LDATA51);

void scanblk_get_LDATA60(struct scanblk_LDATA60_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LDATA60 == NULL);
    ft->get_scanblk_LDATA60(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LDATA60);

void scanblk_set_LDATA60(struct scanblk_LDATA60_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LDATA60 == NULL);
    ft->set_scanblk_LDATA60(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LDATA60);

void scanblk_get_LDATA61(struct scanblk_LDATA61_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LDATA61 == NULL);
    ft->get_scanblk_LDATA61(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LDATA61);

void scanblk_set_LDATA61(struct scanblk_LDATA61_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LDATA61 == NULL);
    ft->set_scanblk_LDATA61(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LDATA61);

void scanblk_get_PSEQ1(struct scanblk_PSEQ1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_PSEQ1 == NULL);
    ft->get_scanblk_PSEQ1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_PSEQ1);

void scanblk_set_PSEQ1(struct scanblk_PSEQ1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_PSEQ1 == NULL);
    ft->set_scanblk_PSEQ1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_PSEQ1);

void scanblk_get_PSEQ2(struct scanblk_PSEQ2_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_PSEQ2 == NULL);
    ft->get_scanblk_PSEQ2(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_PSEQ2);

void scanblk_set_PSEQ2(struct scanblk_PSEQ2_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_PSEQ2 == NULL);
    ft->set_scanblk_PSEQ2(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_PSEQ2);

void scanblk_get_BPWM(struct scanblk_BPWM_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_BPWM == NULL);
    ft->get_scanblk_BPWM(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_BPWM);

void scanblk_set_BPWM(struct scanblk_BPWM_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_BPWM == NULL);
    ft->set_scanblk_BPWM(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_BPWM);

void scanblk_get_MCFG(struct scanblk_MCFG_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_MCFG == NULL);
    ft->get_scanblk_MCFG(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_MCFG);

void scanblk_set_MCFG(struct scanblk_MCFG_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_MCFG == NULL);
    ft->set_scanblk_MCFG(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_MCFG);

void scanblk_get_MOTORSYNCMIN(struct scanblk_MOTORSYNCMIN_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_MOTORSYNCMIN == NULL);
    ft->get_scanblk_MOTORSYNCMIN(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_MOTORSYNCMIN);

void scanblk_set_MOTORSYNCMIN(struct scanblk_MOTORSYNCMIN_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_MOTORSYNCMIN == NULL);
    ft->set_scanblk_MOTORSYNCMIN(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_MOTORSYNCMIN);

void scanblk_get_AFEPC(struct scanblk_AFEPC_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_AFEPC == NULL);
    ft->get_scanblk_AFEPC(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_AFEPC);

void scanblk_set_AFEPC(struct scanblk_AFEPC_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_AFEPC == NULL);
    ft->set_scanblk_AFEPC(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_AFEPC);

void scanblk_get_CFGARB(struct scanblk_CFGARB_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_CFGARB == NULL);
    ft->get_scanblk_CFGARB(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_CFGARB);

void scanblk_set_CFGARB(struct scanblk_CFGARB_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_CFGARB == NULL);
    ft->set_scanblk_CFGARB(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_CFGARB);

void scanblk_get_LED00(struct scanblk_LED00_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LED00 == NULL);
    ft->get_scanblk_LED00(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LED00);

void scanblk_set_LED00(struct scanblk_LED00_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LED00 == NULL);
    ft->set_scanblk_LED00(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LED00);

void scanblk_get_LED01(struct scanblk_LED01_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LED01 == NULL);
    ft->get_scanblk_LED01(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LED01);

void scanblk_set_LED01(struct scanblk_LED01_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LED01 == NULL);
    ft->set_scanblk_LED01(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LED01);

void scanblk_get_LED10(struct scanblk_LED10_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LED10 == NULL);
    ft->get_scanblk_LED10(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LED10);

void scanblk_set_LED10(struct scanblk_LED10_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LED10 == NULL);
    ft->set_scanblk_LED10(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LED10);

void scanblk_get_LED11(struct scanblk_LED11_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LED11 == NULL);
    ft->get_scanblk_LED11(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LED11);

void scanblk_set_LED11(struct scanblk_LED11_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LED11 == NULL);
    ft->set_scanblk_LED11(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LED11);

void scanblk_get_LED20(struct scanblk_LED20_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LED20 == NULL);
    ft->get_scanblk_LED20(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LED20);

void scanblk_set_LED20(struct scanblk_LED20_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LED20 == NULL);
    ft->set_scanblk_LED20(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LED20);

void scanblk_get_LED21(struct scanblk_LED21_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LED21 == NULL);
    ft->get_scanblk_LED21(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LED21);

void scanblk_set_LED21(struct scanblk_LED21_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LED21 == NULL);
    ft->set_scanblk_LED21(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LED21);

void scanblk_get_LPWMCONFIG0(struct scanblk_LPWMCONFIG0_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LPWMCONFIG0 == NULL);
    ft->get_scanblk_LPWMCONFIG0(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LPWMCONFIG0);

void scanblk_set_LPWMCONFIG0(struct scanblk_LPWMCONFIG0_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LPWMCONFIG0 == NULL);
    ft->set_scanblk_LPWMCONFIG0(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LPWMCONFIG0);

void scanblk_get_LPWMCONFIG1(struct scanblk_LPWMCONFIG1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LPWMCONFIG1 == NULL);
    ft->get_scanblk_LPWMCONFIG1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LPWMCONFIG1);

void scanblk_set_LPWMCONFIG1(struct scanblk_LPWMCONFIG1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LPWMCONFIG1 == NULL);
    ft->set_scanblk_LPWMCONFIG1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LPWMCONFIG1);

void scanblk_get_LPWM00(struct scanblk_LPWM00_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LPWM00 == NULL);
    ft->get_scanblk_LPWM00(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LPWM00);

void scanblk_set_LPWM00(struct scanblk_LPWM00_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LPWM00 == NULL);
    ft->set_scanblk_LPWM00(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LPWM00);

void scanblk_get_LPWM01(struct scanblk_LPWM01_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LPWM01 == NULL);
    ft->get_scanblk_LPWM01(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LPWM01);

void scanblk_set_LPWM01(struct scanblk_LPWM01_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LPWM01 == NULL);
    ft->set_scanblk_LPWM01(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LPWM01);

void scanblk_get_LPWM10(struct scanblk_LPWM10_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LPWM10 == NULL);
    ft->get_scanblk_LPWM10(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LPWM10);

void scanblk_set_LPWM10(struct scanblk_LPWM10_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LPWM10 == NULL);
    ft->set_scanblk_LPWM10(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LPWM10);

void scanblk_get_LPWM11(struct scanblk_LPWM11_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LPWM11 == NULL);
    ft->get_scanblk_LPWM11(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LPWM11);

void scanblk_set_LPWM11(struct scanblk_LPWM11_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LPWM11 == NULL);
    ft->set_scanblk_LPWM11(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LPWM11);

void scanblk_get_LPWM20(struct scanblk_LPWM20_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LPWM20 == NULL);
    ft->get_scanblk_LPWM20(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LPWM20);

void scanblk_set_LPWM20(struct scanblk_LPWM20_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LPWM20 == NULL);
    ft->set_scanblk_LPWM20(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LPWM20);

void scanblk_get_LPWM21(struct scanblk_LPWM21_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_LPWM21 == NULL);
    ft->get_scanblk_LPWM21(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_LPWM21);

void scanblk_set_LPWM21(struct scanblk_LPWM21_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_LPWM21 == NULL);
    ft->set_scanblk_LPWM21(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_LPWM21);

void scanblk_get_EXCFG(struct scanblk_EXCFG_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_EXCFG == NULL);
    ft->get_scanblk_EXCFG(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_EXCFG);

void scanblk_set_EXCFG(struct scanblk_EXCFG_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_EXCFG == NULL);
    ft->set_scanblk_EXCFG(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_EXCFG);

void scanblk_get_OFIE(struct scanblk_OFIE_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_OFIE == NULL);
    ft->get_scanblk_OFIE(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_OFIE);

void scanblk_set_OFIE(struct scanblk_OFIE_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_OFIE == NULL);
    ft->set_scanblk_OFIE(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_OFIE);

void scanblk_get_OFIP(struct scanblk_OFIP_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_OFIP == NULL);
    ft->get_scanblk_OFIP(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_OFIP);

void scanblk_set_OFIA(struct scanblk_OFIA_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_OFIA == NULL);
    ft->set_scanblk_OFIA(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_OFIA);

void scanblk_set_OFIF(struct scanblk_OFIF_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->set_scanblk_OFIF == NULL);
    ft->set_scanblk_OFIF(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_set_OFIF);

void scanblk_get_REV0(struct scanblk_REV0_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_REV0 == NULL);
    ft->get_scanblk_REV0(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_REV0);

void scanblk_get_REV1(struct scanblk_REV1_cfg *cfg)
{
    SCANBLK_RETRIEVE_handle_ft;

    BUG_ON(ft->get_scanblk_REV1 == NULL);
    ft->get_scanblk_REV1(scanblk_handle, cfg);
}
EXPORT_SYMBOL(scanblk_get_REV1);

