#!/usr/bin/python
#
# **********************************************************************************
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright (c) 2014, Marvell International Ltd.
#
# Alternatively, this software may be distributed under the terms of the GNU
# General Public License Version 2, and any use shall comply with the terms and
# conditions of the GPL.  A copy of the GPL is available at
# http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
#
# THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
# IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
# ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
# this warranty disclaimer.
# ************************************************************************************



# Write out the file header
def write_header(f):
    f.write("/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/

\n");
    f.write("\n");
    f.write("#ifndef SCANPLAT_SCCSC_LUTS_H\n");
    f.write("#define SCANPLAT_SCCSC_LUTS_H\n");
    f.write("\n");
    f.write("\n// **** Array color order is R G B ****\n\n");
    f.write("\n");
    return

# Write out the file footer
def write_footer(f):
    f.write("\n");
    f.write("#endif    // SCANPLAT_SCCSC_LUTS_H\n"); 
    f.write("\n");
    return


# 50 percent LUT taken from PIP code
def write_50_percent_lut(f):
    f.write("\n");
    f.write("uint32_t scanplat_sccsc_lut_50[] =\n");
    f.write("{\n");

    entries = 0

    for i in range(17):
        for j in range(17):
            for k in range(17):
                red = i / 16.0
                green = j / 16.0
                blue = k / 16.0
            
                rval = int(red*1023.0)
                gval = int(green*1023.0)
                bval = int(blue*1023.0)

                out32_1 = 0xffffffff & ((rval<<20) |
                                        (gval<<10) |
                                        (bval<<0))

                out_val = "    0x%08x, // R 0x%03x, G 0x%03x, B 0x%03x (%d)\n" % (out32_1, rval, gval, bval, entries)
                f.write(out_val)

                entries = entries + 1

    f.write("}; // scanplat_sccsc_lut_50\n");
    f.write("\n");
    return

# Identity LUT from Doug
def write_identity_lut(f):
    f.write("\n");
    f.write("uint32_t scanplat_sccsc_lut_identity[] =\n");
    f.write("{\n");

    entries = 0

    for ch0 in range(17):
        for ch1 in range(17):
            for ch2 in range(17):

                if ch0 > 15:
                    val_0 = 1023
                else:
                    val_0 = ch0 << 6

                if ch1 > 15:
                    val_1 = 1023
                else:
                    val_1 = ch1 << 6

                if ch2 > 15:
                    val_2 = 1023
                else:
                    val_2 = ch2 << 6

                out32_1 = ((val_0<<20) |
                           (val_1<<10) |
                           (val_2<<0))

                out_val = "    0x%08x, // CH0 0x%03x, CH1 0x%03x, CH2 0x%03x (%d)\n" % (out32_1, val_0, val_1, val_2, entries)
                f.write(out_val)

                entries = entries + 1

    f.write("}; // scanplat_sccsc_lut_identity\n");
    f.write("\n");
    return

def write_inverse_lut(f):
    f.write("\n");
    f.write("uint32_t scanplat_sccsc_lut_inverse[] =\n");
    f.write("{\n");

    entries = 0

    for ch0 in range(17):
        for ch1 in range(17):
            for ch2 in range(17):

                if ch0 < 1:
                    val_0 = 1023
                else:
                    val_0 = 1024 - (ch0 << 6)

                if ch1 < 1:
                    val_1 = 1023
                else:
                    val_1 = 1024 - (ch1 << 6)

                if ch2 < 1:
                    val_2 = 1023
                else:
                    val_2 = 1024 - (ch2 << 6)

                out32_1 = ((val_0<<20) |
                           (val_1<<10) |
                           (val_2<<0))

                out_val = "    0x%08x, // CH0 0x%03x, CH1 0x%03x, CH2 0x%03x (%d)\n" % (out32_1, val_0, val_1, val_2, entries)
                f.write(out_val)

                entries = entries + 1

    f.write("}; // scanplat_sccsc_lut_inverse\n");
    f.write("\n");
    return

# Test pattern LUT
def write_test_pattern_percent_lut(f):
    f.write("\n");
    f.write("uint32_t scanplat_sccsc_lut_test[] =\n");
    f.write("{\n");

    entries = 0

    for i in range(17):
        for j in range(17):
            for k in range(17):
                out_val = "    0x%08x, // Test entry %d\n" % (entries, entries)
                f.write(out_val)

                entries = entries + 1

    f.write("}; // scanplat_sccsc_lut_test\n");
    f.write("\n");
    return


# Main function
def main():
    # Open the file to write to
    fout = open("scanplat_sccsc_luts.h", "wb")
    
    write_header(fout)

    #write_50_percent_lut(fout)
    write_identity_lut(fout)
    write_inverse_lut(fout)
    #write_test_pattern_percent_lut(fout)

    write_footer(fout)

    fout.close()
    return

if __name__ == '__main__':
    main()

