/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _POGO_DMA_IF_H_
#define _POGO_DMA_IF_H_


// interface exported by the pogo_dma.c file upwards

typedef struct pogoDeviceHandle
{
    struct pie_pogo_dma_function_struct *fcn_tbl;
    piePogoData *device_data;
}pogoDeviceHandle;

int pogo_dma_init(void);
void pogo_dma_exit(void);

/////////////////////////////////////////////////////////////////////////////
// function tables passed to pie.c
struct pie_pogo_dma_function_struct
{
    void (*pie_reset) (piePogoData *pogo_object);
    void (*pie_configure) (piePogoData *pogo_object, struct pie_handle_t *pie_handle);
    void (*pie_get_current) (piePogoData *pogo_object, struct pie_handle_t *pie_handle);
    int  (*pie_revcheck) (piePogoData *pogo_object, struct pie_handle_t *pie_handle);

    void (*pogo_dma_dump_all_regs) (piePogoData *pogo_object);

    void (*handle_pogo_odma_irqs) (piePogoData *pogo_object);
    void (*handle_pogo_idma_irqs) (piePogoData *pogo_object);
    void (*clear_pogo_odma_irqs) (piePogoData *pogo_object);
    void (*clear_pogo_idma_irqs) (piePogoData *pogo_object);

    bool (*idma_idle) (piePogoData *pogo_object, uint8_t channum);
    bool (*odma_idle) (piePogoData *pogo_object);
    bool (*idma_enabled) (piePogoData *pogo_object, uint8_t channum);
    bool (*odma_enabled) (piePogoData *pogo_object);
    void (*start_pie_pogo_idma) (piePogoData *pogo_object, dma_addr_t phys_desc,
                                 uint8_t channum);
    void (*start_pie_pogo_odma) (piePogoData *pogo_object, dma_addr_t phys_desc);
    void (*start_pie_pogo_ot_idma) (piePogoData *pogo_object, dma_addr_t phys_desc);
    void (*start_pie_pogo_ot_odma) (piePogoData *pogo_object, dma_addr_t phys_desc);

    void (*pie_get_pogo_sizes_array) (uint32_t *subblock_array, 
                                      void *pogo_object);
    
};


#endif
