/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _POGO_DMA_DRIVER_H_
#define _POGO_DMA_DRIVER_H_

// interface for the pogo_dma.c file, and all of it's subbordinate modules
// (the pogo dma subblocks)

#define ALL_PIE_POGO_IDMA_CHANNELS -1 // choose all channels - whether we have 1, 3, or 255, choose all

// Since there are multiple instances of pogo_idma_udma/core, the
// "generic" block names start the index into the array area
// (leaving room for 

enum pogo_subblocks {pogoizer, depogoizer, pogo_odma_udma, pogo_odma_core,
                     otpogoizer, otdepogoizer, pogo_ot_odma_core, pogo_ot_odma_udma,
                     pogo_ot_idma_core, pogo_ot_idma_udma,
                     pogo_idma_udma,
                     pogo_idma_core=pogo_idma_udma+NUM_PIE_POGO_IDMA_CHANNELS,
                     max_pogo_subblocks=pogo_idma_core+NUM_PIE_POGO_IDMA_CHANNELS};
                     

// each subblock will register with pogo_dma.c with these
void register_pogo_subblock(enum pogo_subblocks subblock, void *pogo_subblock_data, int instance);
void *unregister_pogo_subblock(enum pogo_subblocks subblock, int instance);



#endif
