/*
 ***************************************************************************************
 * (c) Copyright 2013 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _POGO_DMA_H_
#define _POGO_DMA_H_

// Private include file for pogo_dma.c



// private data from the idma subblocks - opaque to us
typedef struct piePogoIDMAData piePogoIDMAData;
// private data from the odma subblocks
typedef struct piePogoODMAData piePogoODMAData;
// private data from the pogoizer subblock
typedef struct piePogoizerData piePogoizerData;
// private data from the depogoizer subblock
typedef struct pieDepogoizerData pieDepogoizerData;

// private data from the OT idma subblocks
typedef struct piePogoOTIDMAData piePogoOTIDMAData;
// private data from the OT odma subblocks
typedef struct piePogoOTODMAData piePogoOTODMAData;
// private data from the OT pogoizer subblocks
typedef struct pieOTPogoizerData pieOTPogoizerData;
// private data from the OT depogoizer subblocks
typedef struct pieOTDepogoizerData pieOTDepogoizerData;


// pogoDeviceHandle is the pogo object kept by pie.c at registration type
// which contains the function struct and opaque piePogoData

struct pogo_dma_data_field
{
    int num_idma_instances;
    void *priv_data[max_pogo_subblocks]; // many kinds of device data 
};

// our "subblock's" private data - opaque to everyone else
// This is contained in the pogoDeviceHandle, which 
// pie.c returns to us with a call to get_pogo_device
// pogo_dma_data_field  contains the handles given to us
// by the lo level pogo subblocks
typedef struct pogo_dma_data_field piePogoData;

#endif
