/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIE_POGO_OTODMA_IF_H_
#define _PIE_POGO_OTODMA_IF_H_

// interface exported upwards

/////////////////////////////////////////////////////////////////////////////
// structure passed upwards - device_data will be opaque
/////////////////////////////////////////////////////////////////////////////
typedef struct piePogoOTODMAUDMADeviceHandle
{
    struct pie_pogo_otodma_udma_function_struct *fcn_tbl;
    piePogoOTODMAData *device_data;
} piePogoOTODMAUDMADeviceHandle;

typedef struct piePogoOTODMACoreDeviceHandle
{
    struct pie_pogo_otodma_core_function_struct *fcn_tbl;
    piePogoOTODMAData *device_data;
} piePogoOTODMACoreDeviceHandle;


/////////////////////////////////////////////////////////////////////////////
// function table
/////////////////////////////////////////////////////////////////////////////

// function tables for the pogo subblocks
struct pie_pogo_otodma_udma_function_struct
{
    void (*pie_reset) (piePogoOTODMAData *device_data);
    void (*pie_configure) (piePogoOTODMAData *device_data, struct pie_handle_t *pie_handle);
    void (*pie_get_current) (piePogoOTODMAData *device_data, struct pie_handle_t *pie_handle);
    int  (*pie_revcheck) (piePogoOTODMAData *device_data, struct pie_handle_t *pie_handle);

    void (*dump_pogo_otodma_udma_regs) (piePogoOTODMAData *device_data);

    // called by pie common for handling interrupts
    void (*handle_pogo_otodma_udma_irqs) (piePogoOTODMAData *device_data);
    void (*clear_pogo_otodma_udma_irqs) (piePogoOTODMAData *device_data,
                                       struct odma_interrupt_info *irqstruct);
    // called by dma code
    void (*start_pogo_otodma_udma) (piePogoOTODMAData *device_data, uint32_t *phys_desc);    
};

struct pie_pogo_otodma_core_function_struct
{
    void (*pie_reset) (piePogoOTODMAData *device_data);
    void (*pie_configure) (piePogoOTODMAData *device_data, struct pie_handle_t *pie_handle);
    void (*pie_get_current) (piePogoOTODMAData *device_data, struct pie_handle_t *pie_handle);
    int  (*pie_revcheck) (piePogoOTODMAData *device_data, struct pie_handle_t *pie_handle);

    void (*dump_pogo_otodma_core_regs) (piePogoOTODMAData *device_data);

    // called by pie common for handling interrupts
    void (*handle_pogo_otodma_core_irqs) (piePogoOTODMAData *device_data);
    void (*clear_pogo_otodma_core_irqs) (piePogoOTODMAData *device_data,
                                         struct odma_interrupt_info *irqstruct);
};


#endif
