/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIE_POGO_IDMA_IF_H_
#define _PIE_POGO_IDMA_IF_H_

// interface exported upwards

/////////////////////////////////////////////////////////////////////////////
// structure passed upwards - device_data will be opaque
/////////////////////////////////////////////////////////////////////////////
typedef struct piePogoIDMAUDMADeviceHandle
{
    struct pie_pogo_idma_udma_function_struct *fcn_tbl;
    piePogoIDMAData *device_data;
} piePogoIDMAUDMADeviceHandle;

typedef struct piePogoIDMACoreDeviceHandle
{
    struct pie_pogo_idma_core_function_struct *fcn_tbl;
    piePogoIDMAData *device_data;
} piePogoIDMACoreDeviceHandle;

/////////////////////////////////////////////////////////////////////////////
// function table
/////////////////////////////////////////////////////////////////////////////
struct pie_pogo_idma_udma_function_struct
{
    void (*pie_reset) (piePogoIDMAData *device_data);
    void (*pie_configure) (piePogoIDMAData *device_data, struct pie_handle_t *pie_handle,
                       uint8_t idma_num);
    void (*pie_get_current) (piePogoIDMAData *device_data, struct pie_handle_t *pie_handle,
                         uint8_t idma_num);
    int  (*pie_revcheck) (piePogoIDMAData *device_data, struct pie_handle_t *pie_handle,
                          uint8_t idma_num);

    void (*dump_pogo_idma_udma_regs) (piePogoIDMAData *device_data);

    bool (*udma_idle) (piePogoIDMAData *device_data);
    bool (*udma_enabled) (piePogoIDMAData *device_data);
    void (*handle_pogo_idma_udma_irqs) (piePogoIDMAData *device_data);
    void (*clear_pogo_idma_udma_irqs) (piePogoIDMAData *device_data,
                                       struct idma_interrupt_info *irqstruct);

    void (*start_pogo_idma_udma) (piePogoIDMAData *device_data, uint32_t *phys_desc);
};

struct pie_pogo_idma_core_function_struct
{
    void (*pie_reset) (piePogoIDMAData *device_data);
    void (*pie_configure) (piePogoIDMAData *device_data, struct pie_handle_t *pie_handle,
                       uint8_t idma_num);
    void (*pie_get_current) (piePogoIDMAData *device_data, struct pie_handle_t *pie_handle,
                         uint8_t idma_num);
    int  (*pie_revcheck) (piePogoIDMAData *device_data, struct pie_handle_t *pie_handle,
                          uint8_t idma_num);

    void (*dump_pogo_idma_core_regs) (piePogoIDMAData *device_data);    

    void (*handle_pogo_idma_core_irqs) (piePogoIDMAData *device_data);

    void (*clear_pogo_idma_core_irqs) (piePogoIDMAData *device_data,
                                       struct idma_interrupt_info *irqstruct);
};


#endif
