/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIE_IF_H_
#define _PIE_IF_H_

// interface between the pie driver and the rest of the world (upwards)
#ifndef __KERNEL__
#define dma_addr_t uint32_t
#endif

#define DMA_ENABLE 1
#define DMA_DISABLE 0

#define POGO_FMT_MONO 0
#define POGO_FMT_RGB 1
#define POGO_FMT_RGBX 2
#define POGO_FMT_XRGB 3
#define POGO_FMT_PLANAR 4
#define POGO_FMT_1CHAN_PK 6
#define POGO_FMT_1CHAN_UNPK 7

#define POGO_NOCOLORSWAP 0
#define POGO_COLORSWAP 1

#define OTPOGO_1BPP 0
#define OTPOGO_2BPP 1
#define OTPOGO_4BPP 2
#define OTPOGO_8BPP 3

#define POGO_8BPP 3
#define POGO_16BPP 4

#define PIE_RESET 1
#define PIE_NORMAL 0

#define PIE_BDE_BYPASS 1
#define PIE_BDE_ENABLE 0
#define PIE_CSC_BYPASS 1
#define PIE_CSC_ENABLE 0

#define PIE_CSC_RED_LUT 0
#define PIE_CSC_GREEN_LUT 1
#define PIE_CSC_BLUE_LUT 2

#define NUM_BDE_CHANNELS 3
#define PIE_BDE_MAX_LUT_ENTRIES 256
#define PIE_RGB2ESRGB_LUT_ENTRIES 1024

#define PIE_SCALE_BYPASS 1
#define PIE_SCALE_ENABLE 0

#define PIE_SCALE_RUP_NONE          0   /* no roundup */
#define PIE_SCALE_RUP_Y             1
#define PIE_SCALE_RUP_X             2
#define PIE_SCALE_RUP_ALL           3   /* do full rounding up */

#define PIE_LINEAR_MODE  1
#define PIE_RAPR_MODE 0
#define PIE_REPLICATE 1
#define PIE_NO_REPLICATE 0

#define PIE_NO_POGO_XSCALE 0
#define PIE_NO_POGO_YSCALE 0

#define PIE_DEPOGO_MONOCHAN0  0
#define PIE_DEPOGO_MONOCHAN_DEF  PIE_DEPOGO_MONOCHAN0


#define PIE_COLORSHIFT_CONFIG_ROUND_MODE_TRUNC  0
#define PIE_COLORSHIFT_CONFIG_ROUND_MODE_FIXED  1
#define PIE_COLORSHIFT_CONFIG_ROUND_MODE_RANDOM 2

#define PIE_COLORSHIFT_CONFIG_LINE_MODE_TWO   1
#define PIE_COLORSHIFT_CONFIG_LINE_MODE_THREE 0

#define PIE_COLORSHIFT_MMODE_LINE_BELOW 0
#define PIE_COLORSHIFT_MMODE_LINE_ABOVE 1
#define PIE_COLORSHIFT_MMODE_LINE_BOTH  2

#define PIE_DSMF_CTL_LUT_ENTRIES 16
#define PIE_DSMF_SEG_PROJ_LUT_ENTRIES 256
#define PIE_DSMF_AI_LUT_ENTRIES 64

#define PIE_TCNS_LUT_ENTRIES 1024

// PIE DMA constants
#define BUS_WIDTH_32_BIT 0
#define BUS_WIDTH_64_BIT 1
#define DMA_4_BEATS 0
#define DMA_8_BEATS 1
#define DMA_16_BEATS 2
#define DMA_WIDTH_32 5
#define DMA_WIDTH_16 4
#define DMA_ENABLE 1
#define DMA_DISABLE 0
#define CORE_BURST_SIZE_16 0
#define CORE_BURST_SIZE_32 1
#define CORE_BURST_SIZE_48 2
#define CORE_BURST_SIZE_64 3

// maximum number of rows PIE read DMA allows (hardware limit) 
#define PIE_RDMA_MAX_ROWS  36 
// maximum number of rows PIE Write DMA allows (hardware limit)
#define PIE_WDMA_MAX_ROWS 16 

// CSTATS (Contone Statistics--histograms) 
// number of uint32_t elements in the SRAM 'RAM[012]' fields 
#define PIE_CSTATS_SRAM_SIZE          128

// number of uint32_t elements in the SRAM 'RAM3' field
#define PIE_CSTATS_NONWHITE_SRAM_SIZE  32

// CTSATS histogram type
#define PIE_CSTATS_HISTOGRAM_DISABLED   0
#define PIE_CSTATS_HISTOGRAM_3PLANE_1D  1
#define PIE_CSTATS_HISTOGRAM_PLANE1_1D_PLANE23_2D 2  // Plane1 as a 1-D and Planes 2-3 as a 2-D 
#define PIE_CSTATS_HISTOGRAM_3PLANE_2D  3  // 3 planes as a 2-D

// CTSATS input mux
#define PIE_CSTATS_INPUT_MUX_BDE        0  // output of BDE (RGB)
#define PIE_CSTATS_INPUT_MUX_RGB2YCC    1  // output of esRGB2YCC (usually YCC)
#define PIE_CSTATS_INPUT_MUX_WDMA       2  // input to PIE WDMA (RGB or YCC; usually RGB)

#define PIE_CSTATS_CFG_MONO             1
#define PIE_CSTATS_CFG_COLOR            0

// The SC CSC iLUT tables have 17^3 (4913) entries.  Internally the PIE HW iLUT
// address space is not contiguous (it has holes), but the sub-block driver
// hides those details. Each entry is 32-bits (4 bytes).
#define PIE_SCCSC_ILUT_ENTRIES 4913
#define PIE_SCCSC_ILUT_SIZE    (PIE_SCCSC_ILUT_ENTRIES * 4)

#define PIE_SCCSC_BM_DISABLE   0    // Black Mapping
#define PIE_SCCSC_BM_RGB       1
#define PIE_SCCSC_BM_YCC_FS    2
#define PIE_SCCSC_BM_YCC       3

// PIE NG Adjust
#define PIE_NGADJUST_LUT_ENTRIES 1024

// pie interrupt structures
struct pie_common_ints
{
    bool distort;
    bool ihi_16x8_short;
    bool ihi_16x8_tall;
    bool ihi_3x3_short;
    bool ihi_3x3_tall;
    bool pack_mono_wdma;
    bool dis_map;
    bool ac_corr_rdma2;
    bool ac_corr_rdma1;
    bool ac_corr_rdma0;
    bool ac_data_rdma2;
    bool ac_data_rdma1;
    bool ac_data_rdma0;
    bool dsmf_short;
    bool dsmf_tall;
    bool otmarb;
    bool ot_wdma;
    bool wdma;
    bool ot_rdma;
    bool rdma2;
    bool rdma1;
    bool rdma0;
    // NOTE: this is for debug only - use the fields in the structure to see if a bit is set!!!!
    uint32_t int_array;  
};

struct odma_interrupt_info
{
    bool EndOfStrip;  
    bool Desc;
    bool ClearComplete;
    bool Own;
    bool LengthErr;
    bool OutOfRangeErr;
    bool RRespErr;
    bool BRespErr;
};

struct idma_interrupt_info
{
    int instance;  // which idma instance returned this info
    bool EndOfStrip;  
    bool Desc;
    bool ClearComplete;
    bool Own;
    bool LengthErr;
    bool OutOfRangeErr;
    bool RRespErr;
    bool BRespErr;
    unsigned int highest_line[3];
    unsigned int highest_line_experimental[3];
};

struct otmarb_interrupt_info
{
    int DTmismatchErr;
};

// pie.c exported functions

// DMA function calls only!!  not a general public API
void pie_enable_pie_common_irq(struct pie_common_ints *irqstruct);
void pie_disable_pie_common_irq(struct pie_common_ints *irqstruct);
bool pie_odma_is_enabled(void);
bool pie_idma_is_enabled(uint8_t channel_num);
bool pie_idma_is_idle(uint8_t channel_num);
bool pie_odma_is_idle(void);
void pie_start_pogo_input_dma(dma_addr_t phys_desc, uint8_t channum);
void pie_start_pogo_output_dma(dma_addr_t phys_desc);
void pie_start_distort_input_dma(dma_addr_t phys_desc, uint8_t channum);
void pie_start_distort(struct pie_handle_t *pie_handle);
void pie_start_pogo_ot_idma(dma_addr_t phys_desc);
void pie_start_pogo_ot_odma(dma_addr_t phys_desc);
// DMA function calls only!!  do we remove from this file and put into dma_if.h?


// START OF PUBLIC API FUNCTIONS
void pie_do_reset(void);
void pie_do_configure(struct pie_handle_t *pie_handle);
void pie_do_get_current(struct pie_handle_t *pie_handle);
int pie_do_revcheck(struct pie_handle_t *pie_handle);

void pie_do_clear_all_irqs(void);
void pie_do_free_handle(struct pie_handle_t *pie_handle);

// PIE SC CSC APIs that interface to SRAM (not register based), so
// they don't look like the typical interfaces.
void pie_sccsc_load_ilut(const uint32_t lut_data[], uint32_t lut_entries);
int  pie_sccsc_dbg_verify_ilut(void);

// dump functions - debug
void pie_dump_common_regs(void);
void pie_dump_pogo_regs(void);
void pie_xy_scale_dump(void);
void pie_xy_c_scale_dump(void);
void pie_colorshift_dump(void);
void pie_rgb2ycc_dump(void);
void pie_ycc2rgb_dump(void);
void pie_rgb2esrgb_dump(void);
void pie_rgb2esrgb_dump_luts(void);
void pie_dsmf_dump(void);
void pie_tcns_dump(void);
void pie_tcns_dump_luts(void);
void pie_sccsc_dump(void);
void pie_sccsc_dump_ilut(void);
void pie_cstats_dump(void);
void pie_cstats_dump_ram(void);
void pie_ngadjust_dump(void);
void pie_ngadjust_dump_lut(void);
void pie_decim_dump(void);
void pie_clippad_dump(void);
void pie_bde_dump(void);
void pie_bde_lut_dump(void);

void pie_dump(void);
int pie_get_subblock_sizes_array(uint32_t **subblock_parm);

#endif
