/*
 ***************************************************************************************
 * (c) Copyright 2013 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIE_HANDLE_H_
#define _PIE_HANDLE_H_

// note - this is a local constant that needs to be kept in sync with
// NUM_BDE_CHANNELS in pie_if.h
#define NUM_PIE_BDE_CHANNELS 3  
// NOTE - THIS CONSTANT MUST BE CHANGED FOR ASICS WITH DIFFERENT # CHANNELS
#define NUM_PIE_POGO_IDMA_CHANNELS 3
#define NUM_PIE_COMMON_DEBUG_REGS 4

/////////////////////////////////////////////////////////////////
// The definition of the structure for the PIE block
// This contains every register in PIE.
// The upper level code only sees this as a handle - they should
// never be able to include this file and peek inside (data hiding)
/////////////////////////////////////////////////////////////////

// don't require C source files to include all of the reg defs
// (certain instantiation-independent dmas are used outside of PIE_regheaders.h)
typedef struct POGO_IDMA_UDMA_REGS_s POGO_IDMA_UDMA_REGS_t;

typedef struct POGO_IDMA_CORE_REGS_s POGO_IDMA_CORE_REGS_t;

// the whole PIE block structure
struct pie_handle_t
{
    uint32_t pie_handle_size;
    uint32_t subblock_size_table[max_subblock_val];
    // interrupt callback functions
    // add callbacks and callback data here as subblock drivers are added
    void (*pie_common_callback) (void *, void *);
    void *pie_common_callback_data;
    void (*pie_odma_udma_callback) (void *, void *);
    void *pie_odma_udma_callback_data;
    void (*pie_idma_udma_callback) (void *, void *);
    void *pie_idma_udma_callback_data;
    void (*pie_odma_core_callback) (void *, void *);
    void *pie_odma_core_callback_data;
    void (*pie_idma_core_callback) (void *, void *);
    void *pie_idma_core_callback_data;
    void (*pie_otidma_udma_callback) (void *, void *);
    void *pie_otidma_udma_callback_data;
    void (*pie_otidma_core_callback) (void *, void *);
    void *pie_otidma_core_callback_data;
    void (*pie_otodma_udma_callback) (void *, void *);
    void *pie_otodma_udma_callback_data;
    void (*pie_otodma_core_callback) (void *, void *);
    void *pie_otodma_core_callback_data;
    void (*pie_otmarb_callback) (void *, void *);
    void *pie_otmarb_callback_data;

    // each subblock here - if value is NULL, we never instantiated the subblock
    PIE_COMMON_REGS_t *pie_common;
    POGOIZER_REGS_t *pie_pogoizer;
    OTPOGOIZER_REGS_t *pie_otpogoizer;
    COLORSHIFT_REGS_t *pie_colorshift;
    LUT1D_RGB2ESRGB_REGS_t *pie_rgb2esrgb;
    SCCSC_REGS_t *pie_sccsc;
    ES2Y_REGS_t *pie_rgb2ycc;
    CSTATS_REGS_t *pie_cstats;
    OTMARB_REGS_t *pie_otmarb;
    NGADJUST_REGS_t *pie_ngadjust;
    ISTONE_REGS_t *pie_istone;
    TCNSENSE_REGS_t *pie_tcns;
    DENOISE_REGS_t *pie_denoise;
    DSMF_REGS_t *pie_dsmf;
    DECIM_REGS_t *pie_decim;
    Y2ES_REGS_t *pie_ycc2rgb;
    XYSCALE_REGS_t *pie_xyscale;
    CLIPPAD_REGS_t *pie_clippad;
    DEPOGOIZER_REGS_t *pie_depogoizer;
    OTDEPOGOIZER_REGS_t *pie_otdepogoizer;
    XYCSCALE_REGS_t *pie_xy_c_scale;
    IHI_REGS_t *pie_ihi;
    IHIDEPOGOIZER_REGS_t *pie_ihi_depogoizer;
    POGO_IDMA0_POGO_IDMA_UDMA_REGS_t *pie_pogo_idma_udma[NUM_PIE_POGO_IDMA_CHANNELS];
    POGO_IDMA0_POGO_IDMA_CORE_REGS_t *pie_pogo_idma_core[NUM_PIE_POGO_IDMA_CHANNELS];
    OT_POGO_IDMA_POGO_IDMA_UDMA_REGS_t *pie_otpogo_idma_udma;
    OT_POGO_IDMA_POGO_IDMA_CORE_REGS_t *pie_otpogo_idma_core;
    POGO_ODMA_POGO_ODMA_UDMA_REGS_t *pie_pogo_odma_udma;
    POGO_ODMA_POGO_ODMA_CORE_REGS_t *pie_pogo_odma_core;
    POGO_OTODMA_POGO_ODMA_UDMA_REGS_t *pie_otpogo_odma_udma;
    POGO_OTODMA_POGO_ODMA_CORE_REGS_t *pie_otpogo_odma_core;
    DISTORT_TOP_DISTORT_REGS_t *pie_distort_top;
    DISTORT_TOP_DISTORT_MAP_REGS_t *pie_distort_top_map;
    POGO_IHI_ODMA_POGO_ODMA_UDMA_REGS_t *pie_ihi_pogo_odma_udma;
    POGO_IHI_ODMA_POGO_ODMA_CORE_REGS_t *pie_ihi_pogo_odma_core;
    DISTORT_TOP_ANTIFCOR_TOP_LUT1D_BDE0_REGS_t *pie_bde[NUM_PIE_BDE_CHANNELS];
    DISTORT_TOP_ANTIFCOR_TOP_ANTIFCOR_REGS_t *pie_distort_antifcor_top;
    DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA0_REGS_t *pie_distort_antifcor_ddma_ac_data0;
    DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA1_REGS_t *pie_distort_antifcor_ddma_ac_data1;
    DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA2_REGS_t *pie_distort_antifcor_ddma_ac_data2;
    DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_CORR0_REGS_t *pie_distort_antifcor_ddma_ac_corr0;
    DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_CORR1_REGS_t *pie_distort_antifcor_ddma_ac_corr1;
    DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_CORR2_REGS_t *pie_distort_antifcor_ddma_ac_corr2;
    // The shadow registers go here - dynamically allocated by pie_create_new_default_handle().
    // The subblock pointers will give access to these after a call to fixup_shadow_pointers().

    uint32_t pie_xyscale_partial_pixel_pos;
    uint32_t pie_xy_c_scale_partial_pixel_pos;

    uint32_t *shadow_regs;
};

#endif
