/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#include <linux/io.h>        // for ioread/write32 (pie Read/Write macros)
#include <linux/export.h>    // for EXPORT_SYMBOL
#include <linux/spinlock.h>  // for spinlock_t

#include "PIE_regheaders.h"
#include "pie_full_subblock_list.h" // needed for detailed pie_handle
#include "pie_handle.h"
#include "pie_data.h"
#include "pie_if.h"
#include "pie_driver.h"
#include "pie_dsmf.h"
#include "pie_dsmf_if.h"

#include "pie_driverlib_if.h"  // for print macros


void dump_dsmf_regs(dsmfData *device_data)
{
    print("PIE dsmf Registers\n");

    print("DSMF_Ctl=0x%X\n", dsmfRead(DSMF_Ctl));
    print("DSMF_Seg_HV_Proj=0x%X\n", dsmfRead(DSMF_Seg_HV_Proj));
    print("DSMF_Seg_Diag_Proj=0x%X\n", dsmfRead(DSMF_Seg_Diag_Proj));
    print("DSMF_Seg_Isolated=0x%X\n", dsmfRead(DSMF_Seg_Isolated));
    print("DSMF_Seg_3x3_Text=0x%X\n", dsmfRead(DSMF_Seg_3x3_Text));
    print("DSMF_Seg_3x3_Mixed=0x%X\n", dsmfRead(DSMF_Seg_3x3_Mixed));
    print("DSMF_Seg_5x5_Text=0x%X\n", dsmfRead(DSMF_Seg_5x5_Text));
    print("DSMF_Seg_5x5_Mixed=0x%X\n", dsmfRead(DSMF_Seg_5x5_Mixed));
    print("DSMF_Seg_Line=0x%X\n", dsmfRead(DSMF_Seg_Line));
    print("DSMF_Seg_Line_Diag=0x%X\n", dsmfRead(DSMF_Seg_Line_Diag));
    print("DSMF_SCR1=0x%X\n", dsmfRead(DSMF_SCR1));
    print("DSMF_SCR2=0x%X\n", dsmfRead(DSMF_SCR2));
    print("DSMF_TEL1R=0x%X\n", dsmfRead(DSMF_TEL1R));
    print("DSMF_TEL2R=0x%X\n", dsmfRead(DSMF_TEL2R));
    print("DSMF_TEL3R=0x%X\n", dsmfRead(DSMF_TEL3R));
    print("DSMF_EC_COMPARE=0x%X\n", dsmfRead(DSMF_EC_COMPARE));
    // DSMF_EC_WR is a write only register
    print("DSMF_EC_OBS=0x%X\n", dsmfRead(DSMF_EC_OBS));
    print("DSMF_ECI=0x%X\n", dsmfRead(DSMF_ECI));
    print("DSMF_YVC00_01=0x%X\n", dsmfRead(DSMF_YVC00_01));
    print("DSMF_YVC02_03=0x%X\n", dsmfRead(DSMF_YVC02_03));
    print("DSMF_YVC04_10=0x%X\n", dsmfRead(DSMF_YVC04_10));
    print("DSMF_YVC11_12=0x%X\n", dsmfRead(DSMF_YVC11_12));
    print("DSMF_YVC13_14=0x%X\n", dsmfRead(DSMF_YVC13_14));
    print("DSMF_YVC20_21=0x%X\n", dsmfRead(DSMF_YVC20_21));
    print("DSMF_YVC22_23=0x%X\n", dsmfRead(DSMF_YVC22_23));
    print("DSMF_YVC24=0x%X\n", dsmfRead(DSMF_YVC24));
    print("DSMF_YVC30_31=0x%X\n", dsmfRead(DSMF_YVC30_31));
    print("DSMF_YVC32_33=0x%X\n", dsmfRead(DSMF_YVC32_33));
    print("DSMF_YVC34_40=0x%X\n", dsmfRead(DSMF_YVC34_40));
    print("DSMF_YVC41_42=0x%X\n", dsmfRead(DSMF_YVC41_42));
    print("DSMF_YVC43_44=0x%X\n", dsmfRead(DSMF_YVC43_44));
    print("DSMF_CVC00_01=0x%X\n", dsmfRead(DSMF_CVC00_01));
    print("DSMF_CVC02_03=0x%X\n", dsmfRead(DSMF_CVC02_03));
    print("DSMF_CVC04_10=0x%X\n", dsmfRead(DSMF_CVC04_10));
    print("DSMF_CVC11_12=0x%X\n", dsmfRead(DSMF_CVC11_12));
    print("DSMF_CVC13_14=0x%X\n", dsmfRead(DSMF_CVC13_14));
    print("DSMF_CVC20_21=0x%X\n", dsmfRead(DSMF_CVC20_21));
    print("DSMF_CVC22_23=0x%X\n", dsmfRead(DSMF_CVC22_23));
    print("DSMF_CVC24=0x%X\n", dsmfRead(DSMF_CVC24));
    print("DSMF_CVC30_31=0x%X\n", dsmfRead(DSMF_CVC30_31));
    print("DSMF_CVC32_33=0x%X\n", dsmfRead(DSMF_CVC32_33));
    print("DSMF_CVC34_40=0x%X\n", dsmfRead(DSMF_CVC34_40));
    print("DSMF_CVC41_42=0x%X\n", dsmfRead(DSMF_CVC41_42));
    print("DSMF_CVC43_44=0x%X\n", dsmfRead(DSMF_CVC43_44));
    print("DSMF_FILT_MULT=0x%X\n", dsmfRead(DSMF_FILT_MULT));
    print("DSMF_FILT_SHIFT=0x%X\n", dsmfRead(DSMF_FILT_SHIFT));
    print("DSMF_YVC00_01_F1=0x%X\n", dsmfRead(DSMF_YVC00_01_F1));
    print("DSMF_YVC02_03_F1=0x%X\n", dsmfRead(DSMF_YVC02_03_F1));
    print("DSMF_YVC04_10_F1=0x%X\n", dsmfRead(DSMF_YVC04_10_F1));
    print("DSMF_YVC11_12_F1=0x%X\n", dsmfRead(DSMF_YVC11_12_F1));
    print("DSMF_YVC13_14_F1=0x%X\n", dsmfRead(DSMF_YVC13_14_F1));
    print("DSMF_YVC20_21_F1=0x%X\n", dsmfRead(DSMF_YVC20_21_F1));
    print("DSMF_YVC22_23_F1=0x%X\n", dsmfRead(DSMF_YVC22_23_F1));
    print("DSMF_YVC24_F1=0x%X\n", dsmfRead(DSMF_YVC24_F1));
    print("DSMF_YVC30_31_F1=0x%X\n", dsmfRead(DSMF_YVC30_31_F1));
    print("DSMF_YVC32_33_F1=0x%X\n", dsmfRead(DSMF_YVC32_33_F1));
    print("DSMF_YVC34_40_F1=0x%X\n", dsmfRead(DSMF_YVC34_40_F1));
    print("DSMF_YVC41_42_F1=0x%X\n", dsmfRead(DSMF_YVC41_42_F1));
    print("DSMF_YVC43_44_F1=0x%X\n", dsmfRead(DSMF_YVC43_44_F1));
    print("DSMF_CVC00_01_F1=0x%X\n", dsmfRead(DSMF_CVC00_01_F1));
    print("DSMF_CVC02_03_F1=0x%X\n", dsmfRead(DSMF_CVC02_03_F1));
    print("DSMF_CVC04_10_F1=0x%X\n", dsmfRead(DSMF_CVC04_10_F1));
    print("DSMF_CVC11_12_F1=0x%X\n", dsmfRead(DSMF_CVC11_12_F1));
    print("DSMF_CVC13_14_F1=0x%X\n", dsmfRead(DSMF_CVC13_14_F1));
    print("DSMF_CVC20_21_F1=0x%X\n", dsmfRead(DSMF_CVC20_21_F1));
    print("DSMF_CVC22_23_F1=0x%X\n", dsmfRead(DSMF_CVC22_23_F1));
    print("DSMF_CVC24_F1=0x%X\n", dsmfRead(DSMF_CVC24_F1));
    print("DSMF_CVC30_31_F1=0x%X\n", dsmfRead(DSMF_CVC30_31_F1));
    print("DSMF_CVC32_33_F1=0x%X\n", dsmfRead(DSMF_CVC32_33_F1));
    print("DSMF_CVC34_40_F1=0x%X\n", dsmfRead(DSMF_CVC34_40_F1));
    print("DSMF_CVC41_42_F1=0x%X\n", dsmfRead(DSMF_CVC41_42_F1));
    print("DSMF_CVC43_44_F1=0x%X\n", dsmfRead(DSMF_CVC43_44_F1));
    print("DSMF_FILT_MULT_F1=0x%X\n", dsmfRead(DSMF_FILT_MULT_F1));
    print("DSMF_FILT_SHIFT_F1=0x%X\n", dsmfRead(DSMF_FILT_SHIFT_F1));
    print("DSMF_YVC00_01_F2=0x%X\n", dsmfRead(DSMF_YVC00_01_F2));
    print("DSMF_YVC02_03_F2=0x%X\n", dsmfRead(DSMF_YVC02_03_F2));
    print("DSMF_YVC04_10_F2=0x%X\n", dsmfRead(DSMF_YVC04_10_F2));
    print("DSMF_YVC11_12_F2=0x%X\n", dsmfRead(DSMF_YVC11_12_F2));
    print("DSMF_YVC13_14_F2=0x%X\n", dsmfRead(DSMF_YVC13_14_F2));
    print("DSMF_YVC20_21_F2=0x%X\n", dsmfRead(DSMF_YVC20_21_F2));
    print("DSMF_YVC22_23_F2=0x%X\n", dsmfRead(DSMF_YVC22_23_F2));
    print("DSMF_YVC24_F2=0x%X\n", dsmfRead(DSMF_YVC24_F2));
    print("DSMF_YVC30_31_F2=0x%X\n", dsmfRead(DSMF_YVC30_31_F2));
    print("DSMF_YVC32_33_F2=0x%X\n", dsmfRead(DSMF_YVC32_33_F2));
    print("DSMF_YVC34_40_F2=0x%X\n", dsmfRead(DSMF_YVC34_40_F2));
    print("DSMF_YVC41_42_F2=0x%X\n", dsmfRead(DSMF_YVC41_42_F2));
    print("DSMF_YVC43_44_F2=0x%X\n", dsmfRead(DSMF_YVC43_44_F2));
    print("DSMF_CVC00_01_F2=0x%X\n", dsmfRead(DSMF_CVC00_01_F2));
    print("DSMF_CVC02_03_F2=0x%X\n", dsmfRead(DSMF_CVC02_03_F2));
    print("DSMF_CVC04_10_F2=0x%X\n", dsmfRead(DSMF_CVC04_10_F2));
    print("DSMF_CVC11_12_F2=0x%X\n", dsmfRead(DSMF_CVC11_12_F2));
    print("DSMF_CVC13_14_F2=0x%X\n", dsmfRead(DSMF_CVC13_14_F2));
    print("DSMF_CVC20_21_F2=0x%X\n", dsmfRead(DSMF_CVC20_21_F2));
    print("DSMF_CVC22_23_F2=0x%X\n", dsmfRead(DSMF_CVC22_23_F2));
    print("DSMF_CVC24_F2=0x%X\n", dsmfRead(DSMF_CVC24_F2));
    print("DSMF_CVC30_31_F2=0x%X\n", dsmfRead(DSMF_CVC30_31_F2));
    print("DSMF_CVC32_33_F2=0x%X\n", dsmfRead(DSMF_CVC32_33_F2));
    print("DSMF_CVC34_40_F2=0x%X\n", dsmfRead(DSMF_CVC34_40_F2));
    print("DSMF_CVC41_42_F2=0x%X\n", dsmfRead(DSMF_CVC41_42_F2));
    print("DSMF_CVC43_44_F2=0x%X\n", dsmfRead(DSMF_CVC43_44_F2));
    print("DSMF_FILT_MULT_F2=0x%X\n", dsmfRead(DSMF_FILT_MULT_F2));
    print("DSMF_FILT_SHIFT_F2=0x%X\n", dsmfRead(DSMF_FILT_SHIFT_F2));
    print("DSMF_YVC00_01_F3=0x%X\n", dsmfRead(DSMF_YVC00_01_F3));
    print("DSMF_YVC02_03_F3=0x%X\n", dsmfRead(DSMF_YVC02_03_F3));
    print("DSMF_YVC04_10_F3=0x%X\n", dsmfRead(DSMF_YVC04_10_F3));
    print("DSMF_YVC11_12_F3=0x%X\n", dsmfRead(DSMF_YVC11_12_F3));
    print("DSMF_YVC13_14_F3=0x%X\n", dsmfRead(DSMF_YVC13_14_F3));
    print("DSMF_YVC20_21_F3=0x%X\n", dsmfRead(DSMF_YVC20_21_F3));
    print("DSMF_YVC22_23_F3=0x%X\n", dsmfRead(DSMF_YVC22_23_F3));
    print("DSMF_YVC24_F3=0x%X\n", dsmfRead(DSMF_YVC24_F3));
    print("DSMF_YVC30_31_F3=0x%X\n", dsmfRead(DSMF_YVC30_31_F3));
    print("DSMF_YVC32_33_F3=0x%X\n", dsmfRead(DSMF_YVC32_33_F3));
    print("DSMF_YVC34_40_F3=0x%X\n", dsmfRead(DSMF_YVC34_40_F3));
    print("DSMF_YVC41_42_F3=0x%X\n", dsmfRead(DSMF_YVC41_42_F3));
    print("DSMF_YVC43_44_F3=0x%X\n", dsmfRead(DSMF_YVC43_44_F3));
    print("DSMF_CVC00_01_F3=0x%X\n", dsmfRead(DSMF_CVC00_01_F3));
    print("DSMF_CVC02_03_F3=0x%X\n", dsmfRead(DSMF_CVC02_03_F3));
    print("DSMF_CVC04_10_F3=0x%X\n", dsmfRead(DSMF_CVC04_10_F3));
    print("DSMF_CVC11_12_F3=0x%X\n", dsmfRead(DSMF_CVC11_12_F3));
    print("DSMF_CVC13_14_F3=0x%X\n", dsmfRead(DSMF_CVC13_14_F3));
    print("DSMF_CVC20_21_F3=0x%X\n", dsmfRead(DSMF_CVC20_21_F3));
    print("DSMF_CVC22_23_F3=0x%X\n", dsmfRead(DSMF_CVC22_23_F3));
    print("DSMF_CVC24_F3=0x%X\n", dsmfRead(DSMF_CVC24_F3));
    print("DSMF_CVC30_31_F3=0x%X\n", dsmfRead(DSMF_CVC30_31_F3));
    print("DSMF_CVC32_33_F3=0x%X\n", dsmfRead(DSMF_CVC32_33_F3));
    print("DSMF_CVC34_40_F3=0x%X\n", dsmfRead(DSMF_CVC34_40_F3));
    print("DSMF_CVC41_42_F3=0x%X\n", dsmfRead(DSMF_CVC41_42_F3));
    print("DSMF_CVC43_44_F3=0x%X\n", dsmfRead(DSMF_CVC43_44_F3));
    print("DSMF_FILT_MULT_F3=0x%X\n", dsmfRead(DSMF_FILT_MULT_F3));
    print("DSMF_FILT_SHIFT_F3=0x%X\n", dsmfRead(DSMF_FILT_SHIFT_F3));
    print("DSMF_AVG_MASK=0x%X\n", dsmfRead(DSMF_AVG_MASK));
    // DSMF_FILT_CTL_LUT not dumped - just doing regs
    // DSMF_SEG_PROJ_LUT not dumped - just doing regs, and it's write only
    // DSMF_AI_LUT0 not dumped - just doing regs, and it's write only
    // DSMF_AI_LUT1 not dumped - just doing regs, and it's write only    
    print("REV0=0x%X\n", dsmfRead(REV0));
    print("REV1=0x%X\n", dsmfRead(REV1));
}

static int pie_revcheck(dsmfData *device_data,
                        struct pie_handle_t *pie_handle)
{
    uint32_t rev0;
    uint32_t pieh_rev;
    
    rev0 = DSMF_REV0_MAJ_MASK_SHIFT(dsmfRead(REV0));
    pieh_rev = DSMF_REV0_MAJ_MASK_SHIFT(pie_handle->pie_dsmf->REV0);
    
    if (rev0 != pieh_rev)
    {
        error_print("%s: %s failed, rev0=%d, handle rev=%d\n",
                    __FILE__, __func__, rev0, pieh_rev);
        return -1;
    }
    else
        return 0;
}

static void pie_reset(dsmfData *device_data)
{
    uint32_t reg;

    PROTECT_REG_ACCESS;
    reg = dsmfRead(DSMF_Ctl);
    reg = DSMF_DSMF_CTL_BYPASS_ALL_REPLACE_VAL(reg, PIE_CSC_BYPASS);  // bypass to do a reset
    dsmfWrite(DSMF_Ctl, reg);
    // leaving in bypass - if someone wants this subblock, they need to
    // enable it (take out of bypass)
    UNPROTECT_REG_ACCESS;
}


static void pie_configure(dsmfData *device_data,
                          struct pie_handle_t *pie_handle)
{
    int i;
    // There is no callback to configure for dsmf

    // NOTE: to program the LUTs the CPU access bit must
    // be set first.  Then the LUTs can be written,
    // and finally, the CPU access bit will be cleared.
    
    PROTECT_REG_ACCESS;
    // set CPU access bit before programming LUTs
    dsmfWrite(DSMF_Ctl, (pie_handle->pie_dsmf->DSMF_Ctl | DSMF_DSMF_CTL_CPU_ACCESS_LUT_MASK));
    dsmfWrite(DSMF_Seg_HV_Proj, pie_handle->pie_dsmf->DSMF_Seg_HV_Proj);
    dsmfWrite(DSMF_Seg_Diag_Proj, pie_handle->pie_dsmf->DSMF_Seg_Diag_Proj);
    dsmfWrite(DSMF_Seg_Isolated, pie_handle->pie_dsmf->DSMF_Seg_Isolated);
    dsmfWrite(DSMF_Seg_3x3_Text, pie_handle->pie_dsmf->DSMF_Seg_3x3_Text);
    dsmfWrite(DSMF_Seg_3x3_Mixed, pie_handle->pie_dsmf->DSMF_Seg_3x3_Mixed);
    dsmfWrite(DSMF_Seg_5x5_Text, pie_handle->pie_dsmf->DSMF_Seg_5x5_Text);
    dsmfWrite(DSMF_Seg_5x5_Mixed, pie_handle->pie_dsmf->DSMF_Seg_5x5_Mixed);
    dsmfWrite(DSMF_Seg_Line, pie_handle->pie_dsmf->DSMF_Seg_Line);
    dsmfWrite(DSMF_Seg_Line_Diag, pie_handle->pie_dsmf->DSMF_Seg_Line_Diag);
    dsmfWrite(DSMF_SCR1, pie_handle->pie_dsmf->DSMF_SCR1);
    dsmfWrite(DSMF_SCR2, pie_handle->pie_dsmf->DSMF_SCR2);
    dsmfWrite(DSMF_TEL1R, pie_handle->pie_dsmf->DSMF_TEL1R);
    dsmfWrite(DSMF_TEL2R, pie_handle->pie_dsmf->DSMF_TEL2R);
    dsmfWrite(DSMF_TEL3R, pie_handle->pie_dsmf->DSMF_TEL3R);
    dsmfWrite(DSMF_EC_COMPARE, pie_handle->pie_dsmf->DSMF_EC_COMPARE);
    dsmfWrite(DSMF_EC_WR, pie_handle->pie_dsmf->DSMF_EC_WR);
    // dsmfWrite(DSMF_EC_OBS, pie_handle->pie_dsmf->DSMF_EC_OBS); read only register
    dsmfWrite(DSMF_ECI, pie_handle->pie_dsmf->DSMF_ECI);
    dsmfWrite(DSMF_YVC00_01, pie_handle->pie_dsmf->DSMF_YVC00_01);
    dsmfWrite(DSMF_YVC02_03, pie_handle->pie_dsmf->DSMF_YVC02_03);
    dsmfWrite(DSMF_YVC04_10, pie_handle->pie_dsmf->DSMF_YVC04_10);
    dsmfWrite(DSMF_YVC11_12, pie_handle->pie_dsmf->DSMF_YVC11_12);
    dsmfWrite(DSMF_YVC13_14, pie_handle->pie_dsmf->DSMF_YVC13_14);
    dsmfWrite(DSMF_YVC20_21, pie_handle->pie_dsmf->DSMF_YVC20_21);
    dsmfWrite(DSMF_YVC22_23, pie_handle->pie_dsmf->DSMF_YVC22_23);
    dsmfWrite(DSMF_YVC24, pie_handle->pie_dsmf->DSMF_YVC24);
    dsmfWrite(DSMF_YVC30_31, pie_handle->pie_dsmf->DSMF_YVC30_31);
    dsmfWrite(DSMF_YVC32_33, pie_handle->pie_dsmf->DSMF_YVC32_33);
    dsmfWrite(DSMF_YVC34_40, pie_handle->pie_dsmf->DSMF_YVC34_40);
    dsmfWrite(DSMF_YVC41_42, pie_handle->pie_dsmf->DSMF_YVC41_42);
    dsmfWrite(DSMF_YVC43_44, pie_handle->pie_dsmf->DSMF_YVC43_44);
    dsmfWrite(DSMF_CVC00_01, pie_handle->pie_dsmf->DSMF_CVC00_01);
    dsmfWrite(DSMF_CVC02_03, pie_handle->pie_dsmf->DSMF_CVC02_03);
    dsmfWrite(DSMF_CVC04_10, pie_handle->pie_dsmf->DSMF_CVC04_10);
    dsmfWrite(DSMF_CVC11_12, pie_handle->pie_dsmf->DSMF_CVC11_12);
    dsmfWrite(DSMF_CVC13_14, pie_handle->pie_dsmf->DSMF_CVC13_14);
    dsmfWrite(DSMF_CVC20_21, pie_handle->pie_dsmf->DSMF_CVC20_21);
    dsmfWrite(DSMF_CVC22_23, pie_handle->pie_dsmf->DSMF_CVC22_23);
    dsmfWrite(DSMF_CVC24, pie_handle->pie_dsmf->DSMF_CVC24);
    dsmfWrite(DSMF_CVC30_31, pie_handle->pie_dsmf->DSMF_CVC30_31);
    dsmfWrite(DSMF_CVC32_33, pie_handle->pie_dsmf->DSMF_CVC32_33);
    dsmfWrite(DSMF_CVC34_40, pie_handle->pie_dsmf->DSMF_CVC34_40);
    dsmfWrite(DSMF_CVC41_42, pie_handle->pie_dsmf->DSMF_CVC41_42);
    dsmfWrite(DSMF_CVC43_44, pie_handle->pie_dsmf->DSMF_CVC43_44);
    dsmfWrite(DSMF_FILT_MULT, pie_handle->pie_dsmf->DSMF_FILT_MULT);
    dsmfWrite(DSMF_FILT_SHIFT, pie_handle->pie_dsmf->DSMF_FILT_SHIFT);
    dsmfWrite(DSMF_YVC00_01_F1, pie_handle->pie_dsmf->DSMF_YVC00_01_F1);
    dsmfWrite(DSMF_YVC02_03_F1, pie_handle->pie_dsmf->DSMF_YVC02_03_F1);
    dsmfWrite(DSMF_YVC04_10_F1, pie_handle->pie_dsmf->DSMF_YVC04_10_F1);
    dsmfWrite(DSMF_YVC11_12_F1, pie_handle->pie_dsmf->DSMF_YVC11_12_F1);
    dsmfWrite(DSMF_YVC13_14_F1, pie_handle->pie_dsmf->DSMF_YVC13_14_F1);
    dsmfWrite(DSMF_YVC20_21_F1, pie_handle->pie_dsmf->DSMF_YVC20_21_F1);
    dsmfWrite(DSMF_YVC22_23_F1, pie_handle->pie_dsmf->DSMF_YVC22_23_F1);
    dsmfWrite(DSMF_YVC24_F1, pie_handle->pie_dsmf->DSMF_YVC24_F1);
    dsmfWrite(DSMF_YVC30_31_F1, pie_handle->pie_dsmf->DSMF_YVC30_31_F1);
    dsmfWrite(DSMF_YVC32_33_F1, pie_handle->pie_dsmf->DSMF_YVC32_33_F1);
    dsmfWrite(DSMF_YVC34_40_F1, pie_handle->pie_dsmf->DSMF_YVC34_40_F1);
    dsmfWrite(DSMF_YVC41_42_F1, pie_handle->pie_dsmf->DSMF_YVC41_42_F1);
    dsmfWrite(DSMF_YVC43_44_F1, pie_handle->pie_dsmf->DSMF_YVC43_44_F1);
    dsmfWrite(DSMF_CVC00_01_F1, pie_handle->pie_dsmf->DSMF_CVC00_01_F1);
    dsmfWrite(DSMF_CVC02_03_F1, pie_handle->pie_dsmf->DSMF_CVC02_03_F1);
    dsmfWrite(DSMF_CVC04_10_F1, pie_handle->pie_dsmf->DSMF_CVC04_10_F1);
    dsmfWrite(DSMF_CVC11_12_F1, pie_handle->pie_dsmf->DSMF_CVC11_12_F1);
    dsmfWrite(DSMF_CVC13_14_F1, pie_handle->pie_dsmf->DSMF_CVC13_14_F1);
    dsmfWrite(DSMF_CVC20_21_F1, pie_handle->pie_dsmf->DSMF_CVC20_21_F1);
    dsmfWrite(DSMF_CVC22_23_F1, pie_handle->pie_dsmf->DSMF_CVC22_23_F1);
    dsmfWrite(DSMF_CVC24_F1, pie_handle->pie_dsmf->DSMF_CVC24_F1);
    dsmfWrite(DSMF_CVC30_31_F1, pie_handle->pie_dsmf->DSMF_CVC30_31_F1);
    dsmfWrite(DSMF_CVC32_33_F1, pie_handle->pie_dsmf->DSMF_CVC32_33_F1);
    dsmfWrite(DSMF_CVC34_40_F1, pie_handle->pie_dsmf->DSMF_CVC34_40_F1);
    dsmfWrite(DSMF_CVC41_42_F1, pie_handle->pie_dsmf->DSMF_CVC41_42_F1);
    dsmfWrite(DSMF_CVC43_44_F1, pie_handle->pie_dsmf->DSMF_CVC43_44_F1);
    dsmfWrite(DSMF_FILT_MULT_F1, pie_handle->pie_dsmf->DSMF_FILT_MULT_F1);
    dsmfWrite(DSMF_FILT_SHIFT_F1, pie_handle->pie_dsmf->DSMF_FILT_SHIFT_F1);
    dsmfWrite(DSMF_YVC00_01_F2, pie_handle->pie_dsmf->DSMF_YVC00_01_F2);
    dsmfWrite(DSMF_YVC02_03_F2, pie_handle->pie_dsmf->DSMF_YVC02_03_F2);
    dsmfWrite(DSMF_YVC04_10_F2, pie_handle->pie_dsmf->DSMF_YVC04_10_F2);
    dsmfWrite(DSMF_YVC11_12_F2, pie_handle->pie_dsmf->DSMF_YVC11_12_F2);
    dsmfWrite(DSMF_YVC13_14_F2, pie_handle->pie_dsmf->DSMF_YVC13_14_F2);
    dsmfWrite(DSMF_YVC20_21_F2, pie_handle->pie_dsmf->DSMF_YVC20_21_F2);
    dsmfWrite(DSMF_YVC22_23_F2, pie_handle->pie_dsmf->DSMF_YVC22_23_F2);
    dsmfWrite(DSMF_YVC24_F2, pie_handle->pie_dsmf->DSMF_YVC24_F2);
    dsmfWrite(DSMF_YVC30_31_F2, pie_handle->pie_dsmf->DSMF_YVC30_31_F2);
    dsmfWrite(DSMF_YVC32_33_F2, pie_handle->pie_dsmf->DSMF_YVC32_33_F2);
    dsmfWrite(DSMF_YVC34_40_F2, pie_handle->pie_dsmf->DSMF_YVC34_40_F2);
    dsmfWrite(DSMF_YVC41_42_F2, pie_handle->pie_dsmf->DSMF_YVC41_42_F2);
    dsmfWrite(DSMF_YVC43_44_F2, pie_handle->pie_dsmf->DSMF_YVC43_44_F2);
    dsmfWrite(DSMF_CVC00_01_F2, pie_handle->pie_dsmf->DSMF_CVC00_01_F2);
    dsmfWrite(DSMF_CVC02_03_F2, pie_handle->pie_dsmf->DSMF_CVC02_03_F2);
    dsmfWrite(DSMF_CVC04_10_F2, pie_handle->pie_dsmf->DSMF_CVC04_10_F2);
    dsmfWrite(DSMF_CVC11_12_F2, pie_handle->pie_dsmf->DSMF_CVC11_12_F2);
    dsmfWrite(DSMF_CVC13_14_F2, pie_handle->pie_dsmf->DSMF_CVC13_14_F2);
    dsmfWrite(DSMF_CVC20_21_F2, pie_handle->pie_dsmf->DSMF_CVC20_21_F2);
    dsmfWrite(DSMF_CVC22_23_F2, pie_handle->pie_dsmf->DSMF_CVC22_23_F2);
    dsmfWrite(DSMF_CVC24_F2, pie_handle->pie_dsmf->DSMF_CVC24_F2);
    dsmfWrite(DSMF_CVC30_31_F2, pie_handle->pie_dsmf->DSMF_CVC30_31_F2);
    dsmfWrite(DSMF_CVC32_33_F2, pie_handle->pie_dsmf->DSMF_CVC32_33_F2);
    dsmfWrite(DSMF_CVC34_40_F2, pie_handle->pie_dsmf->DSMF_CVC34_40_F2);
    dsmfWrite(DSMF_CVC41_42_F2, pie_handle->pie_dsmf->DSMF_CVC41_42_F2);
    dsmfWrite(DSMF_CVC43_44_F2, pie_handle->pie_dsmf->DSMF_CVC43_44_F2);
    dsmfWrite(DSMF_FILT_MULT_F2, pie_handle->pie_dsmf->DSMF_FILT_MULT_F2);
    dsmfWrite(DSMF_FILT_SHIFT_F2, pie_handle->pie_dsmf->DSMF_FILT_SHIFT_F2);
    dsmfWrite(DSMF_YVC00_01_F3, pie_handle->pie_dsmf->DSMF_YVC00_01_F3);
    dsmfWrite(DSMF_YVC02_03_F3, pie_handle->pie_dsmf->DSMF_YVC02_03_F3);
    dsmfWrite(DSMF_YVC04_10_F3, pie_handle->pie_dsmf->DSMF_YVC04_10_F3);
    dsmfWrite(DSMF_YVC11_12_F3, pie_handle->pie_dsmf->DSMF_YVC11_12_F3);
    dsmfWrite(DSMF_YVC13_14_F3, pie_handle->pie_dsmf->DSMF_YVC13_14_F3);
    dsmfWrite(DSMF_YVC20_21_F3, pie_handle->pie_dsmf->DSMF_YVC20_21_F3);
    dsmfWrite(DSMF_YVC22_23_F3, pie_handle->pie_dsmf->DSMF_YVC22_23_F3);
    dsmfWrite(DSMF_YVC24_F3, pie_handle->pie_dsmf->DSMF_YVC24_F3);
    dsmfWrite(DSMF_YVC30_31_F3, pie_handle->pie_dsmf->DSMF_YVC30_31_F3);
    dsmfWrite(DSMF_YVC32_33_F3, pie_handle->pie_dsmf->DSMF_YVC32_33_F3);
    dsmfWrite(DSMF_YVC34_40_F3, pie_handle->pie_dsmf->DSMF_YVC34_40_F3);
    dsmfWrite(DSMF_YVC41_42_F3, pie_handle->pie_dsmf->DSMF_YVC41_42_F3);
    dsmfWrite(DSMF_YVC43_44_F3, pie_handle->pie_dsmf->DSMF_YVC43_44_F3);
    dsmfWrite(DSMF_CVC00_01_F3, pie_handle->pie_dsmf->DSMF_CVC00_01_F3);
    dsmfWrite(DSMF_CVC02_03_F3, pie_handle->pie_dsmf->DSMF_CVC02_03_F3);
    dsmfWrite(DSMF_CVC04_10_F3, pie_handle->pie_dsmf->DSMF_CVC04_10_F3);
    dsmfWrite(DSMF_CVC11_12_F3, pie_handle->pie_dsmf->DSMF_CVC11_12_F3);
    dsmfWrite(DSMF_CVC13_14_F3, pie_handle->pie_dsmf->DSMF_CVC13_14_F3);
    dsmfWrite(DSMF_CVC20_21_F3, pie_handle->pie_dsmf->DSMF_CVC20_21_F3);
    dsmfWrite(DSMF_CVC22_23_F3, pie_handle->pie_dsmf->DSMF_CVC22_23_F3);
    dsmfWrite(DSMF_CVC24_F3, pie_handle->pie_dsmf->DSMF_CVC24_F3);
    dsmfWrite(DSMF_CVC30_31_F3, pie_handle->pie_dsmf->DSMF_CVC30_31_F3);
    dsmfWrite(DSMF_CVC32_33_F3, pie_handle->pie_dsmf->DSMF_CVC32_33_F3);
    dsmfWrite(DSMF_CVC34_40_F3, pie_handle->pie_dsmf->DSMF_CVC34_40_F3);
    dsmfWrite(DSMF_CVC41_42_F3, pie_handle->pie_dsmf->DSMF_CVC41_42_F3);
    dsmfWrite(DSMF_CVC43_44_F3, pie_handle->pie_dsmf->DSMF_CVC43_44_F3);
    dsmfWrite(DSMF_FILT_MULT_F3, pie_handle->pie_dsmf->DSMF_FILT_MULT_F3);
    dsmfWrite(DSMF_FILT_SHIFT_F3, pie_handle->pie_dsmf->DSMF_FILT_SHIFT_F3);
    dsmfWrite(DSMF_AVG_MASK, pie_handle->pie_dsmf->DSMF_AVG_MASK);

    for (i=0;i<PIE_DSMF_CTL_LUT_ENTRIES;i++)
    {
        dsmfWriteArray(DSMF_FILT_CTL_LUT, pie_handle->pie_dsmf->DSMF_FILT_CTL_LUT[i], i);
    }

    for (i=0;i<PIE_DSMF_SEG_PROJ_LUT_ENTRIES;i++)
    {
        dsmfWriteArray(DSMF_SEG_PROJ_LUT, pie_handle->pie_dsmf->DSMF_SEG_PROJ_LUT[i], i);
    }

    for (i=0;i<PIE_DSMF_AI_LUT_ENTRIES;i++)
    {
        dsmfWriteArray(DSMF_AI_LUT0, pie_handle->pie_dsmf->DSMF_AI_LUT0[i], i);
        dsmfWriteArray(DSMF_AI_LUT1, pie_handle->pie_dsmf->DSMF_AI_LUT1[i], i);        
    }

    // now write the DSMF_Ctl (with the cpu_access normal)
    dsmfWrite(DSMF_Ctl, pie_handle->pie_dsmf->DSMF_Ctl);

    // REV0 and REV1 are Read only
    
    UNPROTECT_REG_ACCESS;
}

static void pie_get_current(dsmfData *device_data,
                            struct pie_handle_t *pie_handle)
{
    int i;

    pie_handle->pie_dsmf->DSMF_Ctl = dsmfRead(DSMF_Ctl);
    pie_handle->pie_dsmf->DSMF_Seg_HV_Proj = dsmfRead(DSMF_Seg_HV_Proj);
    pie_handle->pie_dsmf->DSMF_Seg_Diag_Proj = dsmfRead(DSMF_Seg_Diag_Proj);
    pie_handle->pie_dsmf->DSMF_Seg_Isolated = dsmfRead(DSMF_Seg_Isolated);
    pie_handle->pie_dsmf->DSMF_Seg_3x3_Text = dsmfRead(DSMF_Seg_3x3_Text);
    pie_handle->pie_dsmf->DSMF_Seg_3x3_Mixed = dsmfRead(DSMF_Seg_3x3_Mixed);
    pie_handle->pie_dsmf->DSMF_Seg_5x5_Text = dsmfRead(DSMF_Seg_5x5_Text);
    pie_handle->pie_dsmf->DSMF_Seg_5x5_Mixed = dsmfRead(DSMF_Seg_5x5_Mixed);
    pie_handle->pie_dsmf->DSMF_Seg_Line = dsmfRead(DSMF_Seg_Line);
    pie_handle->pie_dsmf->DSMF_Seg_Line_Diag = dsmfRead(DSMF_Seg_Line_Diag);
    pie_handle->pie_dsmf->DSMF_SCR1 = dsmfRead(DSMF_SCR1);
    pie_handle->pie_dsmf->DSMF_SCR2 = dsmfRead(DSMF_SCR2);
    pie_handle->pie_dsmf->DSMF_TEL1R = dsmfRead(DSMF_TEL1R);
    pie_handle->pie_dsmf->DSMF_TEL2R = dsmfRead(DSMF_TEL2R);
    pie_handle->pie_dsmf->DSMF_TEL3R = dsmfRead(DSMF_TEL3R);
    pie_handle->pie_dsmf->DSMF_EC_COMPARE = dsmfRead(DSMF_EC_COMPARE);
    // DSMF_EC_WR is a write only register
    pie_handle->pie_dsmf->DSMF_EC_OBS = dsmfRead(DSMF_EC_OBS);
    pie_handle->pie_dsmf->DSMF_ECI = dsmfRead(DSMF_ECI);
    pie_handle->pie_dsmf->DSMF_YVC00_01 = dsmfRead(DSMF_YVC00_01);
    pie_handle->pie_dsmf->DSMF_YVC02_03 = dsmfRead(DSMF_YVC02_03);
    pie_handle->pie_dsmf->DSMF_YVC04_10 = dsmfRead(DSMF_YVC04_10);
    pie_handle->pie_dsmf->DSMF_YVC11_12 = dsmfRead(DSMF_YVC11_12);
    pie_handle->pie_dsmf->DSMF_YVC13_14 = dsmfRead(DSMF_YVC13_14);
    pie_handle->pie_dsmf->DSMF_YVC20_21 = dsmfRead(DSMF_YVC20_21);
    pie_handle->pie_dsmf->DSMF_YVC22_23 = dsmfRead(DSMF_YVC22_23);
    pie_handle->pie_dsmf->DSMF_YVC24 = dsmfRead(DSMF_YVC24);
    pie_handle->pie_dsmf->DSMF_YVC30_31 = dsmfRead(DSMF_YVC30_31);
    pie_handle->pie_dsmf->DSMF_YVC32_33 = dsmfRead(DSMF_YVC32_33);
    pie_handle->pie_dsmf->DSMF_YVC34_40 = dsmfRead(DSMF_YVC34_40);
    pie_handle->pie_dsmf->DSMF_YVC41_42 = dsmfRead(DSMF_YVC41_42);
    pie_handle->pie_dsmf->DSMF_YVC43_44 = dsmfRead(DSMF_YVC43_44);
    pie_handle->pie_dsmf->DSMF_CVC00_01 = dsmfRead(DSMF_CVC00_01);
    pie_handle->pie_dsmf->DSMF_CVC02_03 = dsmfRead(DSMF_CVC02_03);
    pie_handle->pie_dsmf->DSMF_CVC04_10 = dsmfRead(DSMF_CVC04_10);
    pie_handle->pie_dsmf->DSMF_CVC11_12 = dsmfRead(DSMF_CVC11_12);
    pie_handle->pie_dsmf->DSMF_CVC13_14 = dsmfRead(DSMF_CVC13_14);
    pie_handle->pie_dsmf->DSMF_CVC20_21 = dsmfRead(DSMF_CVC20_21);
    pie_handle->pie_dsmf->DSMF_CVC22_23 = dsmfRead(DSMF_CVC22_23);
    pie_handle->pie_dsmf->DSMF_CVC24 = dsmfRead(DSMF_CVC24);
    pie_handle->pie_dsmf->DSMF_CVC30_31 = dsmfRead(DSMF_CVC30_31);
    pie_handle->pie_dsmf->DSMF_CVC32_33 = dsmfRead(DSMF_CVC32_33);
    pie_handle->pie_dsmf->DSMF_CVC34_40 = dsmfRead(DSMF_CVC34_40);
    pie_handle->pie_dsmf->DSMF_CVC41_42 = dsmfRead(DSMF_CVC41_42);
    pie_handle->pie_dsmf->DSMF_CVC43_44 = dsmfRead(DSMF_CVC43_44);
    pie_handle->pie_dsmf->DSMF_FILT_MULT = dsmfRead(DSMF_FILT_MULT);
    pie_handle->pie_dsmf->DSMF_FILT_SHIFT = dsmfRead(DSMF_FILT_SHIFT);
    pie_handle->pie_dsmf->DSMF_YVC00_01_F1 = dsmfRead(DSMF_YVC00_01_F1);
    pie_handle->pie_dsmf->DSMF_YVC02_03_F1 = dsmfRead(DSMF_YVC02_03_F1);
    pie_handle->pie_dsmf->DSMF_YVC04_10_F1 = dsmfRead(DSMF_YVC04_10_F1);
    pie_handle->pie_dsmf->DSMF_YVC11_12_F1 = dsmfRead(DSMF_YVC11_12_F1);
    pie_handle->pie_dsmf->DSMF_YVC13_14_F1 = dsmfRead(DSMF_YVC13_14_F1);
    pie_handle->pie_dsmf->DSMF_YVC20_21_F1 = dsmfRead(DSMF_YVC20_21_F1);
    pie_handle->pie_dsmf->DSMF_YVC22_23_F1 = dsmfRead(DSMF_YVC22_23_F1);
    pie_handle->pie_dsmf->DSMF_YVC24_F1 = dsmfRead(DSMF_YVC24_F1);
    pie_handle->pie_dsmf->DSMF_YVC30_31_F1 = dsmfRead(DSMF_YVC30_31_F1);
    pie_handle->pie_dsmf->DSMF_YVC32_33_F1 = dsmfRead(DSMF_YVC32_33_F1);
    pie_handle->pie_dsmf->DSMF_YVC34_40_F1 = dsmfRead(DSMF_YVC34_40_F1);
    pie_handle->pie_dsmf->DSMF_YVC41_42_F1 = dsmfRead(DSMF_YVC41_42_F1);
    pie_handle->pie_dsmf->DSMF_YVC43_44_F1 = dsmfRead(DSMF_YVC43_44_F1);
    pie_handle->pie_dsmf->DSMF_CVC00_01_F1 = dsmfRead(DSMF_CVC00_01_F1);
    pie_handle->pie_dsmf->DSMF_CVC02_03_F1 = dsmfRead(DSMF_CVC02_03_F1);
    pie_handle->pie_dsmf->DSMF_CVC04_10_F1 = dsmfRead(DSMF_CVC04_10_F1);
    pie_handle->pie_dsmf->DSMF_CVC11_12_F1 = dsmfRead(DSMF_CVC11_12_F1);
    pie_handle->pie_dsmf->DSMF_CVC13_14_F1 = dsmfRead(DSMF_CVC13_14_F1);
    pie_handle->pie_dsmf->DSMF_CVC20_21_F1 = dsmfRead(DSMF_CVC20_21_F1);
    pie_handle->pie_dsmf->DSMF_CVC22_23_F1 = dsmfRead(DSMF_CVC22_23_F1);
    pie_handle->pie_dsmf->DSMF_CVC24_F1 = dsmfRead(DSMF_CVC24_F1);
    pie_handle->pie_dsmf->DSMF_CVC30_31_F1 = dsmfRead(DSMF_CVC30_31_F1);
    pie_handle->pie_dsmf->DSMF_CVC32_33_F1 = dsmfRead(DSMF_CVC32_33_F1);
    pie_handle->pie_dsmf->DSMF_CVC34_40_F1 = dsmfRead(DSMF_CVC34_40_F1);
    pie_handle->pie_dsmf->DSMF_CVC41_42_F1 = dsmfRead(DSMF_CVC41_42_F1);
    pie_handle->pie_dsmf->DSMF_CVC43_44_F1 = dsmfRead(DSMF_CVC43_44_F1);
    pie_handle->pie_dsmf->DSMF_FILT_MULT_F1 = dsmfRead(DSMF_FILT_MULT_F1);
    pie_handle->pie_dsmf->DSMF_FILT_SHIFT_F1 = dsmfRead(DSMF_FILT_SHIFT_F1);
    pie_handle->pie_dsmf->DSMF_YVC00_01_F2 = dsmfRead(DSMF_YVC00_01_F2);
    pie_handle->pie_dsmf->DSMF_YVC02_03_F2 = dsmfRead(DSMF_YVC02_03_F2);
    pie_handle->pie_dsmf->DSMF_YVC04_10_F2 = dsmfRead(DSMF_YVC04_10_F2);
    pie_handle->pie_dsmf->DSMF_YVC11_12_F2 = dsmfRead(DSMF_YVC11_12_F2);
    pie_handle->pie_dsmf->DSMF_YVC13_14_F2 = dsmfRead(DSMF_YVC13_14_F2);
    pie_handle->pie_dsmf->DSMF_YVC20_21_F2 = dsmfRead(DSMF_YVC20_21_F2);
    pie_handle->pie_dsmf->DSMF_YVC22_23_F2 = dsmfRead(DSMF_YVC22_23_F2);
    pie_handle->pie_dsmf->DSMF_YVC24_F2 = dsmfRead(DSMF_YVC24_F2);
    pie_handle->pie_dsmf->DSMF_YVC30_31_F2 = dsmfRead(DSMF_YVC30_31_F2);
    pie_handle->pie_dsmf->DSMF_YVC32_33_F2 = dsmfRead(DSMF_YVC32_33_F2);
    pie_handle->pie_dsmf->DSMF_YVC34_40_F2 = dsmfRead(DSMF_YVC34_40_F2);
    pie_handle->pie_dsmf->DSMF_YVC41_42_F2 = dsmfRead(DSMF_YVC41_42_F2);
    pie_handle->pie_dsmf->DSMF_YVC43_44_F2 = dsmfRead(DSMF_YVC43_44_F2);
    pie_handle->pie_dsmf->DSMF_CVC00_01_F2 = dsmfRead(DSMF_CVC00_01_F2);
    pie_handle->pie_dsmf->DSMF_CVC02_03_F2 = dsmfRead(DSMF_CVC02_03_F2);
    pie_handle->pie_dsmf->DSMF_CVC04_10_F2 = dsmfRead(DSMF_CVC04_10_F2);
    pie_handle->pie_dsmf->DSMF_CVC11_12_F2 = dsmfRead(DSMF_CVC11_12_F2);
    pie_handle->pie_dsmf->DSMF_CVC13_14_F2 = dsmfRead(DSMF_CVC13_14_F2);
    pie_handle->pie_dsmf->DSMF_CVC20_21_F2 = dsmfRead(DSMF_CVC20_21_F2);
    pie_handle->pie_dsmf->DSMF_CVC22_23_F2 = dsmfRead(DSMF_CVC22_23_F2);
    pie_handle->pie_dsmf->DSMF_CVC24_F2 = dsmfRead(DSMF_CVC24_F2);
    pie_handle->pie_dsmf->DSMF_CVC30_31_F2 = dsmfRead(DSMF_CVC30_31_F2);
    pie_handle->pie_dsmf->DSMF_CVC32_33_F2 = dsmfRead(DSMF_CVC32_33_F2);
    pie_handle->pie_dsmf->DSMF_CVC34_40_F2 = dsmfRead(DSMF_CVC34_40_F2);
    pie_handle->pie_dsmf->DSMF_CVC41_42_F2 = dsmfRead(DSMF_CVC41_42_F2);
    pie_handle->pie_dsmf->DSMF_CVC43_44_F2 = dsmfRead(DSMF_CVC43_44_F2);
    pie_handle->pie_dsmf->DSMF_FILT_MULT_F2 = dsmfRead(DSMF_FILT_MULT_F2);
    pie_handle->pie_dsmf->DSMF_FILT_SHIFT_F2 = dsmfRead(DSMF_FILT_SHIFT_F2);
    pie_handle->pie_dsmf->DSMF_YVC00_01_F3 = dsmfRead(DSMF_YVC00_01_F3);
    pie_handle->pie_dsmf->DSMF_YVC02_03_F3 = dsmfRead(DSMF_YVC02_03_F3);
    pie_handle->pie_dsmf->DSMF_YVC04_10_F3 = dsmfRead(DSMF_YVC04_10_F3);
    pie_handle->pie_dsmf->DSMF_YVC11_12_F3 = dsmfRead(DSMF_YVC11_12_F3);
    pie_handle->pie_dsmf->DSMF_YVC13_14_F3 = dsmfRead(DSMF_YVC13_14_F3);
    pie_handle->pie_dsmf->DSMF_YVC20_21_F3 = dsmfRead(DSMF_YVC20_21_F3);
    pie_handle->pie_dsmf->DSMF_YVC22_23_F3 = dsmfRead(DSMF_YVC22_23_F3);
    pie_handle->pie_dsmf->DSMF_YVC24_F3 = dsmfRead(DSMF_YVC24_F3);
    pie_handle->pie_dsmf->DSMF_YVC30_31_F3 = dsmfRead(DSMF_YVC30_31_F3);
    pie_handle->pie_dsmf->DSMF_YVC32_33_F3 = dsmfRead(DSMF_YVC32_33_F3);
    pie_handle->pie_dsmf->DSMF_YVC34_40_F3 = dsmfRead(DSMF_YVC34_40_F3);
    pie_handle->pie_dsmf->DSMF_YVC41_42_F3 = dsmfRead(DSMF_YVC41_42_F3);
    pie_handle->pie_dsmf->DSMF_YVC43_44_F3 = dsmfRead(DSMF_YVC43_44_F3);
    pie_handle->pie_dsmf->DSMF_CVC00_01_F3 = dsmfRead(DSMF_CVC00_01_F3);
    pie_handle->pie_dsmf->DSMF_CVC02_03_F3 = dsmfRead(DSMF_CVC02_03_F3);
    pie_handle->pie_dsmf->DSMF_CVC04_10_F3 = dsmfRead(DSMF_CVC04_10_F3);
    pie_handle->pie_dsmf->DSMF_CVC11_12_F3 = dsmfRead(DSMF_CVC11_12_F3);
    pie_handle->pie_dsmf->DSMF_CVC13_14_F3 = dsmfRead(DSMF_CVC13_14_F3);
    pie_handle->pie_dsmf->DSMF_CVC20_21_F3 = dsmfRead(DSMF_CVC20_21_F3);
    pie_handle->pie_dsmf->DSMF_CVC22_23_F3 = dsmfRead(DSMF_CVC22_23_F3);
    pie_handle->pie_dsmf->DSMF_CVC24_F3 = dsmfRead(DSMF_CVC24_F3);
    pie_handle->pie_dsmf->DSMF_CVC30_31_F3 = dsmfRead(DSMF_CVC30_31_F3);
    pie_handle->pie_dsmf->DSMF_CVC32_33_F3 = dsmfRead(DSMF_CVC32_33_F3);
    pie_handle->pie_dsmf->DSMF_CVC34_40_F3 = dsmfRead(DSMF_CVC34_40_F3);
    pie_handle->pie_dsmf->DSMF_CVC41_42_F3 = dsmfRead(DSMF_CVC41_42_F3);
    pie_handle->pie_dsmf->DSMF_CVC43_44_F3 = dsmfRead(DSMF_CVC43_44_F3);
    pie_handle->pie_dsmf->DSMF_FILT_MULT_F3 = dsmfRead(DSMF_FILT_MULT_F3);
    pie_handle->pie_dsmf->DSMF_FILT_SHIFT_F3 = dsmfRead(DSMF_FILT_SHIFT_F3);
    pie_handle->pie_dsmf->DSMF_AVG_MASK = dsmfRead(DSMF_AVG_MASK);
    
    pie_handle->pie_dsmf->REV0 = dsmfRead(REV0);
    pie_handle->pie_dsmf->REV1 = dsmfRead(REV1);

    // set CPU access bit before reading LUT
    dsmfWrite(DSMF_Ctl, (pie_handle->pie_dsmf->DSMF_Ctl | DSMF_DSMF_CTL_CPU_ACCESS_LUT_MASK));

    for (i=0;i<PIE_DSMF_CTL_LUT_ENTRIES;i++)
    {
        pie_handle->pie_dsmf->DSMF_FILT_CTL_LUT[i] = dsmfReadArray(DSMF_FILT_CTL_LUT, i);
    }
    // DSMF_SEG_PROJ LUT is write only!
    // DSMF_AI_LUT0 and DSMF_AI_LUT1 are write only!

    // now write the DSMF_Ctl (with the cpu_access as requested)
    dsmfWrite(DSMF_Ctl, pie_handle->pie_dsmf->DSMF_Ctl);
}

struct pie_dsmf_function_struct pie_dsmf_functions =
{
    .pie_reset             = pie_reset,
    .pie_configure         = pie_configure,
    .pie_get_current       = pie_get_current,
    .pie_revcheck          = pie_revcheck,

    .dump_dsmf_regs        = dump_dsmf_regs,
};

void pie_dsmf_init(dsmfData *device_data)
{
    dsmfDeviceHandle *pie_device_handle;

    pie_device_handle = allocate_memory(sizeof(dsmfDeviceHandle), GFP_KERNEL);
    
    // register with the parent
    pie_device_handle->fcn_tbl = &pie_dsmf_functions;
    pie_device_handle->device_data = device_data;
    register_pie_subblock(dsmf, pie_device_handle);
    // NOTE that macro PROTECT_REG_ACCESS uses reg_spinlock
    spin_lock_init(&(pie_device_handle->device_data->reg_spinlock));

    // dsmf has no interrupts associated with it, so no callback
    pie_device_handle->device_data->interrupt_callback = NULL;
    pie_device_handle->device_data->interrupt_callback_data = NULL;    
    print("PIE DSMF LOADED .....\n");
}
EXPORT_SYMBOL(pie_dsmf_init);


void pie_dsmf_exit(dsmfData *device_data)
{
    dsmfDeviceHandle *pie_device_handle;

    // unregister with the parent
    pie_device_handle = unregister_pie_subblock(dsmf);
    free_memory(pie_device_handle);    
}
EXPORT_SYMBOL(pie_dsmf_exit);

