/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIE_DRIVERLIB_IF_H_
#define _PIE_DRIVERLIB_IF_H_


#ifdef __KERNEL__
#include <linux/slab.h>
#include <linux/vmalloc.h>
#define allocate_memory(size, type) vmalloc(size)
#define free_memory(pointer) vfree(pointer)
#define error_print(args...) printk(args)
#define print(args...) printk(args)

#else
// appspace (not kernel)
#define allocate_memory(size, type) malloc(size)
#define free_memory(pointer) free(pointer)

#define error_print(args...) printf(args)
#define print(args...) printf(args)

#define BUG_ON(args...) if (args) printf("%s:BUG_ON %s *********** \n", __func__, #args);
#define EXPORT_SYMBOL(name)

#define EINVAL 22
#endif

// pie_driverlib declares its functions here for pie drivers and
// pie_convenience
uint32_t *get_subblock_sizes(void);
void pie_common_set_all_irqstruct(struct pie_common_ints *irqstruct, bool setval);
void pie_pogo_set_all_irqstruct_idma(struct idma_interrupt_info *irqstruct, bool setval);
void pie_pogo_set_all_irqstruct_odma(struct odma_interrupt_info *irqstruct, bool setval);
void pie_otmarb_set_all_irqstruct(struct otmarb_interrupt_info *irqstruct, bool setval);
uint32_t pie_common_convert_irqstruct_to_update_reg(struct pie_common_ints *irqstruct,
                                                    uint32_t pie_common_reg,
                                                    bool set_true_clear_false);
uint32_t pie_odma_convert_irqstruct_to_update_udma_reg(struct odma_interrupt_info *irqstruct,
                                                       uint32_t udmareg,
                                                       bool  set_true_clear_false);
uint32_t pie_odma_convert_irqstruct_to_update_core_reg(struct odma_interrupt_info *irqstruct,
                                                       uint32_t corereg,
                                                       bool set_true_clear_false);
uint32_t pie_otidma_convert_irqstruct_to_update_udma_reg(struct idma_interrupt_info *irqstruct,
                                                         uint32_t udmareg,
                                                         bool set_true_clear_false);
uint32_t pie_otidma_convert_irqstruct_to_update_core_reg(struct idma_interrupt_info *irqstruct,
                                                         uint32_t corereg,
                                                         bool set_true_clear_false);
uint32_t pie_otodma_convert_irqstruct_to_update_udma_reg(struct odma_interrupt_info *irqstruct,
                                                         uint32_t udmareg,
                                                         bool  set_true_clear_false);
uint32_t pie_otodma_convert_irqstruct_to_update_core_reg(struct odma_interrupt_info *irqstruct,
                                                       uint32_t corereg,
                                                       bool set_true_clear_false);
uint32_t pie_idma_convert_irqstruct_to_update_udma_reg(struct idma_interrupt_info *irqstruct,
                                                       uint32_t udmareg,
                                                       bool set_true_clear_false);
uint32_t pie_idma_convert_irqstruct_to_update_core_reg(struct idma_interrupt_info *irqstruct,
                                                       uint32_t corereg,
                                                       bool set_true_clear_false);
uint32_t pie_distort_convert_irqstruct_to_update_reg(struct idma_interrupt_info *irqstruct,
                                                     uint32_t reg,
                                                     bool set_true_clear_false);
uint32_t pie_otmarb_convert_irqstruct_to_update_reg(struct otmarb_interrupt_info *irqstruct,
                                                    uint32_t reg,
                                                    bool set_true_clear_false);


void pie_common_convert_uintarray_to_irqstruct(struct pie_common_ints *irqstruct,
                                               uint32_t irqs);
void pie_odma_convert_udma_uintarray_to_irqstruct(struct odma_interrupt_info *irqstruct,
                                                  uint32_t irqs);
void pie_odma_convert_core_uintarray_to_irqstruct(struct odma_interrupt_info *irqstruct,
                                                  uint32_t irqs);
void pie_otidma_convert_udma_uintarray_to_irqstruct(struct idma_interrupt_info *irqstruct,
                                                    uint32_t irqs);
void pie_otidma_convert_core_uintarray_to_irqstruct(struct idma_interrupt_info *irqstruct,
                                                    uint32_t irqs);
void pie_otodma_convert_udma_uintarray_to_irqstruct(struct odma_interrupt_info *irqstruct,
                                                    uint32_t irqs);
void pie_otodma_convert_core_uintarray_to_irqstruct(struct odma_interrupt_info *irqstruct,
                                                    uint32_t irqs);
void pie_idma_convert_udma_uintarray_to_irqstruct(struct idma_interrupt_info *irqstruct,
                                                  uint32_t irqs);

void pie_idma_convert_core_uintarray_to_irqstruct(struct idma_interrupt_info *irqstruct,
                                                  uint32_t irqs);
void pie_otmarb_convert_uintarray_to_irqstruct(struct otmarb_interrupt_info *irqstruct,
                                               uint32_t irqs);



void fixup_shadow_pointers(struct pie_handle_t *pie_handle);

//#define DURING_DEBUG 1

#ifdef DURING_DEBUG
  #define debug_print(args...) print(args)
#else
#define debug_print(args...)
#endif

#endif
