/*
 ***************************************************************************************
 * (c) Copyright 2013-2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIE_driver_H_
#define _PIE_driver_H_

// interface between pie.c and the layer below it

// PIE enums
enum pie_internal_subblock{common=0, pogo_dma, xyscaler, xycscaler, colorshift, rgb2ycc, 
                           ycc2rgb, rgb2esrgb, dsmf, tcns, sccsc, cstats, ngadjust,
                           distort, ddma0, ddma1, ddma2, antifcor, decim, clippad, bde0,
                           bde1, bde2, otmarb};

#define NUM_PIE_BDE_CHANNELS 3
#define NUM_PIE_DDMA_CHANNELS 3

///////////// pie.c functions

// subblocks must register with pie.c
void register_pie_subblock(enum pie_internal_subblock piesubblock,
                           void *pie_subblock_data);
void *unregister_pie_subblock(enum pie_internal_subblock piesubblock);

// for pie_common to call into pie.c
void pie_handle_odma_irqs(void);
void pie_handle_idma_irqs(void);
void pie_handle_distort_irqs(void);
void pie_handle_distort_idma_irqs(int instance);
void pie_handle_otmarb_irqs(void);

#endif
