/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIE_DISTORT_IF_H_
#define _PIE_DISTORT_IF_H_

// interface exported up from c file

/////////////////////////////////////////////////////////////////////////////
// structure passed to pie.c - device_data will be opaque to pie.c
/////////////////////////////////////////////////////////////////////////////
typedef struct distortDeviceHandle
{
    struct pie_distort_function_struct *fcn_tbl;
    distortData *device_data;
} distortDeviceHandle;

struct pie_distort_function_struct
{
    void (*pie_reset)       (distortData *device_data);
    void (*pie_configure)   (distortData *device_data, struct pie_handle_t *pie_handle);
    void (*pie_get_current) (distortData *device_data, struct pie_handle_t *pie_handle);
    int  (*pie_revcheck)    (distortData *device_data, struct pie_handle_t *pie_handle);
    
    void (*dump_distort_regs) (distortData *device_data);

    void (*handle_distort_irqs) (distortData *pogo_object);
    void (*start_pie_distort) (distortData *device_data, struct pie_handle_t *pie_handle);
};

typedef struct ddmaAcDataDeviceHandle
{
    struct pie_ddma_ac_data_function_struct *fcn_tbl;
    ddmaAcDataData *device_data;
} ddmaAcDataDeviceHandle;

struct pie_ddma_ac_data_function_struct 
{
    void (*pie_reset)       (ddmaAcDataData *device_data);
    void (*pie_configure)   (ddmaAcDataData *device_data, struct pie_handle_t *pie_handle);
    void (*pie_get_current) (ddmaAcDataData *device_data, struct pie_handle_t *pie_handle);
    int  (*pie_revcheck)    (ddmaAcDataData *device_data, struct pie_handle_t *pie_handle);
    
    void (*handle_distort_idma_irqs) (ddmaAcDataData *device_data);
    void (*start_pie_distort_idma) (ddmaAcDataData *device_data, dma_addr_t phys_addr);
};

typedef struct antifcorDeviceHandle
{
    struct pie_antifcor_function_struct *fcn_tbl;
    antifcorData *device_data;
} antifcorDeviceHandle;

struct pie_antifcor_function_struct 
{
    void (*pie_reset)       (antifcorData *device_data);
    void (*pie_configure)   (antifcorData *device_data, struct pie_handle_t *pie_handle);
    void (*pie_get_current) (antifcorData *device_data, struct pie_handle_t *pie_handle);
    int  (*pie_revcheck)    (antifcorData *device_data, struct pie_handle_t *pie_handle);
};

#endif

