/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIE_DISTORT_H_
#define _PIE_DISTORT_H_

// our subblock's private data - opaque to everyone else
typedef struct device_data distortData;
typedef struct device_data antifcorData;
typedef struct device_data ddmaAcDataData;

#define distortWrite(rname, val)                                       \
    iowrite32(val, &((struct DISTORT_TOP_DISTORT_REGS_s *)(device_data->virt_addr))->rname)
#define distortRead(rname)  \
    ioread32(&((struct DISTORT_TOP_DISTORT_REGS_s *)(device_data->virt_addr))->rname)
#define printDistortReg(X) print(#X "=0x%08X\n", distortRead(X))

#define distortDmaWrite(rname, val)                                       \
    iowrite32(val, &((struct DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA0_REGS_s *)(device_data->virt_addr))->rname)
#define distortDmaRead(rname)  \
    ioread32(&((struct DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA0_REGS_s *)(device_data->virt_addr))->rname)

#define antiWrite(rname, val)                                       \
    iowrite32(val, &((struct DISTORT_TOP_ANTIFCOR_TOP_ANTIFCOR_REGS_s *)(device_data->virt_addr))->rname)
#define antiRead(rname)  \
    ioread32(&((struct DISTORT_TOP_ANTIFCOR_TOP_ANTIFCOR_REGS_s *)(device_data->virt_addr))->rname)

#endif // _PIE_DISTORT_H_
