/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIE_DATA_H_
#define _PIE_DATA_H_

// device_data is a common structure used by subblocks - pie.c shouldn't care what's in here.
struct device_data
{
    phys_addr_t phys_addr; // physical address of the subblock in PIE
    uint32_t addr_size; // size of address space in the subblock in PIE
    void __iomem *virt_addr; // virtual address of the subblock in PIE
    int irq;  // where applicable - only pie_common.c cares for us
    struct device_suspend_context_struct *device_suspend_context;
    spinlock_t reg_spinlock; // spinlock for accessing regs (add more to dev_adds if needed)
    spinlock_t int_spinlock; // spinlock for interrupts
    // higher level code registers a function for the isr to call, and data to pass
    void (*interrupt_callback) (void *, void *);
    void *interrupt_callback_data;
    int submodinstance; // for multi-instance subblocks - set in the init only
    void (*exit_func)(struct device_data *); // exit function call for this subblock
    struct list_head linked_list; // only to be used by function that calls subblock init
    void *dev_adds; // device specific additions, if needed
};

// simple macros converting boolean to ascii and integer
#define btoa(x) ((x)?"true":"false")
#define btoi(x) ((x)?1:0)

// macro for protecting reading/writing registers.
// bottom half protection since we don't want process-
// space to be interrupted by bottom half processing.
#define PROTECT_REG_ACCESS \
    spin_lock(&(device_data->reg_spinlock))

#define UNPROTECT_REG_ACCESS \
    spin_unlock(&(device_data->reg_spinlock))

// same thing, but for protecting between process
// code and ISRs.  
// There are only a few regs that the interrupt code
// accesses, so these macros should only be used there
#define PROTECT_INTREG_ACCESS_IRQ \
    spin_lock_irqsave(&(device_data->int_spinlock), flags)

#define UNPROTECT_INTREG_ACCESS_IRQ \
    spin_unlock_irqrestore(&(device_data->int_spinlock), flags)

#endif


