/*
 ***************************************************************************************
 * (c) Copyright 2014-2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIE_CONVENIENCE_H_
#define _PIE_CONVENIENCE_H_

// public structures
struct ycc_values
{
    uint8_t y_lut_value;
    uint8_t cr_lut_value;
    uint8_t cb_lut_value;
};

// public interface_functions
int pie_get_handle_size(struct pie_handle_t *pie_handle);

void pie_common_dump_handle_regs(struct pie_handle_t *pie_handle);
void pie_register_common_callback(struct pie_handle_t *pie_handle, void *callback_fcn, void *callback_data);
void pie_enable_common_irqs(struct pie_handle_t *pie_handle,
                            struct pie_common_ints *irqstruct,
                            bool enable);
void pie_force_common_irqs(struct pie_handle_t *pie_handle,
                           struct pie_common_ints *irqstruct,
                           bool force);

void pie_dump_conf(struct pie_handle_t *pie_handle, int instanceId);

int pie_get_max_output_lines(struct pie_handle_t *pie_handle, unsigned int *in_lines, unsigned int *out_lines,
                             unsigned int *discard_lines);
int pie_get_output_lines_from_input(struct pie_handle_t *pie_handle, const unsigned int in_lines, unsigned int *out_lines,
                                    unsigned int cap_at_max);
int pie_get_input_lines_from_output(struct pie_handle_t *pie_handle, unsigned int *in_lines, const unsigned int out_lines,
                                    unsigned int cap_at_max);
int pie_get_discard_lines_from_output(struct pie_handle_t *pie_handle, const unsigned int out_lines,
                                      unsigned int *discard_lines);
int pie_get_output_width(struct pie_handle_t *pie_handle, const unsigned int in_w, unsigned int *out_w);

void pie_register_idma_callback(struct pie_handle_t *pie_handle, void *callback_fcn, void *callback_data);
void pie_force_pogo_idma_irqs(struct pie_handle_t *pie_handle,
                              struct idma_interrupt_info *irqstruct,
                              bool force, int channel);
void pie_enable_pogo_idma_irqs(struct pie_handle_t *pie_handle, struct idma_interrupt_info *irqstruct,
                               int channel, bool enable);

void pie_enable_distort_idma_irqs(struct pie_handle_t *pie_handle, struct idma_interrupt_info *irqstruct,
                                  int channel, bool enable);
void pie_register_otmarb_callback(struct pie_handle_t *pie_handle, void *callback_fcn, void *callback_data);
void pie_register_ot_idma_callback(struct pie_handle_t *pie_handle, void *callback_fcn, void *callback_data);
void pie_register_ot_odma_callback(struct pie_handle_t *pie_handle, void *callback_fcn, void *callback_data);

void pie_register_odma_callback(struct pie_handle_t *pie_handle, void *callback_fcn, void *callback_data);
void pie_force_pogo_odma_irqs(struct pie_handle_t *pie_handle,
                              struct odma_interrupt_info *irqstruct,
                              bool force);
void pie_enable_pogo_odma_irqs(struct pie_handle_t *pie_handle,
                               struct odma_interrupt_info *irqstruct,
                               bool enable);
void pie_enable_otmarb_irqs(struct pie_handle_t *pie_handle,
                            struct otmarb_interrupt_info *irqstruct,
                            bool enable);
void pie_enable_pogo_otidma_irqs(struct pie_handle_t *pie_handle,
                                 struct idma_interrupt_info *irqstruct,
                                 bool enable);
void pie_enable_pogo_otodma_irqs(struct pie_handle_t *pie_handle,
                                 struct odma_interrupt_info *irqstruct,
                                 bool enable);
int pie_pogoizer_set_config(struct pie_handle_t *pie_handle, uint8_t inputformat,
                            uint8_t pogo_bpp, uint8_t colorswap, 
                            uint8_t scalex, uint8_t scaley);
void pie_pogoizer_dump_handle_regs(struct pie_handle_t *pie_handle);


void pie_input_dma_set_parms(struct pie_handle_t *pie_handle, uint8_t handshake,
                                 uint8_t ownership, uint8_t own_polarity, uint8_t enable,
                                 uint32_t linewidth, uint8_t rowheight, int channel_num);
void pie_input_dma_dump_handle_regs(struct pie_handle_t *pie_handle, uint8_t idma_num);

int pie_depogoizer_set_config(struct pie_handle_t *pie_handle, uint8_t outputformat,
                              uint8_t pogo_bpp, uint8_t colorswap, uint8_t monochan);
void pie_depogoizer_dump_handle_regs(struct pie_handle_t *pie_handle);
int pie_depogoizer_get_output_lines(struct pie_handle_t *pie_handle, unsigned int *out_lines,
                                    unsigned int cap_at_max);
int pie_depogoizer_get_input_lines(struct pie_handle_t *pie_handle, unsigned int *in_lines,
                                   unsigned int cap_at_max);
int pie_depogoizer_get_discard_lines(struct pie_handle_t *pie_handle, unsigned int *discard_lines);

void pie_output_dma_set_parms(struct pie_handle_t *pie_handle, uint8_t handshake,
                              uint8_t ownership, uint8_t own_polarity, uint8_t enable,
                              uint32_t linewidth);

int pie_ot_pogoizer_set_config(struct pie_handle_t *pie_handle, uint8_t ot_inputformat,
                               uint8_t pogo_ot_bpp);
int pie_ot_pogoizer_set_input_format(struct pie_handle_t *pie_handle, uint32_t pogo_ot_bpp,
                                      bool pack_ot_data);
int pie_ot_pogoizer_get_valid_bits_per_pixel(struct pie_handle_t *pie_handle, uint32_t *pogo_ot_bpp);
int pie_ot_pogoizer_get_bits_per_pixel(struct pie_handle_t *pie_handle, uint32_t *pogo_ot_bpp);
void pie_ot_input_dma_set_parms(struct pie_handle_t *pie_handle, uint8_t handshake,
                                uint8_t ownership, uint8_t own_polarity, uint8_t enable,
                                uint32_t linewidth, uint8_t rowheight);
void pie_ot_output_dma_set_parms(struct pie_handle_t *pie_handle, uint8_t handshake,
                                 uint8_t ownership, uint8_t own_polarity, uint8_t enable,
                                 uint32_t linewidth);
int pie_ot_depogoizer_set_config(struct pie_handle_t *pie_handle, uint8_t ot_outputformat,
                                 uint8_t pogo_ot_bpp);
int pie_ot_depogoizer_set_output_format(struct pie_handle_t *pie_handle, uint32_t pogo_ot_bpp,
                                        bool pack_ot_data);
int pie_ot_depogoizer_get_valid_bits_per_pixel(struct pie_handle_t *pie_handle, uint32_t *pogo_ot_bpp);
int pie_ot_depogoizer_get_bits_per_pixel(struct pie_handle_t *pie_handle, uint32_t *pogo_ot_bpp);
void pie_otmarb_set_bypass(struct pie_handle_t *pie_handle, bool bypass);

void pie_common_set_ot_bypass(struct pie_handle_t *pie_handle, bool bypass);
bool pie_common_get_ot_odma_enabled(struct pie_handle_t *pie_handle);
void pie_odma_set_dump_data(struct pie_handle_t *pie_handle, uint8_t dump_data);
void pie_output_dma_dump_handle_regs(struct pie_handle_t *pie_handle);

void pie_bde_set_lut(struct pie_handle_t *pie_handle, uint32_t *data, uint32_t num_entries, int channel);
void pie_bde_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
void pie_bde_dump_handle_regs(struct pie_handle_t *pie_handle, int channel);
void pie_bde_dump_handle_lut(struct pie_handle_t *pie_handle, int channel);

void pie_rgb2esrgb_set_extraregs(struct pie_handle_t *pie_handle, int associated_lut, uint32_t regval);
void pie_rgb2esrgb_set_lut(struct pie_handle_t *pie_handle, uint32_t *data, uint32_t num_entries, int lutnum);
void pie_rgb2esrgb_dump_handle_lut(struct pie_handle_t *pie_handle);
void pie_rgb2esrgb_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
void pie_rgb2esrgb_dump_handle_regs(struct pie_handle_t *pie_handle);

void pie_esrgb2ycc_set_coeff(struct pie_handle_t *pie_handle, uint32_t *coefficients);
void pie_esrgb2ycc_dump_coeff(struct pie_handle_t *pie_handle);
void pie_esrgb2ycc_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
void pie_esrgb2ycc_dump_handle_regs(struct pie_handle_t *pie_handle);

void pie_ycc2esrgb_set_coeff(struct pie_handle_t *pie_handle, uint32_t *coefficients);
void pie_ycc2esrgb_dump_coeff(struct pie_handle_t *pie_handle);
void pie_ycc2esrgb_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
void pie_ycc2esrgb_dump_handle_regs(struct pie_handle_t *pie_handle);

void pie_tcns_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
void pie_tcns_set_lut(struct pie_handle_t *pie_handle, struct ycc_values *lut, int lut_num);
void pie_tcns_dump_handle_lut(struct pie_handle_t *pie_handle);
void pie_tcns_dump_handle_regs(struct pie_handle_t *pie_handle);

void pie_sccsc_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
void pie_sccsc_whitemap_enable(struct pie_handle_t *pie_handle, bool enable);
void pie_sccsc_whitemap_thresh(struct pie_handle_t *pie_handle, uint16_t ch0, uint16_t ch1, uint16_t ch2);
void pie_sccsc_whitemap_response(struct pie_handle_t *pie_handle, uint16_t ch0, uint16_t ch1, uint16_t ch2);
void pie_sccsc_blackmap_mode(struct pie_handle_t *pie_handle, uint8_t mode);
void pie_sccsc_blackmap_response(struct pie_handle_t *pie_handle, uint16_t ch0, uint16_t ch1, uint16_t ch2);
void pie_sccsc_dump_handle_regs(struct pie_handle_t *pie_handle);

void pie_dsmf_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
void pie_dsmf_dump_handle_regs(struct pie_handle_t *pie_handle);
void pie_dsmf_dump_handle_luts(struct pie_handle_t *pie_handle);
void pie_dsmf_setup_ctl(struct pie_handle_t *pie_handle, bool test_mixed, bool test_halftone,
                        bool test_text, bool test_isolated, bool alpha_filter_en,
                        uint8_t filt_idx_sel, uint8_t ot_out_sel);
void pie_dsmf_set_proj_thresh(struct pie_handle_t *pie_handle, uint16_t horiz, uint16_t vert, uint16_t diag);
void pie_dsmf_set_isolated_thresh(struct pie_handle_t *pie_handle, uint8_t horiz, uint8_t vert, uint8_t diag);
void pie_dsmf_set_3x3text_thresh(struct pie_handle_t *pie_handle, uint8_t horiz, uint8_t vert, uint8_t diag);
void pie_dsmf_set_3x3mixed_thresh(struct pie_handle_t *pie_handle, uint8_t horiz, uint8_t vert, uint8_t diag);
void pie_dsmf_set_5x5text_thresh(struct pie_handle_t *pie_handle, uint8_t horiz, uint8_t vert, uint8_t diag);
void pie_dsmf_set_5x5mixed_thresh(struct pie_handle_t *pie_handle, uint8_t horiz, uint8_t vert, uint8_t diag);
void pie_dsmf_set_line_detection_thresh(struct pie_handle_t *pie_handle, uint8_t horiz, uint8_t vert, uint8_t diag, uint8_t diag1, uint8_t diag2);
void pie_dsmf_setup_sculptor_config(struct pie_handle_t *pie_handle, int scale_10, int scale_15, int scale_20,
                                    int lut_output_scale, int offset, bool use_erosion, bool use_dilation, bool te_use_5x5_matrix );
void pie_dsmf_set_filtctl_lut(struct pie_handle_t *pie_handle, const uint32_t * conv_filter_coeff_sel,
                              const uint32_t * ai_lut_y_sel, const uint32_t * ai_lut_c_sel,
                              const uint32_t * unsharp_mask_en, const uint32_t * te_enhance_en,
                              uint32_t num_entries);
void pie_dsmf_set_filtctl_lut_raw(struct pie_handle_t *pie_handle, uint32_t *lut);
void pie_dsmf_setup_te(struct pie_handle_t *pie_handle, bool use_mf_te,
                       uint32_t te_count_black_min,  uint32_t te_count_white_min,   uint32_t te_count_white_plus_black_min,
                       uint32_t te_center_color_max, uint32_t te_intense_color_max, uint32_t te_black_y_max,
                       uint32_t te_black_CbCr_max,   uint32_t te_white_y_min,       uint32_t te_white_CbCr_max);
void pie_dsmf_set_seg_proj_lut(struct pie_handle_t *pie_handle, uint32_t *lut);
void pie_dsmf_set_ai_lut0(struct pie_handle_t *pie_handle, int8_t *y_lut, uint32_t y_len, int8_t *crcb_lut, uint32_t crcb_len);
void pie_dsmf_set_ai_lut1(struct pie_handle_t *pie_handle, int8_t *y_lut, uint32_t y_len, int8_t *crcb_lut, uint32_t crcb_len);
void pie_dsmf_set_varcoeff_y(struct pie_handle_t *pie_handle, uint32_t filter_number, const int32_t * y_coefficients, uint32_t length);
void pie_dsmf_set_varcoeff_crcb(struct pie_handle_t *pie_handle, uint32_t filter_number, const int32_t * crcb_coefficients, uint32_t length);
void pie_dsmf_set_filt_mult(struct pie_handle_t *pie_handle, uint32_t filter_number, uint32_t y_mult, uint32_t crcb_mult);
void pie_dsmf_set_filt_shift(struct pie_handle_t *pie_handle, uint32_t filter_number, uint32_t y_shift, uint32_t crcb_shift);
uint32_t pie_dsmf_get_eaten_border_pixels(struct pie_handle_t *pie_handle);

void pie_xyscale_get_fw_rev(struct pie_handle_t *pie_handle, uint32_t *version, uint32_t *config);
void pie_xyscale_set_roundup(struct pie_handle_t *pie_handle, uint8_t ru);
void pie_xyscale_set_linear_mode(struct pie_handle_t *pie_handle, uint8_t lm);
uint8_t pie_xyscale_get_linear_mode(struct pie_handle_t *pie_handle);
void pie_xyscale_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
bool pie_xyscale_get_bypass(struct pie_handle_t *pie_handle);
void pie_xyscale_set_column_cnt(struct pie_handle_t *pie_handle, uint32_t col_cnt);
void pie_xyscale_set_replicate_mode(struct pie_handle_t *pie_handle, uint8_t rm);
void pie_xyscale_set_fill_color(struct pie_handle_t *pie_handle, uint8_t fillcolor0, uint8_t fillcolor1,
                                uint8_t fillcolor2);
void pie_xyscale_set_scale(struct pie_handle_t *pie_handle, uint32_t x_scale, uint32_t y_scale);
void pie_xyscale_calculate_and_set_scale(struct pie_handle_t *pie_handle, float x_factor, float y_factor);
void pie_xyscale_set_edge_pixel_cnt(struct pie_handle_t *pie_handle, uint8_t edge_pixel_cnt);
void pie_xyscale_set_minus_scale(struct pie_handle_t *pie_handle, uint32_t x_minus, uint32_t y_minus);
void pie_xyscale_set_transpose(struct pie_handle_t *pie_handle, uint32_t x_trans, uint32_t y_trans);
void pie_xyscale_set_y_percentage(struct pie_handle_t *pie_handle, uint32_t yper);
void pie_xyscale_set_values(struct pie_handle_t *pie_handle, uint8_t ru, uint8_t lm, uint8_t bypass,
                            uint32_t col_cnt, uint8_t fillcolor0, uint8_t fillcolor1,
                            uint8_t fillcolor2, uint32_t x_scale, uint32_t y_scale,
                            uint32_t x_minus, uint32_t y_minus, uint32_t x_trans,
                            uint32_t y_trans, uint32_t yper, uint8_t replicate, uint8_t edge_pix_cnt);
int pie_xyscale_get_output_lines(struct pie_handle_t *pie_handle, unsigned int *out_lines,
                                 unsigned int cap_at_max);
int pie_xyscale_get_input_lines(struct pie_handle_t *pie_handle, unsigned int *in_lines,
                                unsigned int cap_at_max);
int pie_xyscale_get_output_width(struct pie_handle_t *pie_handle, unsigned int *out_w);
int pie_xyscale_get_discard_lines(struct pie_handle_t *pie_handle, unsigned int *discard_lines);

struct pie_handle_t *pie_create_new_default_handle(void);
struct pie_handle_t *pie_do_get_default(struct pie_handle_t *existing);

void pie_xyscale_dump_handle_regs(struct pie_handle_t *pie_handle);

void pie_xy_c_scale_dump_handle_regs(struct pie_handle_t *pie_handle);
void pie_xy_c_scale_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
bool pie_xy_c_scale_get_bypass(struct pie_handle_t *pie_handle);
void pie_xy_c_scale_set_scale(struct pie_handle_t *pie_handle, uint32_t x_scale, uint32_t y_scale);
void pie_xy_c_scale_set_output_column_cnt(struct pie_handle_t *pie_handle, uint32_t pixels_out);
void pie_xy_c_scale_set_fill_color(struct pie_handle_t *pie_handle, uint8_t fillcolor0, uint8_t fillcolor1,
                                    uint8_t fillcolor2);
void pie_xy_c_scale_set_transpose(struct pie_handle_t *pie_handle, uint32_t x_trans, uint32_t y_trans);
void pie_xy_c_scale_set_replicate_mode(struct pie_handle_t *pie_handle, uint8_t rm);

void pie_xy_c_scale_calculate_and_set_scale(struct pie_handle_t *pie_handle, float x_factor, float y_factor);

int pie_xy_c_scale_get_output_lines(struct pie_handle_t *pie_handle, unsigned int *out_lines,
                                    unsigned int cap_at_max);
int pie_xy_c_scale_get_input_lines(struct pie_handle_t *pie_handle, unsigned int *in_lines,
                                   unsigned int cap_at_max);
int pie_xy_c_scale_get_discard_lines(struct pie_handle_t *pie_handle, unsigned int *discard_lines);
int pie_xy_c_scale_get_output_width(struct pie_handle_t *pie_handle, unsigned int *out_w);

void pie_colorshift_setup(struct pie_handle_t *pie_handle,
                          uint8_t round_mode, uint8_t line_mode,
                          uint8_t red_multmode,  uint8_t green_multmode,  uint8_t blue_multmode,
                          uint8_t red_shiftmult, uint8_t green_shiftmult, uint8_t blue_shiftmult);
void pie_colorshift_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
void pie_colorshift_dump_handle_regs(struct pie_handle_t *pie_handle);

void pie_cstats_set_enable(struct pie_handle_t *pie_handle, bool enable);
void pie_cstats_set_cmode(struct pie_handle_t *pie_handle, uint8_t cmode);
void pie_cstats_set_margins(struct pie_handle_t *pie_handle, uint32_t left, uint32_t right);
void pie_cstats_set_strip_width(struct pie_handle_t *pie_handle, uint32_t width_in_pixels);
void pie_cstats_set_rgb_threshold(struct pie_handle_t *pie_handle, uint32_t value);
void pie_cstats_set_white_threshold(struct pie_handle_t *pie_handle, uint32_t value);
void pie_cstats_set_black_threshold(struct pie_handle_t *pie_handle, uint32_t value);
void pie_cstats_histogram(struct pie_handle_t *pie_handle, uint8_t which);
void pie_cstats_set_input_mux(struct pie_handle_t *pie_handle, uint8_t which);
void pie_cstats_set_sram(struct pie_handle_t *pie_handle, int sram_idx, uint32_t sram[], int sram_size);
void pie_cstats_get_sram(struct pie_handle_t *pie_handle, int sram_idx, uint32_t sram[], int sram_size);
void pie_cstats_dump_handle_regs(struct pie_handle_t *pie_handle);
void pie_cstats_dump_handle_luts(struct pie_handle_t *pie_handle);

void pie_ngadjust_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
void pie_ngadjust_set_lut(struct pie_handle_t *pie_handle, uint8_t *c1_lut, uint8_t *c2_lut);
void pie_ngadjust_dump_handle_regs(struct pie_handle_t *pie_handle);
void pie_ngadjust_dump_handle_lut(struct pie_handle_t *pie_handle);

void pie_decim_dump_handle_regs(struct pie_handle_t *pie_handle);
void pie_decim_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
void pie_decim_set_div(struct pie_handle_t *pie_handle, uint8_t div_x, uint8_t div_y);
void pie_decim_set_start(struct pie_handle_t *pie_handle, uint8_t start);

void pie_clippad_dump_handle_regs(struct pie_handle_t *pie_handle);
void pie_clippad_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
void pie_clippad_set_pad_left(struct pie_handle_t *pie_handle, bool edgefill, int length);
void pie_clippad_set_pad_right(struct pie_handle_t *pie_handle,bool edgefill, int length);
void pie_clippad_set_trunc_left(struct pie_handle_t *pie_handle, int column);
void pie_clippad_set_trunc_right(struct pie_handle_t *pie_handle, int column);



void pie_dump_handle_regs(struct pie_handle_t *pie_handle, int num_idmas);
void pie_clone_regs(struct pie_handle_t *src_pie_handle, struct pie_handle_t *dest_pie_handle, int num_idmas);
void pie_update_write_only_regs(struct pie_handle_t *pie_handle);
void pie_bypass_all_pie_subblocks(struct pie_handle_t *pie_handle);


int pie_pogo_fmt_type_parms(int pogo_fmt_type_in, int pogo_fmt_type_out, int pogo_bpp_input,
                            int *idma_Bpp, int *odma_Bpp, int *num_idma_channels);
int pie_pogo_get_output_bytes_per_pixel(int pogo_fmt_type_out);

void pie_distort_set_filter_bypass(struct pie_handle_t *pie_handle, bool bypass);
bool pie_distort_get_filter_bypass(struct pie_handle_t *pie_handle);
void pie_antifcor_set_bypass(struct pie_handle_t *pie_handle, bool bypass);
void pie_distort_set_enable_colors(struct pie_handle_t *pie_handle, bool color3, bool color2, bool color1);
void pie_distort_set_strip_dimensions(struct pie_handle_t *pie_handle, unsigned int width, unsigned int height, unsigned int offset);
void pie_distort_set_input_dimensions(struct pie_handle_t *pie_handle, unsigned int width_ch1, unsigned int height_ch1, unsigned int width_ch2, unsigned int height_ch2, unsigned int width_ch3, unsigned int height_ch3);
void pie_distort_set_start_position_x(struct pie_handle_t *pie_handle, int whole_ch1, int fractional_ch1, int whole_ch2, int fractional_ch2, int whole_ch3, int fractional_ch3);
void pie_distort_set_start_position_y(struct pie_handle_t *pie_handle, int whole_ch1, int fractional_ch1, int whole_ch2, int fractional_ch2, int whole_ch3, int fractional_ch3);
void pie_distort_set_row_step_size_x(struct pie_handle_t *pie_handle, unsigned int step_ch1, unsigned int step_ch2, unsigned int step_ch3);
void pie_distort_set_row_step_size_y(struct pie_handle_t *pie_handle, unsigned int step_ch1, unsigned int step_ch2, unsigned int step_ch3);
void pie_distort_set_col_step_size_x(struct pie_handle_t *pie_handle, unsigned int step_ch1, unsigned int step_ch2, unsigned int step_ch3);
void pie_distort_set_col_step_size_y(struct pie_handle_t *pie_handle, unsigned int step_ch1, unsigned int step_ch2, unsigned int step_ch3);
void pie_distort_set_blank_value(struct pie_handle_t *pie_handle, unsigned int ch1, unsigned int ch2, unsigned int ch3);
void pie_distort_idma_set_image_width(struct pie_handle_t *pie_handle, int instance, unsigned int line_width_bytes);

void pie_distort_idma_set_configuration(struct pie_handle_t *pie_handle,
                                        int instance, bool enable, int beats,
                                        int ownpolarity, int ownwritedisable,
                                        int outputselect, int descawcache,
                                        int descarcache, int dataaxcache);
void pie_common_set_distort_dma(struct pie_handle_t *pie_handle, bool enabled);
bool pie_common_get_distort_dma_enabled(struct pie_handle_t *pie_handle);

// revision values - this driver is designed to work with the version specified (and earlier)

#define PIE_COMMON_MAJ_REV0     (0 << PIE_COMMON_REV0_MAJ_SHIFT)
#define POGOIZER_MAJ_REV        (6 << POGOIZER_REV0_MAJ_SHIFT)
#define DEPOGOIZER_MAJ_REV      (6 << DEPOGOIZER_REV0_MAJ_SHIFT)
#define POGO_ODMA_UDMA_MAJ_REV  (1 << POGO_ODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define POGO_ODMA_CORE_MAJ_REV  (1 << POGO_ODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_SHIFT)
#define POGO_IDMA_UDMA_MAJ_REV  (1 << POGO_IDMA0_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define POGO_IDMA_CORE_MAJ_REV  (1 << POGO_IDMA0_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT)

#define OTPOGOIZER_MAJ_REV      (6 << OTPOGOIZER_REV0_MAJ_SHIFT)
#define OTDEPOGOIZER_MAJ_REV    (6 << OTDEPOGOIZER_REV0_MAJ_SHIFT)
#define POGO_OTIDMA_UDMA_MAJ_REV  (1 << OT_POGO_IDMA_POGO_IDMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define POGO_OTIDMA_CORE_MAJ_REV  (1 << OT_POGO_IDMA_POGO_IDMA_CORE_ITR1_TAGMAJ_SHIFT)
#define POGO_OTODMA_UDMA_MAJ_REV  (1 << POGO_OTODMA_POGO_ODMA_UDMA_UTR0_TAGMAJ_SHIFT)
#define POGO_OTODMA_CORE_MAJ_REV  (1 << POGO_OTODMA_POGO_ODMA_CORE_OTR1_TAGMAJ_SHIFT)

#define PIE_OTMARB_MAJ_REV0      (1 << OTMARB_REV0_MAJ_SHIFT);

#define PIE_COLORSHIFT_MAJ_REV0 (2 << COLORSHIFT_REV0_MAJ_SHIFT)
#define PIE_XYSCALE_MAJ_REV0    (3 << XYSCALE_REV0_MAJ_SHIFT)
#define PIE_XY_C_SCALE_MAJ_REV0 (3 << XYCSCALE_REV0_MAJ_SHIFT)
#define PIE_RGB2YCC_MAJ_REV0    (4 << ES2Y_REV0_MAJ_SHIFT)
#define PIE_YCC2RGB_MAJ_REV0    (4 << Y2ES_REV0_MAJ_SHIFT)
#define PIE_RGB2ESRGB_MAJ_REV0  (1 << LUT1D_RGB2ESRGB_REV0_MAJ_SHIFT)
#define PIE_DSMF_MAJ_REV0       (1 << DSMF_REV0_MAJ_SHIFT)
#define PIE_TCNS_MAJ_REV0       (3 << TCNSENSE_REV0_MAJ_SHIFT)
#define PIE_CSTATS_MAJ_REV0     (3 << CSTATS_REV0_MAJ_SHIFT)
#define PIE_NGADJUST_MAJ_REV0   (4 << NGADJUST_REV0_MAJ_SHIFT)
#define PIE_SCCSC_MAJ_REV       (2 << SCCSC_REV_MAJ_SHIFT)
#define PIE_DISTORT_MAJ_REV0    (6 << DISTORT_TOP_DISTORT_REV0_MAJ_SHIFT)
#define PIE_DISTORT_ANTIFCOR_MAJ_REV0  (2 << DISTORT_TOP_ANTIFCOR_TOP_ANTIFCOR_REV0_MAJ_SHIFT)
#define PIE_DISTORT_DMA_MAJ_REV (2 << DISTORT_TOP_ANTIFCOR_TOP_DDMA_AC_DATA0_UTR0_TAGCFG_SHIFT)
#define PIE_DECIM_MAJ_REV0      (1 << DECIM_REV0_MAJ_SHIFT)
#define PIE_CLIPPAD_MAJ_REV0    (1 << CLIPPAD_REV0_MAJ_SHIFT)
#define PIE_BDE_MAJ_REV0        (1 << DISTORT_TOP_ANTIFCOR_TOP_LUT1D_BDE0_REV0_MAJ_SHIFT)
#endif
