/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef PIC_WDMA_CHANNELIF_H_
#define PIC_WDMA_CHANNELIF_H_

// interface exported up from c file

/////////////////////////////////////////////////////////////////////////////
// structure passed to pic_output_data.c - device_data will be opaque to it
/////////////////////////////////////////////////////////////////////////////
typedef struct picWdmaChannelDeviceHandle
{
    struct pic_wdma_channel_function_struct *fcn_tbl;
    picWdmaChannelData *device_data;
} picWdmaChannelDeviceHandle;


/////////////////////////////////////////////////////////////////////////////
// function table
/////////////////////////////////////////////////////////////////////////////
struct pic_wdma_channel_function_struct
{
    void (*pic_reset)              (picWdmaChannelData *device_data);
    void (*pic_configure)          (picWdmaChannelData *device_data, struct pic_handle_t *pic_handle);
    void (*pic_get_current)        (picWdmaChannelData *device_data, struct pic_handle_t *pic_handle);
    int (*pic_revcheck)            (picWdmaChannelData *device_data, struct pic_handle_t *pic_handle);
    
    void (*pic_dump_regs)       (picWdmaChannelData *device_data);

    // SANDRA, WHICH OF THESE CAN WE REMOVE??
    void (*clear_wdma_channel_irqs) (picWdmaChannelData *device_data,
                                     struct pic_output_dma_interrupt_info *intstruct);
    void (*enable_wdma_channel_irqs) (picWdmaChannelData *device_data,
                                      struct pic_output_dma_interrupt_info *int_info);
    void (*disable_wdma_channel_irqs) (picWdmaChannelData *device_data,
                                       struct pic_output_dma_interrupt_info *int_info);
    void (*force_wdma_channel_irqs) (picWdmaChannelData *device_data, 
                                     struct pic_output_dma_interrupt_info *int_info);
    void (*handle_wdma_channel_irqs) (picWdmaChannelData *device_data);
    int (*start_wdma_channel) (picWdmaChannelData *device_data, dma_addr_t phys_addr);
    void (*get_status_wdma_channel) (picWdmaChannelData *device_data, struct pic_wdma_status_info *info);
    bool (*is_enabled_wdma_channel)(picWdmaChannelData *device_data);
    void (*get_trans_len_wdma_channel) (picWdmaChannelData *device_data, uint32_t *len);

};

#endif 
