/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIC_PD_IF_H_
#define _PIC_PD_IF_H_

// interface exported up from c file

/////////////////////////////////////////////////////////////////////////////
// structure passed to pic.c - device_data will be opaque to pic.c
/////////////////////////////////////////////////////////////////////////////
typedef struct prnuDsnuDeviceHandle
{
    struct pic_pd_function_struct *fcn_tbl;
    picPrnuDsnuData *device_data;
} prnuDsnuDeviceHandle;

/////////////////////////////////////////////////////////////////////////////
// function table
/////////////////////////////////////////////////////////////////////////////
struct pic_pd_function_struct
{
    void (*pic_reset)              (picPrnuDsnuData *device_data);
    void (*pic_configure)          (picPrnuDsnuData *device_data, struct pic_handle_t *pic_handle);
    void (*pic_get_current)        (picPrnuDsnuData *device_data, struct pic_handle_t *pic_handle);
    int (*pic_revcheck)            (picPrnuDsnuData *device_data, struct pic_handle_t *pic_handle);
    
    void (*pic_dump_regs)          (picPrnuDsnuData *device_data);
};
#endif
