/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIC_WDMA_IF_H_
#define _PIC_WDMA_IF_H_

// interface exported from pic_output_dma for pic.c

typedef struct output_dma_data
{
    struct output_dma_function_struct *fcn_tbl;
    outputDmaData *device_data;
} outputDmaDeviceHandle;

void pic_output_dma_init(int pic_instance);
void pic_output_dma_exit(int pic_instance);

/////////////////////////////////////////////////////////////////////////////
// function tables passed to pic.c
struct output_dma_function_struct
{
    void (*pic_reset) (outputDmaData *odma_object);
    void (*pic_configure) (outputDmaData *output_dma_object, struct pic_handle_t *pic_handle);
    void (*pic_get_current) (outputDmaData *output_dma_object, struct pic_handle_t *pic_handle);
    int  (*pic_revcheck) (outputDmaData *output_dma_object, struct pic_handle_t *pic_handle);
    
    void (*dump_channel_regs) (outputDmaData *output_dma_object, char channel);
    void (*dump_all_regs) (outputDmaData *odma_object);
    void (*clear_output_dma_irqs) (outputDmaData *odma_object,
                                   struct pic_output_dma_interrupt_info *irqstruct,
                                   int dma_channel);
    int (*start_output_dma) (outputDmaData *odma_object, uint8_t channel,
                              dma_addr_t phys_desc);
    void (*output_dma_get_channel_status) (outputDmaData *odma_object,
                                           struct pic_wdma_status_info *info,
                                           uint8_t channel);
    bool (*output_dma_channel_status_busy) (outputDmaData *output_dma_object,
                                            uint8_t channel);
    bool (*output_dma_channel_is_enabled) (outputDmaData *output_dma_object,
                                            uint8_t channel);
    void (*output_dma_channel_get_trans_len) (outputDmaData *output_dma_object,
                                              uint32_t *trans_len, uint8_t channel);
    void (*enable_output_dma_irqs) (outputDmaData *odma_object,
                                    struct pic_output_dma_interrupt_info *irqstruct,
                                    uint8_t channel, bool enable);
    void (*handle_dma_channels_irqs) (outputDmaData *output_dma_object);
    void (*pic_get_output_dma_sizes_array) (uint32_t *subblock_array,
                                            void *input_object);
    
};


#endif  
