/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIC_OUTPUT_DMA_DRIVER_H_
#define _PIC_OUTPUT_DMA_DRIVER_H_

// interface between the pic_output_dma and the blocks below it

#define PIC_WDMA_INT_VALID_VERSION 1

enum output_dma_subblock {wdma=0, wdma_channel};

struct pic_odma_reset_struct
{
    char force_last_burst;
    char soft_reset;
    
    bool force_last_burst_valid;
    bool soft_reset_valid;
};

void register_pic_output_dma_device_data(enum output_dma_subblock wdmasubblock,
                                         void *device_data,
                                         int pic_instance, int WDMA_instance);

void *unregister_pic_output_dma_device_data(enum output_dma_subblock wdmasubblock,
                                            int pic_instance, int WDMA_instance);

#endif
