/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIC_HANDLE_H_
#define _PIC_HANDLE_H_

#include "pic_constants.h"
/////////////////////////////////////////////////////////////////
// The definition of the structure for the PIC block
// This contains every register in PIC.
// The upper level code only sees this as a handle - they should
// never be able to include this file and peek inside (data hiding)
/////////////////////////////////////////////////////////////////

struct pic_handle_t
{
    uint32_t pic_handle_size;
    uint32_t subblock_size_table[max_subblock_pic];
    // interrupt callback functions
    // add callbacks and callback data here as subblock drivers are added
    int (*pic_common_callback) (void *, void *);
    void *pic_common_callback_data;
    int (*pic_odma_callback[MAX_OUTPUT_DMAS]) (void *, void *);
    void *pic_odma_callback_data[MAX_OUTPUT_DMAS];    
    int (*pic_idma2d_callback) (void *, void *);
    void *pic_idma2d_callback_data;

    // each subblock here - if value is NULL, we never instantiated the subblock
    PIC_REGS_t *pic_common;
    ADCNORM_REGS_t *pic_adcnorm;
    BULBMON_REGS_t *pic_bulbmon;
    LRMARGIN0_REGS_t *pic_lrmargin[MAX_NUM_LRMARGIN_BLOCKS];
    PRNUDSNU_REGS_t *pic_pd;
    HSCALE_REGS_t *pic_hscale;
    NEWMAN_REGS_t *pic_chipgap;
    IDMA_2D_REGS_t *pic_idma_2d;
    PIC_WDMA_REGS_t *pic_wdma;
    PIC_WDMA_DMA0_REGS_t *pic_wdma_channel[MAX_OUTPUT_DMAS];
    BITREDUCT_REGS_t *pic_bitreduct;
    PS_ESD_REGS_t *pic_ps_esd;
    HFIR_REGS_t *pic_hfir;
    SKEWDET_REGS_t *pic_skewdet;
    SKEW_ODMA_REGS_t *pic_skew_odma;
    ANTIFLIN_REGS_t *pic_antiflin;
    ANTIFLIN_WDMA0_REGS_t *pic_antiflin_wdma0;
    ANTIFLIN_WDMA1_REGS_t *pic_antiflin_wdma1;
    ANTIFLIN_WDMA2_REGS_t *pic_antiflin_wdma2;
    // The shadow registers go here - dynamically allocated by pic_create_new_default_handle().
    // The subblock pointers will give access to these after a call to pic_fixup_shadow_pointers().
    uint32_t *shadow_regs;
};

#endif /* _PIC_HANDLE_H_ */
