/*
 ***************************************************************************************
 * (c) Copyright 2015 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIC_DRIVERLIB_IF_H_
#define _PIC_DRIVERLIB_IF_H_


// pic_driverlib declares its functions here for pic drivers and
// pic_convenience
uint32_t *pic_get_subblock_sizes(void);
void pic_common_set_all_irqstruct(struct pic_common_ints *irqstruct, bool setval);
void pic_idma2d_set_all_irqstruct(struct pic_idma2d_interrupt_info *irqstruct, bool setval);
void pic_output_set_all_irqstruct(struct pic_output_dma_interrupt_info *irqstruct,
                                  bool setval);

uint32_t pic_common_convert_irqstruct_to_update_reg(struct pic_common_ints *irqstruct,
                                                    uint32_t pic_common_reg,
                                                    bool set_true_clear_false);
uint32_t pic_idma2d_convert_irqstruct_to_update_reg(struct pic_idma2d_interrupt_info *irqstruct,
                                                    uint32_t curr_irqs,
                                                    bool enable);
uint32_t pic_output_convert_irqstruct_to_update_reg(struct pic_output_dma_interrupt_info *irqstruct,
                                                    uint32_t ints,
                                                    bool set_to_one);

void pic_common_convert_uintarray_to_irqstruct(struct pic_common_ints *irqstruct,
                                               uint32_t curr_irqs);
                                               
void pic_output_convert_uintarray_to_irqstruct(struct pic_output_dma_interrupt_info *irqstruct,
                                               uint32_t curr_irqs);

void pic_idma2d_convert_uintarray_to_irqstruct(struct pic_idma2d_interrupt_info *irqstruct,
                                               uint32_t curr_irqs);

void pic_fixup_shadow_pointers(struct pic_handle_t *pic_handle);

// These are common functions/definitions between pic and pie - for any code that
// is including the driverlib_if.h from pic and pie, make sure this part is not included
// multiple times.

#ifndef PIC_PIE_IMAGING_COMMON_MACROS
#define PIC_PIE_IMAGING_COMMON_MACROS

#ifdef __KERNEL__
#include <linux/slab.h>
#include <linux/vmalloc.h>
#define allocate_memory(size, type) vmalloc(size)
#define free_memory(pointer) vfree(pointer)
#define error_print(args...) printk(args)
#define print(args...) printk(args)

#else
// appspace (not kernel)
#define allocate_memory(size, type) malloc(size)
#define free_memory(pointer) free(pointer)

#define error_print(args...) printf(args)
#define print(args...) printf(args)

#define BUG_ON(args...) if (args) printf("%s:BUG_ON %s *********** \n", __func__, #args);
#define BUG() printf("%s:BUG at line %d  *********** \n", __func__, __LINE__);
#define EXPORT_SYMBOL(name)

#define EINVAL 22
#endif // __KERNEL__

//#define DURING_DEBUG 1

#ifdef DURING_DEBUG
  #define debug_print(args...) print(args)
#else
#define debug_print(args...)
#endif

#endif // PIC_PIE_IMAGING_COMMON_MACROS



#endif
