/*
 ***************************************************************************************
 * (c) Copyright 2014 Marvell International Ltd.
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/old-licenses/gpl-2.0.html.
 *
 **************************************************************************************
 */

#ifndef _PIC_driver_H_
#define _PIC_driver_H_

// interface between pic.c and the layer below it

enum pic_internal_subblock{common=0, adcnorm, bulbmon, lrmargin, idma2d, pd, chipgap, ps_esd, hfir,
                           hscale, skew, skew_odma, flare, flare_wdma, bdr,  output_dma, last_pic_subblock};

typedef struct output_dma_data output_dmaDeviceHandle;

//registration function - subblocks register at init or probe time, and unregister at remove time
void register_pic_subblock(enum pic_internal_subblock picsubblock, void *pic_subblock_data, int instance,
                           int subblock_instance);
void *unregister_pic_subblock(enum pic_internal_subblock, int instance, int subblock_instance);

// pic_output_dma can ask for its output_dma_object: during low-level device registration/unregistration
//   Otherwise, any function in pic_output_dma should have been called by pic with its object
output_dmaDeviceHandle *get_output_dma_device(int pic_instance);

uint32_t pic_convert_irqstruct_to_update_reg(uint8_t pic_instance, uint32_t ints,
                                         struct pic_common_ints *irqstruct,
                                         bool set_to_one);

#endif

